/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockGasStationTop;
import de.maxhenkel.car.blocks.BlockOrientableHorizontal;
import de.maxhenkel.car.blocks.BlockTank;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.corelib.block.DirectionalVoxelShape;
import de.maxhenkel.car.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.car.gui.ContainerGasStation;
import de.maxhenkel.car.gui.ContainerGasStationAdmin;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockGasStation
extends BlockOrientableHorizontal {
    public static VoxelShape SHAPE_NORTH_SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)31.0, (double)11.0);
    public static VoxelShape SHAPE_EAST_WEST = Block.m_49796_((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)31.0, (double)14.0);
    public static VoxelShape SHAPE_SLAB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.01, (double)16.0);
    private static final DirectionalVoxelShape SHAPES = new DirectionalVoxelShape.Builder().direction(Direction.NORTH, SHAPE_NORTH_SOUTH, SHAPE_SLAB).direction(Direction.SOUTH, SHAPE_NORTH_SOUTH, SHAPE_SLAB).direction(Direction.EAST, SHAPE_EAST_WEST, SHAPE_SLAB).direction(Direction.WEST, SHAPE_EAST_WEST, SHAPE_SLAB).build();

    public BlockGasStation() {
        super(Material.f_76279_, MaterialColor.f_76404_, SoundType.f_56743_, 4.0f, 50.0f);
    }

    @Override
    public Item toItem() {
        return new BlockItem(this, new Item.Properties()){

            protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
                if (!context.m_43725_().m_46859_(context.m_8083_().m_7494_())) {
                    return false;
                }
                return super.m_40610_(context, state);
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (!(te instanceof TileEntityGasStation)) {
            return InteractionResult.FAIL;
        }
        TileEntityGasStation station = (TileEntityGasStation)te;
        ItemStack stack = player.m_21120_(handIn);
        if (station.isOwner(player) || !station.hasTrade()) {
            boolean success1;
            boolean success;
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            if (!fluidStack.isEmpty() && (success = BlockTank.handleEmpty(stack, worldIn, pos, player, handIn))) {
                return InteractionResult.SUCCESS;
            }
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
            if (handler != null && (success1 = BlockTank.handleFill(stack, worldIn, pos, player, handIn))) {
                return InteractionResult.SUCCESS;
            }
        }
        if (!player.m_6144_()) {
            if (player instanceof ServerPlayer) {
                TileEntityContainerProvider.openGui((ServerPlayer)player, station, (i, playerInventory, playerEntity) -> new ContainerGasStation(i, station, playerInventory));
            }
            return InteractionResult.SUCCESS;
        }
        if (station.isOwner(player)) {
            if (player instanceof ServerPlayer) {
                TileEntityContainerProvider.openGui((ServerPlayer)player, station, (i, playerInventory, playerEntity) -> new ContainerGasStationAdmin(i, station, playerInventory));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Direction)state.m_61143_((Property)FACING));
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity te;
        if (worldIn.m_46859_(pos.m_7494_())) {
            BlockGasStationTop cfr_ignored_0 = (BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get());
            worldIn.m_46597_(pos.m_7494_(), (BlockState)((BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get())).m_49966_().m_61124_((Property)BlockGasStationTop.FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        }
        if ((te = worldIn.m_7702_(pos)) instanceof TileEntityGasStation && placer instanceof Player) {
            TileEntityGasStation station = (TileEntityGasStation)te;
            station.setOwner((Player)placer);
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, worldIn, pos, newState, isMoving);
        BlockState stateUp = worldIn.m_8055_(pos.m_7494_());
        stateUp.m_60734_();
        if (stateUp.m_60734_().equals(ModBlocks.GAS_STATION_TOP.get())) {
            worldIn.m_46961_(pos.m_7494_(), false);
        }
        BlockGasStation.dropItems(worldIn, pos);
    }

    public static void dropItems(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityGasStation) {
            TileEntityGasStation station = (TileEntityGasStation)te;
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)station.getInventory());
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)station.getTradingInventory());
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntityGasStation(blockPos, blockState);
    }
}

