/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.corelib.block.IItemBlock;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockGui<T extends BlockEntity>
extends BlockBase
implements EntityBlock,
IItemBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    protected BlockGui(Material material, SoundType soundType, float hardness, float resistance) {
        this(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)MaterialColor.f_76404_).m_60913_(hardness, resistance).m_60918_(soundType));
    }

    protected BlockGui(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_6144_()) {
            if (!(player instanceof ServerPlayer)) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            try {
                BlockEntity tile = tileEntity;
                this.openGui(state, worldIn, pos, (ServerPlayer)player, handIn, tile);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public abstract void openGui(BlockState var1, Level var2, BlockPos var3, ServerPlayer var4, InteractionHand var5, T var6);

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (state.m_60734_() != newState.m_60734_() && tileentity instanceof Container) {
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((Container)tileentity));
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void setPowered(Level world, BlockPos pos, BlockState state, boolean powered) {
        if (((Boolean)state.m_61143_((Property)POWERED)).equals(powered)) {
            return;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        if (tileentity != null) {
            tileentity.m_6339_();
            world.m_151523_(tileentity);
        }
    }
}

