/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.blocks.tileentity.render.item.TankItemTileEntityRenderer;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.car.corelib.client.CustomRendererBlockItem;
import de.maxhenkel.car.corelib.client.ItemRenderer;
import de.maxhenkel.car.corelib.fluid.FluidUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlockTank
extends BlockBase
implements EntityBlock,
IItemBlock {
    protected BlockTank() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.5f).m_60918_(SoundType.f_56744_).m_60955_());
    }

    @Override
    public Item toItem() {
        return new CustomRendererBlockItem(this, new Item.Properties().m_41487_(1)){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public ItemRenderer createItemRenderer() {
                return new TankItemTileEntityRenderer();
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag fluidComp;
        FluidStack fluidStack;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)(fluidComp = stack.m_41783_().m_128469_("fluid")))) != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.fluid", (Object[])new Object[]{Component.m_237113_((String)fluidStack.getDisplayName().getString()).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.amount", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(fluidStack.getAmount())).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity te = worldIn.m_7702_(pos);
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank tank = (TileEntityTank)te;
        BlockTank.applyItemData(stack, tank);
        tank.synchronize();
    }

    public static void applyItemData(ItemStack stack, TileEntityTank tank) {
        if (!stack.m_41782_()) {
            tank.setFluid(FluidStack.EMPTY);
            return;
        }
        CompoundTag comp = stack.m_41783_();
        if (!comp.m_128441_("fluid")) {
            return;
        }
        CompoundTag fluidTag = comp.m_128469_("fluid");
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)fluidTag);
        tank.setFluid(fluidStack);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return FluidUtils.tryFluidInteraction(player, handIn, worldIn, pos) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public static boolean handleEmpty(ItemStack stack, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((Container)playerIn.m_150109_());
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
        if (res.isSuccess()) {
            playerIn.m_21008_(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(ItemStack stack, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler blockHandler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((Container)playerIn.m_150109_());
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)blockHandler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
        if (result.isSuccess()) {
            playerIn.m_21008_(hand, result.result);
            return true;
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter reader, BlockPos pos) {
        return 1.0f;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntityTank(blockPos, blockState);
    }
}

