/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockBackmixReactor;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityBackmixReactor
extends TileEntityBase
implements ITickableBlockEntity,
IFluidHandler,
IEnergyStorage,
Container {
    public final int maxStorage;
    protected int storedEnergy;
    public final int energyUsage;
    public final int methanolUsage;
    public final int maxMethanol;
    protected int currentMethanol;
    public final int canolaUsage;
    public final int maxCanola;
    protected int currentCanola;
    public final int maxMix;
    protected int currentMix;
    public final int mixGeneration;
    public final int generatingTime;
    protected int timeToGenerate;
    public final ContainerData FIELDS = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileEntityBackmixReactor.this.storedEnergy;
                }
                case 1: {
                    return TileEntityBackmixReactor.this.currentCanola;
                }
                case 2: {
                    return TileEntityBackmixReactor.this.currentMethanol;
                }
                case 3: {
                    return TileEntityBackmixReactor.this.currentMix;
                }
                case 4: {
                    return TileEntityBackmixReactor.this.timeToGenerate;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityBackmixReactor.this.storedEnergy = value;
                    break;
                }
                case 1: {
                    TileEntityBackmixReactor.this.currentCanola = value;
                    break;
                }
                case 2: {
                    TileEntityBackmixReactor.this.currentMethanol = value;
                    break;
                }
                case 3: {
                    TileEntityBackmixReactor.this.currentMix = value;
                    break;
                }
                case 4: {
                    TileEntityBackmixReactor.this.timeToGenerate = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };

    public TileEntityBackmixReactor(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.BACKMIX_REACTOR_TILE_ENTITY_TYPE.get(), pos, state);
        this.maxStorage = (Integer)Main.SERVER_CONFIG.backmixReactorEnergyStorage.get();
        this.storedEnergy = 0;
        this.energyUsage = (Integer)Main.SERVER_CONFIG.backmixReactorEnergyUsage.get();
        this.maxMethanol = (Integer)Main.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.maxCanola = (Integer)Main.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.maxMix = (Integer)Main.SERVER_CONFIG.backmixReactorFluidStorage.get();
        this.currentCanola = 0;
        this.currentMethanol = 0;
        this.currentMix = 0;
        this.generatingTime = (Integer)Main.SERVER_CONFIG.backmixReactorGeneratingTime.get();
        this.timeToGenerate = 0;
        this.mixGeneration = (Integer)Main.SERVER_CONFIG.backmixReactorMixGeneration.get();
        this.methanolUsage = (Integer)Main.SERVER_CONFIG.backmixReactorMethanolUsage.get();
        this.canolaUsage = (Integer)Main.SERVER_CONFIG.backmixReactorCanolaUsage.get();
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.setBlockEnabled(this.isEnabled());
        if (this.timeToGenerate > 0 && this.storedEnergy >= this.energyUsage) {
            this.storedEnergy -= this.energyUsage;
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix + this.mixGeneration <= this.maxMix) {
                this.currentMix += this.mixGeneration;
                this.currentCanola -= this.canolaUsage;
                this.currentMethanol -= this.methanolUsage;
            }
        } else if (this.storedEnergy >= this.energyUsage && this.currentCanola >= this.canolaUsage && this.currentMethanol >= this.methanolUsage && this.currentMix + this.mixGeneration <= this.maxMix) {
            this.timeToGenerate = this.generatingTime;
        }
        this.m_6596_();
    }

    public boolean isEnabled() {
        if (this.storedEnergy > 0 && this.currentMix < this.maxMix && this.currentMethanol >= this.methanolUsage) {
            return this.currentCanola >= this.canolaUsage;
        }
        return false;
    }

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        if (state.m_60734_().equals(ModBlocks.BACKMIX_REACTOR.get())) {
            ((BlockBackmixReactor)ModBlocks.BACKMIX_REACTOR.get()).setPowered(this.f_58857_, this.f_58858_, state, enabled);
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("stored_endergy", this.storedEnergy);
        compound.m_128405_("canola", this.currentCanola);
        compound.m_128405_("methanol", this.currentMethanol);
        compound.m_128405_("mix", this.currentMix);
        compound.m_128405_("time", this.timeToGenerate);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.storedEnergy = compound.m_128451_("stored_endergy");
        this.currentCanola = compound.m_128451_("canola");
        this.currentMethanol = compound.m_128451_("methanol");
        this.currentMix = compound.m_128451_("mix");
        this.timeToGenerate = compound.m_128451_("time");
        super.m_142466_(compound);
    }

    public int m_6643_() {
        return 0;
    }

    public ItemStack m_8020_(int index) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int index, int count) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int index, ItemStack stack) {
    }

    public int m_6893_() {
        return 0;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return false;
    }

    public void m_6211_() {
    }

    public boolean m_7983_() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyNeeded = this.maxStorage - this.storedEnergy;
        if (!simulate) {
            this.storedEnergy += Math.min(energyNeeded, maxReceive);
            this.m_6596_();
        }
        return Math.min(energyNeeded, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public int getCurrentCanola() {
        return this.currentCanola;
    }

    public int getCurrentMethanol() {
        return this.currentMethanol;
    }

    public int getCurrentMix() {
        return this.currentMix;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    @Override
    public Component getTranslatedName() {
        return Component.m_237115_((String)"block.car.backmix_reactor");
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 3;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return new FluidStack((Fluid)ModFluids.CANOLA_OIL.get(), this.currentCanola);
        }
        if (tank == 1) {
            return new FluidStack((Fluid)ModFluids.METHANOL.get(), this.currentMethanol);
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX.get(), this.currentMix);
    }

    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.maxCanola;
        }
        if (tank == 1) {
            return this.maxMethanol;
        }
        return this.maxMix;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank == 0) {
            return stack.getFluid().equals(ModFluids.CANOLA_OIL.get());
        }
        if (tank == 1) {
            return stack.getFluid().equals(ModFluids.METHANOL.get());
        }
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.METHANOL.get())) {
            int amount = Math.min(this.maxMethanol - this.currentMethanol, resource.getAmount());
            if (action.execute()) {
                this.currentMethanol += amount;
                this.m_6596_();
            }
            return amount;
        }
        if (resource.getFluid().equals(ModFluids.CANOLA_OIL.get())) {
            int amount = Math.min(this.maxCanola - this.currentCanola, resource.getAmount());
            if (action.execute()) {
                this.currentCanola += amount;
                this.m_6596_();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = Math.min(resource.getAmount(), this.currentMix);
        if (action.execute()) {
            this.currentMix -= amount;
            this.m_6596_();
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX.get(), amount);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int amount = Math.min(maxDrain, this.currentMix);
        if (action.execute()) {
            this.currentMix -= amount;
            this.m_6596_();
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX.get(), amount);
    }
}

