/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockGasStation;
import de.maxhenkel.car.blocks.BlockGasStationTop;
import de.maxhenkel.car.blocks.BlockOrientableHorizontal;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.CachedValue;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopTileentity;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityGasStation
extends TileEntityBase
implements ITickableBlockEntity,
IFluidHandler,
SoundLoopTileentity.ISoundLoopable {
    private FluidStack storage;
    public int maxStorageAmount = 16000;
    private final int transferRate;
    private int fuelCounter;
    private boolean isFueling;
    private boolean wasFueling;
    private SimpleContainer inventory;
    private SimpleContainer trading;
    private int tradeAmount;
    private int freeAmountLeft;
    private UUID owner;
    @Nullable
    private IFluidHandler fluidHandlerInFront;
    public final ContainerData FIELDS = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileEntityGasStation.this.fuelCounter;
                }
                case 1: {
                    if (!TileEntityGasStation.this.storage.isEmpty()) {
                        return TileEntityGasStation.this.storage.getAmount();
                    }
                    return 0;
                }
                case 2: {
                    return TileEntityGasStation.this.tradeAmount;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityGasStation.this.fuelCounter = value;
                    break;
                }
                case 1: {
                    if (TileEntityGasStation.this.storage.isEmpty()) break;
                    TileEntityGasStation.this.storage.setAmount(value);
                    break;
                }
                case 2: {
                    TileEntityGasStation.this.tradeAmount = value;
                    TileEntityGasStation.this.m_6596_();
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    private CachedValue<Vec3> center = new CachedValue<Vec3>(() -> new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5));
    private CachedValue<AABB> detectionBox = new CachedValue<AABB>(this::createDetectionBox);

    public TileEntityGasStation(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.GAS_STATION_TILE_ENTITY_TYPE.get(), pos, state);
        this.transferRate = (Integer)Main.SERVER_CONFIG.gasStationTransferRate.get();
        this.fuelCounter = 0;
        this.inventory = new SimpleContainer(27);
        this.trading = new SimpleContainer(2);
        this.owner = new UUID(0L, 0L);
        this.storage = FluidStack.EMPTY;
    }

    @Override
    public Component getTranslatedName() {
        return Component.m_237115_((String)"block.car.fuel_station");
    }

    private void fixTop() {
        BlockState top = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        BlockState bottom = this.m_58900_();
        Direction facing = (Direction)bottom.m_61143_((Property)BlockOrientableHorizontal.FACING);
        if (top.m_60734_().equals(ModBlocks.GAS_STATION_TOP.get())) {
            if (!((Direction)top.m_61143_((Property)BlockGasStationTop.FACING)).equals((Object)facing)) {
                this.f_58857_.m_46597_(this.f_58858_.m_7494_(), (BlockState)((BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get())).m_49966_().m_61124_((Property)BlockGasStationTop.FACING, (Comparable)facing));
            }
        } else if (this.f_58857_.m_46859_(this.f_58858_.m_7494_())) {
            this.f_58857_.m_46597_(this.f_58858_.m_7494_(), (BlockState)((BlockGasStationTop)((Object)ModBlocks.GAS_STATION_TOP.get())).m_49966_().m_61124_((Property)BlockGasStationTop.FACING, (Comparable)facing));
        }
    }

    @Override
    public void tick() {
        FluidStack result;
        if (this.f_58857_.m_46467_() % 100L == 0L) {
            this.fixTop();
        }
        this.fluidHandlerInFront = this.searchFluidHandlerInFront();
        if (this.fluidHandlerInFront == null) {
            if (this.fuelCounter > 0 || this.isFueling) {
                this.fuelCounter = 0;
                this.isFueling = false;
                this.synchronize();
                this.m_6596_();
            }
            return;
        }
        if (!this.isFueling) {
            return;
        }
        if (this.storage.isEmpty()) {
            return;
        }
        FluidStack s = FluidUtil.tryFluidTransfer((IFluidHandler)this.fluidHandlerInFront, (IFluidHandler)this, (int)this.transferRate, (boolean)false);
        int amountCarCanTake = 0;
        if (!s.isEmpty()) {
            amountCarCanTake = s.getAmount();
        }
        if (amountCarCanTake <= 0) {
            return;
        }
        if (this.freeAmountLeft <= 0) {
            if (this.tradeAmount <= 0) {
                this.freeAmountLeft = this.transferRate;
                this.m_6596_();
            } else if (this.removeTradeItem()) {
                this.freeAmountLeft = this.tradeAmount;
                this.m_6596_();
            } else {
                this.isFueling = false;
                this.synchronize();
                return;
            }
        }
        if (!(result = FluidUtil.tryFluidTransfer((IFluidHandler)this.fluidHandlerInFront, (IFluidHandler)this, (int)Math.min(this.transferRate, this.freeAmountLeft), (boolean)true)).isEmpty()) {
            this.fuelCounter += result.getAmount();
            this.freeAmountLeft -= result.getAmount();
            this.synchronize(100);
            this.m_6596_();
            if (!this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = true;
        } else {
            if (this.wasFueling) {
                this.synchronize();
            }
            this.wasFueling = false;
        }
    }

    public boolean removeTradeItem() {
        ItemStack tradeTemplate = this.trading.m_8020_(0);
        ItemStack tradingStack = this.trading.m_8020_(1);
        if (tradeTemplate.m_41619_()) {
            return true;
        }
        if (tradingStack.m_41619_()) {
            return false;
        }
        if (!tradeTemplate.m_41720_().equals(tradingStack.m_41720_())) {
            return false;
        }
        if (tradeTemplate.m_41773_() != tradingStack.m_41773_()) {
            return false;
        }
        if (tradingStack.m_41613_() < tradeTemplate.m_41613_()) {
            return false;
        }
        ItemStack addStack = tradingStack.m_41777_();
        addStack.m_41764_(tradeTemplate.m_41613_());
        ItemStack add = this.inventory.m_19173_(addStack);
        if (add.m_41613_() > 0) {
            return false;
        }
        tradingStack.m_41764_(tradingStack.m_41613_() - tradeTemplate.m_41613_());
        this.trading.m_6836_(1, tradingStack);
        return true;
    }

    public Container getInventory() {
        return this.inventory;
    }

    public Container getTradingInventory() {
        return this.trading;
    }

    public boolean isValidFluid(Fluid f) {
        return Main.SERVER_CONFIG.gasStationValidFuelList.stream().anyMatch(fluidTag -> fluidTag.contains(f));
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public void setOwner(Player player) {
        this.owner = new UUID(player.m_20148_().getMostSignificantBits(), player.m_20148_().getLeastSignificantBits());
        this.m_6596_();
    }

    public boolean isOwner(Player player) {
        ServerPlayer p;
        boolean isOp;
        if (player instanceof ServerPlayer && (isOp = (p = (ServerPlayer)player).m_20310_(p.f_8924_.m_7022_()))) {
            return true;
        }
        return player.m_20148_().equals(this.owner);
    }

    public boolean hasTrade() {
        return !this.trading.m_8020_(0).m_41619_();
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("counter", this.fuelCounter);
        if (!this.storage.isEmpty()) {
            CompoundTag comp = new CompoundTag();
            this.storage.writeToNBT(comp);
            compound.m_128365_("fluid", (Tag)comp);
        }
        ItemUtils.saveInventory(compound, "inventory", (Container)this.inventory);
        ItemUtils.saveInventory(compound, "trading", (Container)this.trading);
        compound.m_128405_("trade_amount", this.tradeAmount);
        compound.m_128405_("free_amount", this.freeAmountLeft);
        compound.m_128362_("owner", this.owner);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.fuelCounter = compound.m_128451_("counter");
        if (compound.m_128441_("fluid")) {
            CompoundTag comp = compound.m_128469_("fluid");
            this.storage = FluidStack.loadFluidStackFromNBT((CompoundTag)comp);
        }
        ItemUtils.readInventory(compound, "inventory", (Container)this.inventory);
        ItemUtils.readInventory(compound, "trading", (Container)this.trading);
        this.tradeAmount = compound.m_128451_("trade_amount");
        this.freeAmountLeft = compound.m_128451_("free_amount");
        this.owner = compound.m_128441_("owner") ? compound.m_128342_("owner") : new UUID(0L, 0L);
        super.m_142466_(compound);
    }

    public boolean isFueling() {
        return this.isFueling;
    }

    public int getFuelCounter() {
        return this.fuelCounter;
    }

    public void setStorage(FluidStack storage) {
        this.storage = storage;
        this.m_6596_();
        this.synchronize();
    }

    public FluidStack getStorage() {
        return this.storage;
    }

    public void setFuelCounter(int fuelCounter) {
        this.fuelCounter = fuelCounter;
        this.m_6596_();
        this.synchronize();
    }

    public void setFueling(boolean isFueling) {
        if (this.fluidHandlerInFront == null) {
            return;
        }
        if (isFueling && !this.isFueling && this.f_58857_.f_46443_) {
            this.playSound();
        }
        this.isFueling = isFueling;
        this.synchronize();
    }

    public String getRenderText() {
        if (this.fluidHandlerInFront == null) {
            return Component.m_237115_((String)"gas_station.no_car").getString();
        }
        if (this.fuelCounter <= 0) {
            return Component.m_237115_((String)"gas_station.ready").getString();
        }
        return Component.m_237110_((String)"gas_station.fuel_amount", (Object[])new Object[]{this.fuelCounter}).getString();
    }

    private IFluidHandler searchFluidHandlerInFront() {
        return this.f_58857_.m_45976_(Entity.class, this.getDetectionBox()).stream().sorted(Comparator.comparingDouble(o -> o.m_20238_(this.center.get()))).map(entity -> (IFluidHandler)entity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public IFluidHandler getFluidHandlerInFront() {
        return this.fluidHandlerInFront;
    }

    private AABB createDetectionBox() {
        BlockState ownState = this.f_58857_.m_8055_(this.f_58858_);
        if (!ownState.m_60734_().equals(ModBlocks.GAS_STATION.get())) {
            return null;
        }
        Direction facing = (Direction)ownState.m_61143_((Property)BlockGasStation.FACING);
        BlockPos start = this.f_58858_.m_121945_(facing);
        return new AABB((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_(), (double)start.m_123341_() + 1.0, (double)start.m_123342_() + 2.5, (double)start.m_123343_() + 1.0).m_82363_((double)facing.m_122429_(), 0.0, (double)facing.m_122431_()).m_82377_(facing.m_122429_() == 0 ? 0.5 : 0.0, 0.0, facing.m_122431_() == 0 ? 0.5 : 0.0);
    }

    public AABB getDetectionBox() {
        return this.detectionBox.get();
    }

    public boolean canEntityBeFueled() {
        if (this.fluidHandlerInFront == null) {
            return false;
        }
        FluidStack result = FluidUtil.tryFluidTransfer((IFluidHandler)this.fluidHandlerInFront, (IFluidHandler)this, (int)this.transferRate, (boolean)false);
        return !result.isEmpty();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockGasStation.FACING);
    }

    public void sendStartFuelPacket(boolean start) {
        if (this.f_58857_.f_46443_) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageStartFuel(this.f_58858_, start));
        }
    }

    @Override
    public boolean shouldSoundBePlayed() {
        if (!this.isFueling) {
            return false;
        }
        return this.canEntityBeFueled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound() {
        ModSounds.playSoundLoop(new SoundLoopTileentity((SoundEvent)ModSounds.GAS_STATION.get(), SoundSource.BLOCKS, this), this.f_58857_);
    }

    @Override
    public void play() {
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 2, 1));
    }

    public int getTradeAmount() {
        return this.tradeAmount;
    }

    public void setTradeAmount(int tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public int getFuelAmount() {
        if (!this.storage.isEmpty()) {
            return this.storage.getAmount();
        }
        return 0;
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.storage;
    }

    public int getTankCapacity(int tank) {
        return this.maxStorageAmount;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFluid(stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isValidFluid(resource.getFluid())) {
            return 0;
        }
        if (this.storage.isEmpty()) {
            int amount = Math.min(resource.getAmount(), this.maxStorageAmount);
            if (action.execute()) {
                this.storage = new FluidStack(resource.getFluid(), amount);
                this.synchronize();
                this.m_6596_();
            }
            return amount;
        }
        if (resource.getFluid().equals(this.storage.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.maxStorageAmount - this.storage.getAmount());
            if (action.execute()) {
                this.storage.setAmount(this.storage.getAmount() + amount);
                this.m_6596_();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.storage.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.storage.getFluid().equals(resource.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.storage.getAmount());
            Fluid f = this.storage.getFluid();
            if (action.execute()) {
                this.storage.setAmount(this.storage.getAmount() - amount);
                if (this.storage.getAmount() <= 0) {
                    this.storage = FluidStack.EMPTY;
                    this.synchronize();
                }
                this.m_6596_();
            }
            return new FluidStack(f, amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.storage.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.storage.getAmount());
        Fluid f = this.storage.getFluid();
        if (action.execute()) {
            this.storage.setAmount(this.storage.getAmount() - amount);
            if (this.storage.getAmount() <= 0) {
                this.storage = FluidStack.EMPTY;
                this.synchronize();
            }
            this.m_6596_();
        }
        return new FluidStack(f, amount);
    }
}

