/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityCarFuelBase
extends EntityCarDamageBase
implements IFluidHandler {
    private static final EntityDataAccessor<Integer> FUEL_AMOUNT = SynchedEntityData.m_135353_(EntityCarFuelBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.m_135353_(EntityCarFuelBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public EntityCarFuelBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public abstract int getMaxFuel();

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.fuelTick();
    }

    protected void fuelTick() {
        int fuel = this.getFuelAmount();
        int tickFuel = this.getEfficiency(this.getFluid());
        if (tickFuel <= 0) {
            return;
        }
        if (fuel > 0 && this.isAccelerating()) {
            if (this.f_19797_ % tickFuel == 0) {
                this.acceleratingFuelTick();
            }
        } else if (fuel > 0 && this.isStarted() && this.f_19797_ % (tickFuel * 100) == 0) {
            this.idleFuelTick();
        }
    }

    protected void idleFuelTick() {
        this.removeFuel(1);
    }

    protected void acceleratingFuelTick() {
        this.removeFuel(1);
    }

    private void removeFuel(int amount) {
        int fuel = this.getFuelAmount();
        int newFuel = fuel - amount;
        this.setFuelAmount(Math.max(newFuel, 0));
    }

    @Override
    public boolean canPlayerDriveCar(Player player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canPlayerDriveCar(player);
    }

    @Override
    public boolean canStartCarEngine(Player player) {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canStartCarEngine(player);
    }

    @Override
    public boolean canEngineStayOn() {
        if (this.getFuelAmount() <= 0) {
            return false;
        }
        return super.canEngineStayOn();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUEL_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(FUEL_TYPE, (Object)"");
    }

    public void setFuelAmount(int fuel) {
        this.f_19804_.m_135381_(FUEL_AMOUNT, (Object)fuel);
    }

    public void setFuelType(String fluid) {
        if (fluid == null) {
            fluid = "";
        }
        this.f_19804_.m_135381_(FUEL_TYPE, (Object)fluid);
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(ForgeRegistries.FLUIDS.getKey((Object)fluid).toString());
    }

    public String getFuelType() {
        return (String)this.f_19804_.m_135370_(FUEL_TYPE);
    }

    @Nullable
    public Fluid getFluid() {
        String fuelType = this.getFuelType();
        if (fuelType == null || fuelType.isEmpty()) {
            return null;
        }
        return (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fuelType));
    }

    public int getFuelAmount() {
        return (Integer)this.f_19804_.m_135370_(FUEL_AMOUNT);
    }

    public boolean isValidFuel(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.getEfficiency(fluid) > 0;
    }

    public abstract int getEfficiency(@Nullable Fluid var1);

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("fuel", this.getFuelAmount());
        compound.m_128359_("fuel_type", this.getFuelType());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFuelAmount(compound.m_128451_("fuel"));
        if (compound.m_128441_("fuel_type")) {
            this.setFuelType(compound.m_128461_("fuel_type"));
        }
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid f = this.getFluid();
        if (f == null) {
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL.get(), this.getFuelAmount());
        }
        return new FluidStack(f, this.getFuelAmount());
    }

    public int getTankCapacity(int tank) {
        return this.getMaxFuel();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack.getFluid());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !this.isValidFuel(resource.getFluid())) {
            return 0;
        }
        if (this.getFluid() != null && this.getFuelAmount() > 0 && !resource.getFluid().equals(this.getFluid())) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getMaxFuel() - this.getFuelAmount());
        if (action.execute()) {
            int i = this.getFuelAmount() + amount;
            if (i > this.getMaxFuel()) {
                i = this.getMaxFuel();
            }
            this.setFuelAmount(i);
            this.setFuelType(resource.getFluid());
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null) {
            return FluidStack.EMPTY;
        }
        if (resource.getFluid() == null || !resource.getFluid().equals(this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Fluid fluid = this.getFluid();
        int totalAmount = this.getFuelAmount();
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, totalAmount);
        if (action.execute()) {
            int newAmount = totalAmount - amount;
            if (newAmount <= 0) {
                this.setFuelType((String)null);
                this.setFuelAmount(0);
            } else {
                this.setFuelAmount(newAmount);
            }
        }
        return new FluidStack(fluid, amount);
    }
}

