/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.modeloverride;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tschipp.carryon.common.scripting.Matchables;

public class ModelOverride {
    public static Codec<ModelOverride> CODEC = Codec.STRING.comapFlatMap(ModelOverride::of, override -> override.raw);
    private String raw;
    private BlockStateParser.BlockResult parsedBlock;
    private Type type;
    private Either<ItemParser.ItemResult, BlockStateParser.BlockResult> parsedRHS;
    private Either<ItemStack, BlockState> renderObject;

    private ModelOverride(String raw, BlockStateParser.BlockResult parsedBlock, Type type, Either<ItemParser.ItemResult, BlockStateParser.BlockResult> parsedRHS) {
        this.raw = raw;
        this.parsedBlock = parsedBlock;
        this.type = type;
        this.parsedRHS = parsedRHS;
        parsedRHS.ifLeft(res -> {
            ItemStack stack = new ItemStack(res.f_235328_());
            if (res.f_235329_() != null) {
                stack.m_41751_(res.f_235329_());
            }
            this.renderObject = Either.left((Object)stack);
        });
        parsedRHS.ifRight(res -> {
            BlockState state = res.f_234748_();
            this.renderObject = Either.right((Object)state);
        });
    }

    public static DataResult<ModelOverride> of(String str) {
        Either either;
        BlockStateParser.BlockResult res;
        if (!str.contains("->")) {
            return DataResult.error((String)(str + " must contain -> Arrow!"));
        }
        String[] split = str.split("->");
        String from = split[0];
        String to = split[1];
        try {
            res = BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)from, (boolean)true);
        }
        catch (Exception e) {
            return DataResult.error((String)("Error while parsing " + from + ":" + e.getMessage()));
        }
        Type type = Type.ITEM;
        if (to.contains("(") && to.contains(")")) {
            String t = to.substring(to.indexOf("(") + 1, to.indexOf(")"));
            if (t.equals("block")) {
                type = Type.BLOCK;
            }
            to = to.substring(to.indexOf(")") + 1);
        }
        try {
            either = type == Type.ITEM ? Either.left((Object)ItemParser.m_235305_((HolderLookup)BuiltInRegistries.f_257033_.m_255303_(), (StringReader)new StringReader(to))) : Either.right((Object)BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)to, (boolean)true));
        }
        catch (CommandSyntaxException e) {
            return DataResult.error((String)("Error while parsing " + to + ":" + e.getMessage()));
        }
        return DataResult.success((Object)new ModelOverride(str, res, type, (Either<ItemParser.ItemResult, BlockStateParser.BlockResult>)either));
    }

    public boolean matches(BlockState state, @Nullable CompoundTag tag) {
        if (state.m_60734_() == this.parsedBlock.f_234748_().m_60734_() && this.matchesProperties(state, this.parsedBlock.f_234749_())) {
            if (tag == null || this.parsedBlock.f_234750_() == null) {
                return true;
            }
            Matchables.NBTCondition nbt = new Matchables.NBTCondition(this.parsedBlock.f_234750_());
            return nbt.matches(tag);
        }
        return false;
    }

    public Either<ItemStack, BlockState> getRenderObject() {
        return this.renderObject;
    }

    private boolean matchesProperties(BlockState state, Map<Property<?>, Comparable<?>> props) {
        for (Map.Entry<Property<?>, Comparable<?>> entry : props.entrySet()) {
            Comparable val = state.m_61143_(entry.getKey());
            if (val == entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public static enum Type {
        ITEM,
        BLOCK;

    }
}

