/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.scripting.CarryOnScript;

public class PlacementHandler {
    public static boolean tryPlaceBlock(ServerPlayer player, BlockPos pos, Direction facing, @Nullable BiFunction<BlockPos, BlockState, Boolean> placementCallback) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        boolean doPlace;
        boolean canPlace;
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            return false;
        }
        if (player.f_19797_ == carry.getTick()) {
            return false;
        }
        ServerLevel level = player.m_9236_();
        BlockState state = carry.getBlock();
        BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)facing, (BlockPos)pos));
        if (!level.m_8055_(pos).m_60629_(context)) {
            pos = pos.m_121945_(facing);
        }
        context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)facing, (BlockPos)pos));
        BlockEntity blockEntity = carry.getBlockEntity(pos);
        boolean bl = canPlace = (state = PlacementHandler.getPlacementState(state, player, context, pos)).m_60710_((LevelReader)level, pos) && level.m_7966_((Player)player, pos) && level.m_8055_(pos).m_60629_(context) && level.m_45752_(state, pos, CollisionContext.m_82750_((Entity)player));
        if (!canPlace) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12032_, SoundSource.PLAYERS, 0.5f, 0.5f);
            return false;
        }
        boolean bl2 = doPlace = placementCallback == null || placementCallback.apply(pos, state) != false;
        if (!doPlace) {
            return false;
        }
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
            player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + cmd);
        }
        level.m_46597_(pos, state);
        if (blockEntity != null) {
            level.m_151523_(blockEntity);
        }
        level.m_46672_(pos.m_121945_(Direction.DOWN), level.m_8055_(pos.m_121945_(Direction.DOWN)).m_60734_());
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, carry);
        player.m_5496_(state.m_60827_().m_56777_(), 1.0f, 0.5f);
        level.m_5594_(null, pos, state.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 0.5f);
        player.m_21011_(InteractionHand.MAIN_HAND, true);
        return true;
    }

    private static BlockState getPlacementState(BlockState state, ServerPlayer player, BlockPlaceContext context, BlockPos pos) {
        BlockState placementState = state.m_60734_().m_5573_(context);
        if (placementState == null || placementState.m_60734_() != state.m_60734_()) {
            placementState = state;
        }
        for (Property prop : placementState.m_61147_()) {
            if (prop instanceof DirectionProperty) {
                state = PlacementHandler.updateProperty(state, placementState, prop);
            }
            if (prop.m_61709_() == Direction.Axis.class) {
                state = PlacementHandler.updateProperty(state, placementState, prop);
            }
            if (!ListHandler.isPropertyException(prop)) continue;
            state = PlacementHandler.updateProperty(state, placementState, prop);
        }
        BlockState updatedState = Block.m_49931_((BlockState)state, (LevelAccessor)player.f_19853_, (BlockPos)pos);
        if (updatedState.m_60734_() == state.m_60734_()) {
            state = updatedState;
        }
        if (placementState.m_61138_((Property)BlockStateProperties.f_61362_) && state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)placementState.m_61143_((Property)BlockStateProperties.f_61362_)));
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState updateProperty(BlockState state, BlockState otherState, Property<T> prop) {
        Comparable val = otherState.m_61143_(prop);
        return (BlockState)state.m_61124_(prop, val);
    }

    public static boolean tryPlaceEntity(ServerPlayer player, BlockPos pos, Direction facing, @Nullable BiFunction<Vec3, Entity, Boolean> placementCallback) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        boolean doPlace;
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) && !carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return false;
        }
        if (player.f_19797_ == carry.getTick()) {
            return false;
        }
        ServerLevel level = player.m_9236_();
        BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)player.m_20182_(), (Direction)facing, (BlockPos)pos));
        if (!level.m_8055_(pos).m_60629_(context)) {
            pos = pos.m_121945_(facing);
        }
        Vec3 placementPos = Vec3.m_82539_((Vec3i)pos);
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            Entity otherPlayer = player.m_146895_();
            player.m_20153_();
            carry.clear();
            CarryOnDataManager.setCarryData((Player)player, carry);
            if (otherPlayer == null) {
                return true;
            }
            otherPlayer.m_6021_(placementPos.f_82479_, placementPos.f_82480_, placementPos.f_82481_);
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            return true;
        }
        Entity entity = carry.getEntity((Level)level);
        entity.m_146884_(placementPos);
        boolean bl = doPlace = placementCallback == null || placementCallback.apply(placementPos, entity) != false;
        if (!doPlace) {
            return false;
        }
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
            player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + cmd);
        }
        level.m_7967_(entity);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_8032_();
        }
        player.m_21011_(InteractionHand.MAIN_HAND, true);
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, carry);
        return true;
    }

    public static void tryStackEntity(ServerPlayer player, Entity entityClicked) {
        if (!Constants.COMMON_CONFIG.settings.stackableEntities) {
            return;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) && !carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return;
        }
        Level level = player.f_19853_;
        Entity entityHeld = carry.isCarrying(CarryOnData.CarryType.ENTITY) ? carry.getEntity(level) : player.m_146895_();
        double sizeHeldEntity = entityHeld.m_20206_() * entityHeld.m_20205_();
        double distance = entityClicked.m_20183_().m_123331_((Vec3i)player.m_20183_());
        Entity lowestEntity = entityClicked.m_20201_();
        int numPassengers = PlacementHandler.getPassengerCount(lowestEntity);
        if (numPassengers < Constants.COMMON_CONFIG.settings.maxEntityStackLimit - 1) {
            Entity topEntity = PlacementHandler.getTopPassenger(lowestEntity);
            if (topEntity == entityHeld) {
                return;
            }
            if (ListHandler.isStackingPermitted(topEntity)) {
                double sizeEntity = topEntity.m_20206_() * topEntity.m_20205_();
                if (Constants.COMMON_CONFIG.settings.entitySizeMattersStacking && sizeHeldEntity <= sizeEntity || !Constants.COMMON_CONFIG.settings.entitySizeMattersStacking) {
                    CarryOnScript.ScriptEffects effects;
                    String cmd;
                    if (topEntity instanceof Horse) {
                        Horse horse = (Horse)topEntity;
                        horse.m_30651_(true);
                    }
                    if (distance < 6.0) {
                        double tempX = entityClicked.m_20185_();
                        double tempY = entityClicked.m_20186_();
                        double tempZ = entityClicked.m_20189_();
                        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                            entityHeld.m_6034_(tempX, tempY + 2.6, tempZ);
                            level.m_7967_(entityHeld);
                            entityHeld.m_6021_(tempX, tempY, tempZ);
                        }
                        entityHeld.m_7998_(topEntity, false);
                    } else {
                        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                            entityHeld.m_6034_(entityClicked.m_20185_(), entityClicked.m_20186_(), entityClicked.m_20189_());
                            level.m_7967_(entityHeld);
                        }
                        entityHeld.m_7998_(topEntity, false);
                    }
                    if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
                        player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + cmd);
                    }
                    player.m_21011_(InteractionHand.MAIN_HAND, true);
                    carry.clear();
                    CarryOnDataManager.setCarryData((Player)player, carry);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12034_, SoundSource.PLAYERS, 0.5f, 1.5f);
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12032_, SoundSource.PLAYERS, 0.5f, 0.5f);
                }
            }
        } else {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12032_, SoundSource.PLAYERS, 0.5f, 0.5f);
        }
    }

    public static void placeCarriedOnDeath(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean died) {
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)oldPlayer);
        if (!(!oldPlayer.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && died || carry.isCarrying(CarryOnData.CarryType.PLAYER))) {
            CarryOnDataManager.setCarryData((Player)newPlayer, carry);
            newPlayer.m_150109_().f_35977_ = oldPlayer.m_150109_().f_35977_;
            return;
        }
        PlacementHandler.placeCarried(oldPlayer);
    }

    public static void placeCarried(ServerPlayer player) {
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = carry.getEntity(player.f_19853_);
            entity.m_146884_(player.m_20182_());
            player.f_19853_.m_7967_(entity);
        } else if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)Vec3.m_82512_((Vec3i)player.m_20183_()), (Direction)Direction.DOWN, (BlockPos)player.m_20183_()));
            BlockState state = PlacementHandler.getPlacementState(carry.getBlock(), player, context, player.m_20183_());
            BlockPos pos = PlacementHandler.getDeathPlacementPos(state, player);
            BlockEntity blockEntity = carry.getBlockEntity(pos);
            player.f_19853_.m_7731_(pos, state, 3);
            if (blockEntity != null) {
                player.f_19853_.m_151523_(blockEntity);
            }
        } else if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            player.m_20153_();
        }
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, carry);
    }

    private static BlockPos getDeathPlacementPos(BlockState state, ServerPlayer player) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos p = player.m_20183_();
        int DISTANCE = 15;
        for (int j = 0; j < DISTANCE * 2; ++j) {
            for (int i = 0; i < DISTANCE * 2; ++i) {
                for (int k = 0; k < DISTANCE * 2; ++k) {
                    boolean canPlace;
                    int x = i % 2 == 0 ? i / 2 : -(i / 2);
                    int y = j % 2 == 0 ? j / 2 : -(j / 2);
                    int z = k % 2 == 0 ? k / 2 : -(k / 2);
                    pos.m_122178_(p.m_123341_() + x, p.m_123342_() + y, p.m_123343_() + z);
                    BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)Vec3.m_82512_((Vec3i)pos), (Direction)Direction.DOWN, (BlockPos)pos));
                    boolean bl = canPlace = state.m_60710_((LevelReader)player.f_19853_, (BlockPos)pos) && player.f_19853_.m_8055_((BlockPos)pos).m_60629_(context) && player.f_19853_.m_45752_(state, (BlockPos)pos, CollisionContext.m_82750_((Entity)player));
                    if (!canPlace) continue;
                    return pos;
                }
            }
        }
        return p;
    }

    private static int getPassengerCount(Entity entity) {
        int passengers = 0;
        while (entity.m_20160_()) {
            List pass = entity.m_20197_();
            if (pass.isEmpty()) continue;
            entity = (Entity)pass.get(0);
            ++passengers;
        }
        return passengers;
    }

    private static Entity getTopPassenger(Entity entity) {
        Entity top = entity;
        while (entity.m_20160_()) {
            List pass = entity.m_20197_();
            if (pass.isEmpty()) continue;
            top = entity = (Entity)pass.get(0);
        }
        return top;
    }
}

