/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.shaded.mixinextras.sugar.impl;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.modify.InvalidImplicitDiscriminatorException;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;
import tschipp.carryon.shaded.mixinextras.sugar.impl.SugarApplicationException;
import tschipp.carryon.shaded.mixinextras.sugar.impl.SugarApplicator;
import tschipp.carryon.shaded.mixinextras.utils.CompatibilityHelper;

class LocalSugarApplicator
extends SugarApplicator {
    private final boolean isArgsOnly;

    public LocalSugarApplicator(InjectionInfo info, Type paramType, AnnotationNode sugar) {
        super(info, paramType, sugar);
        this.isArgsOnly = (Boolean)Annotations.getValue((AnnotationNode)sugar, (String)"argsOnly", (Object)false);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode node) {
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        LocalVariableDiscriminator.Context context = this.getOrCreateLocalContext(target, node);
        if (discriminator.printLVT()) {
            this.printLocals(target, node.getCurrentTarget(), context, discriminator);
            this.info.addCallbackInvocation(this.info.getMethod());
            throw new SugarApplicationException("Application aborted because locals are being printed instead.");
        }
        try {
            if (discriminator.findLocal(context) < 0) {
                throw new SugarApplicationException("Unable to find matching local!");
            }
        }
        catch (InvalidImplicitDiscriminatorException e) {
            throw new SugarApplicationException("Invalid implicit variable discriminator: ", e);
        }
    }

    @Override
    void preInject(Target target, InjectionNodes.InjectionNode node) {
        this.getOrCreateLocalContext(target, node);
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode node) {
        LocalVariableDiscriminator.Context context;
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)this.sugar);
        int index = discriminator.findLocal(context = (LocalVariableDiscriminator.Context)node.getDecoration(this.getLocalContextKey()));
        if (index < 0) {
            throw new SugarApplicationException("Failed to match a local, this should have been caught during validation.");
        }
        InsnList insns = new InsnList();
        insns.add((AbstractInsnNode)new VarInsnNode(this.paramType.getOpcode(21), index));
        target.insertBefore(node, insns);
    }

    private LocalVariableDiscriminator.Context getOrCreateLocalContext(Target target, InjectionNodes.InjectionNode node) {
        String decorationKey = this.getLocalContextKey();
        if (node.hasDecoration(decorationKey)) {
            return (LocalVariableDiscriminator.Context)node.getDecoration(decorationKey);
        }
        LocalVariableDiscriminator.Context context = CompatibilityHelper.makeLvtContext(this.info, this.paramType, this.isArgsOnly, target, node.getCurrentTarget());
        node.decorate(decorationKey, (Object)context);
        return context;
    }

    private String getLocalContextKey() {
        return String.format("mixinextras_localSugarContext(%s,%s)", this.paramType, this.isArgsOnly ? "argsOnly" : "fullFrame");
    }

    private void printLocals(Target target, AbstractInsnNode node, LocalVariableDiscriminator.Context context, LocalVariableDiscriminator discriminator) {
        int baseArgIndex = target.isStatic ? 0 : 1;
        new PrettyPrinter().kvWidth(20).kv("Target Class", (Object)target.classNode.name.replace('/', '.')).kv("Target Method", (Object)target.method.name).kv("Capture Type", (Object)SignaturePrinter.getTypeName((Type)this.paramType, (boolean)false)).kv("Instruction", "[%d] %s %s", new Object[]{target.insns.indexOf(node), node.getClass().getSimpleName(), Bytecode.getOpcodeName((int)node.getOpcode())}).hr().kv("Match mode", (Object)(this.isImplicit(discriminator, baseArgIndex) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)")).kv("Match ordinal", discriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(discriminator.getOrdinal())).kv("Match index", discriminator.getIndex() < baseArgIndex ? "any" : Integer.valueOf(discriminator.getIndex())).kv("Match name(s)", discriminator.hasNames() ? discriminator.getNames() : "any").kv("Args only", (Object)this.isArgsOnly).hr().add((PrettyPrinter.IPrettyPrintable)context).print(System.err);
    }

    private boolean isImplicit(LocalVariableDiscriminator discriminator, int baseArgIndex) {
        return discriminator.getOrdinal() < 0 && discriminator.getIndex() < baseArgIndex && discriminator.getNames().isEmpty();
    }
}

