/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.shaded.mixinextras.sugar.impl;

import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InjectionError;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.util.Annotations;
import tschipp.carryon.shaded.mixinextras.injector.LateApplyingInjectorInfo;
import tschipp.carryon.shaded.mixinextras.sugar.impl.SugarApplicationException;
import tschipp.carryon.shaded.mixinextras.sugar.impl.SugarInjector;
import tschipp.carryon.shaded.mixinextras.sugar.impl.SugarWrapper;
import tschipp.carryon.shaded.mixinextras.utils.CompatibilityHelper;
import tschipp.carryon.shaded.mixinextras.utils.MixinInternals;

@InjectionInfo.AnnotationType(value=SugarWrapper.class)
@InjectionInfo.HandlerPrefix(value="sugarWrapper")
public class SugarWrapperInjectionInfo
extends InjectionInfo
implements LateApplyingInjectorInfo {
    private final InjectionInfo delegate;
    private final AnnotationNode originalAnnotation;
    private final SugarInjector sugarInjector;
    private final boolean lateApply;

    public SugarWrapperInjectionInfo(MixinTargetContext mixin, MethodNode method, AnnotationNode annotation) {
        super(mixin, method, annotation);
        this.sugarInjector = new SugarInjector(this, mixin.getMixin(), method);
        method.visibleAnnotations.remove(annotation);
        this.originalAnnotation = (AnnotationNode)Annotations.getValue((AnnotationNode)annotation, (String)"original");
        method.visibleAnnotations.add(this.originalAnnotation);
        this.sugarInjector.stripSugar();
        this.delegate = InjectionInfo.parse((MixinTargetContext)mixin, (MethodNode)method);
        this.sugarInjector.setTargets(MixinInternals.getTargets(this.delegate));
        this.lateApply = this.delegate instanceof LateApplyingInjectorInfo;
        if (this.lateApply) {
            ((LateApplyingInjectorInfo)this.delegate).wrap(this);
        }
    }

    protected void readAnnotation() {
    }

    protected Injector parseInjector(AnnotationNode injectAnnotation) {
        return null;
    }

    public boolean isValid() {
        return this.delegate.isValid();
    }

    public void prepare() {
        this.delegate.prepare();
        this.method.visibleAnnotations.remove(this.originalAnnotation);
        this.sugarInjector.prepareSugar();
    }

    public void preInject() {
        CompatibilityHelper.preInject(this.delegate);
    }

    public void inject() {
        this.delegate.inject();
    }

    public void postInject() {
        try {
            this.delegate.postInject();
        }
        catch (InjectionError | InvalidInjectionException e) {
            for (SugarApplicationException sugarException : this.sugarInjector.getExceptions()) {
                e.addSuppressed((Throwable)((Object)sugarException));
            }
            throw e;
        }
        if (!this.lateApply) {
            this.sugarInjector.applySugar();
        }
    }

    public void addCallbackInvocation(MethodNode handler) {
        this.delegate.addCallbackInvocation(handler);
    }

    @Override
    public void lateApply() {
        try {
            ((LateApplyingInjectorInfo)this.delegate).lateApply();
        }
        catch (InjectionError | InvalidInjectionException e) {
            for (SugarApplicationException sugarException : this.sugarInjector.getExceptions()) {
                e.addSuppressed((Throwable)((Object)sugarException));
            }
            throw e;
        }
        this.sugarInjector.applySugar();
    }

    @Override
    public void wrap(LateApplyingInjectorInfo outer) {
        throw new UnsupportedOperationException("Cannot wrap a sugar wrapper!");
    }
}

