/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BlockStateGenerator
extends ResourceGenerator {
    private final Map<Block, BlockStateBuilder> blockStates = new HashMap<Block, BlockStateBuilder>();

    public BlockStateGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (BlockStateBuilder blockStateBuilder : this.blockStates.values()) {
            ResourceLocation block = Registries.BLOCKS.getIdentifier(blockStateBuilder.block);
            JsonObject json = new JsonObject();
            JsonObject variantsJson = new JsonObject();
            for (Map.Entry<PartialBlockState, VariantBuilder> variantEntry : blockStateBuilder.variants.entrySet()) {
                if (variantEntry.getValue().models.isEmpty()) continue;
                String name = BlockStateGenerator.formatVariantName(variantEntry.getKey());
                variantsJson.add(name, this.serializeVariant(variantEntry.getValue(), block));
            }
            if (variantsJson.size() > 0) {
                json.add("variants", (JsonElement)variantsJson);
            }
            JsonArray multipartsJson = new JsonArray();
            for (Pair<MultipartConditionBuilder, VariantBuilder> multipartEntry : blockStateBuilder.multipartVariants) {
                if (multipartEntry.right().models.isEmpty()) continue;
                JsonObject multipartJson = new JsonObject();
                multipartJson.add("apply", this.serializeVariant(multipartEntry.right(), block));
                multipartEntry.left().flatten();
                JsonArray whenJson = new JsonArray();
                for (MultipartConditionBuilder condition : multipartEntry.left().or) {
                    if (condition.properties.isEmpty()) continue;
                    JsonObject conditionJson = new JsonObject();
                    condition.properties.forEach((property, values) -> conditionJson.addProperty(property.m_61708_(), Arrays.stream(values).map(arg_0 -> ((Property)property).m_6940_(arg_0)).collect(Collectors.joining("|"))));
                    whenJson.add((JsonElement)conditionJson);
                }
                if (whenJson.size() == 1) {
                    multipartJson.add("when", whenJson.get(0));
                } else if (!whenJson.isEmpty()) {
                    JsonObject newWhenJson = new JsonObject();
                    newWhenJson.add("OR", (JsonElement)whenJson);
                    multipartJson.add("when", (JsonElement)newWhenJson);
                }
                multipartsJson.add((JsonElement)multipartJson);
            }
            if (!multipartsJson.isEmpty()) {
                json.add("multipart", (JsonElement)multipartsJson);
            }
            if (variantsJson.size() == 0 && multipartsJson.isEmpty()) {
                throw new RuntimeException("Block state for block '" + block + "' is empty!");
            }
            this.cache.saveJsonResource(ResourceType.ASSET, json, this.modid, "blockstates", block.m_135815_());
        }
    }

    private JsonElement serializeVariant(VariantBuilder builder, ResourceLocation block) {
        JsonObject[] models = new JsonObject[builder.models.size()];
        for (int i = 0; i < models.length; ++i) {
            VariantModel model = builder.models.get(i);
            JsonObject modelJson = new JsonObject();
            if (!this.cache.doesResourceExist(ResourceType.ASSET, model.modelLocation.m_135827_(), "models", model.modelLocation.m_135815_(), ".json")) {
                throw new RuntimeException("Could not find model '" + model.modelLocation + "' in block state for block '" + block + "'!");
            }
            modelJson.addProperty("model", model.modelLocation.toString());
            if (model.xRotation != 0) {
                modelJson.addProperty("x", (Number)model.xRotation);
            }
            if (model.yRotation != 0) {
                modelJson.addProperty("y", (Number)model.yRotation);
            }
            if (model.uvLock) {
                modelJson.addProperty("uvlock", Boolean.valueOf(true));
            }
            if (model.weight != 1 && models.length > 1) {
                modelJson.addProperty("weight", (Number)model.weight);
            }
            models[i] = modelJson;
        }
        return models.length > 1 ? BlockStateGenerator.createJsonArray((JsonElement[])models) : models[0];
    }

    private static JsonArray createJsonArray(JsonElement ... elements) {
        JsonArray array = new JsonArray(elements.length);
        for (JsonElement element : elements) {
            array.add(element);
        }
        return array;
    }

    private static String formatVariantName(PartialBlockState state) {
        return state.properties.entrySet().stream().map(entry -> ((Property)entry.getKey()).m_61708_() + "=" + ((Property)entry.getKey()).m_6940_((Comparable)entry.getValue())).collect(Collectors.joining(","));
    }

    protected PartialBlockStateBuilder createPartialStateBuilder(Block block) {
        return new PartialBlockStateBuilder(block);
    }

    protected PartialBlockState createEmptyPartialState(Block block) {
        return this.createPartialStateBuilder(block).build();
    }

    protected PartialBlockState createPartialState(BlockState state) {
        return this.createPartialStateBuilder(state.m_60734_()).copy(state).build();
    }

    protected BlockStateBuilder blockState(Block block) {
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier(block);
        this.cache.trackToBeGeneratedResource(ResourceType.ASSET, identifier.m_135827_(), "blockstates", identifier.m_135815_(), ".json");
        return this.blockStates.computeIfAbsent(block, o -> new BlockStateBuilder(this.modid, (Block)o));
    }

    @Override
    public String getName() {
        return this.modName + " Block State Generator";
    }

    protected class BlockStateBuilder {
        private final String modid;
        private final Block block;
        private final Map<PartialBlockState, VariantBuilder> variants = new HashMap<PartialBlockState, VariantBuilder>();
        private final List<Pair<MultipartConditionBuilder, VariantBuilder>> multipartVariants = new ArrayList<Pair<MultipartConditionBuilder, VariantBuilder>>();

        public BlockStateBuilder(String modid, Block block) {
            this.modid = modid;
            this.block = block;
        }

        public BlockStateBuilder variant(PartialBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            if (state.block != this.block) {
                throw new IllegalArgumentException("Cannot use state from block '" + state.block + "' in block state builder for block '" + this.block + "'!");
            }
            variantBuilderConsumer.accept(this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
            return this;
        }

        public BlockStateBuilder variant(BlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.variant(BlockStateGenerator.this.createPartialState(state), variantBuilderConsumer);
        }

        public BlockStateBuilder emptyVariant(Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.variant(BlockStateGenerator.this.createEmptyPartialState(this.block), variantBuilderConsumer);
        }

        public BlockStateBuilder variantsForProperty(Property<?> property, BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            if (!this.block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            PartialBlockStateBuilder builder = BlockStateGenerator.this.createPartialStateBuilder(this.block);
            for (Comparable value : property.m_6908_()) {
                PartialBlockState state = builder.set(property, value).build();
                variantBuilderConsumer.accept(state, this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
            }
            return this;
        }

        public BlockStateBuilder variantsForAllExcept(BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer, Property<?> ... excluded) {
            PartialBlockStateBuilder builder = BlockStateGenerator.this.createPartialStateBuilder(this.block);
            List<Property<?>> properties = this.block.m_49965_().m_61092_().stream().filter(property -> Arrays.stream(excluded).noneMatch(p -> p == property)).collect(Collectors.toList());
            this.loopThroughAll(builder, properties, 0, variantBuilderConsumer);
            return this;
        }

        private void loopThroughAll(PartialBlockStateBuilder builder, List<Property<?>> properties, int index, BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            if (index == properties.size()) {
                PartialBlockState state = builder.build();
                variantBuilderConsumer.accept(state, this.variants.computeIfAbsent(state, o -> new VariantBuilder(this.modid)));
                return;
            }
            Property<?> property = properties.get(index);
            for (Comparable value : property.m_6908_()) {
                builder.set(property, value);
                this.loopThroughAll(builder, properties, index + 1, variantBuilderConsumer);
            }
        }

        public BlockStateBuilder variantsForAll(BiConsumer<PartialBlockState, VariantBuilder> variantBuilderConsumer) {
            return this.variantsForAllExcept(variantBuilderConsumer, new Property[0]);
        }

        public BlockStateBuilder multipart(Consumer<MultipartConditionBuilder> conditionBuilderConsumer, Consumer<VariantBuilder> variantBuilderConsumer) {
            MultipartConditionBuilder condition = new MultipartConditionBuilder(this.block);
            conditionBuilderConsumer.accept(condition);
            VariantBuilder variant = new VariantBuilder(this.modid);
            variantBuilderConsumer.accept(variant);
            this.multipartVariants.add(Pair.of(condition, variant));
            return this;
        }

        public BlockStateBuilder multipart(PartialBlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            if (state.block != this.block) {
                throw new IllegalArgumentException("Cannot use state from block '" + state.block + "' in block state builder for block '" + this.block + "'!");
            }
            return this.multipart((MultipartConditionBuilder condition) -> state.properties.forEach((property, value) -> condition.requireProperty((Property)property, new Comparable[]{value})), variantBuilderConsumer);
        }

        public BlockStateBuilder multipart(BlockState state, Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.multipart(BlockStateGenerator.this.createPartialState(state), variantBuilderConsumer);
        }

        public BlockStateBuilder unconditionalMultipart(Consumer<VariantBuilder> variantBuilderConsumer) {
            return this.multipart(BlockStateGenerator.this.createEmptyPartialState(this.block), variantBuilderConsumer);
        }
    }

    protected static class VariantBuilder {
        private final String modid;
        private final List<VariantModel> models = new ArrayList<VariantModel>();

        protected VariantBuilder(String modid) {
            this.modid = modid;
        }

        public VariantBuilder model(ResourceLocation modelLocation, int xRotation, int yRotation, boolean uvLock, int weight) {
            this.models.add(new VariantModel(modelLocation, xRotation, yRotation, uvLock, weight));
            return this;
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation, boolean uvLock, int weight) {
            return this.model(new ResourceLocation(namespace, identifier), xRotation, yRotation, uvLock, weight);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation, boolean uvLock, int weight) {
            return this.model(this.modid, identifier, xRotation, yRotation, uvLock, weight);
        }

        public VariantBuilder model(ResourceLocation modelLocation, int xRotation, int yRotation, boolean uvLock) {
            return this.model(modelLocation, xRotation, yRotation, uvLock, 1);
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation, boolean uvLock) {
            return this.model(new ResourceLocation(namespace, identifier), xRotation, yRotation, uvLock);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation, boolean uvLock) {
            return this.model(this.modid, identifier, xRotation, yRotation, uvLock);
        }

        public VariantBuilder model(ResourceLocation modelLocation, int xRotation, int yRotation) {
            return this.model(modelLocation, xRotation, yRotation, false, 1);
        }

        public VariantBuilder model(String namespace, String identifier, int xRotation, int yRotation) {
            return this.model(new ResourceLocation(namespace, identifier), xRotation, yRotation);
        }

        public VariantBuilder model(String identifier, int xRotation, int yRotation) {
            return this.model(this.modid, identifier, xRotation, yRotation);
        }

        public VariantBuilder model(ResourceLocation modelLocation) {
            return this.model(modelLocation, 0, 0, false, 1);
        }

        public VariantBuilder model(String namespace, String identifier) {
            return this.model(new ResourceLocation(namespace, identifier));
        }

        public VariantBuilder model(String identifier) {
            return this.model(this.modid, identifier);
        }
    }

    protected static class PartialBlockState {
        private final Block block;
        private final Map<Property<?>, Comparable<?>> properties;

        protected PartialBlockState(Block block, Map<Property<?>, Comparable<?>> properties) {
            this.block = block;
            this.properties = ImmutableMap.copyOf(properties);
        }

        public Block getBlock() {
            return this.block;
        }

        public boolean has(Property<?> property) {
            return this.properties.containsKey(property);
        }

        public <T extends Comparable<T>> T get(Property<T> property) {
            if (!this.block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            return (T)this.properties.get(property);
        }
    }

    protected static class MultipartConditionBuilder {
        private final Block block;
        private final Map<Property<?>, Comparable<?>[]> properties = new HashMap();
        private final List<MultipartConditionBuilder> or = new ArrayList<MultipartConditionBuilder>();

        private MultipartConditionBuilder(Block block) {
            this.block = block;
        }

        public <T extends Comparable<T>> MultipartConditionBuilder requireProperty(Property<T> property, T ... acceptedValues) {
            if (acceptedValues.length == 0) {
                throw new RuntimeException("Accepted values cannot be empty for multipart condition property!");
            }
            if (this.properties.containsKey(property)) {
                throw new RuntimeException("Duplicate requirements for property '" + property + "' for multipart condition for block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            if (!this.block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            for (T value : acceptedValues) {
                if (property.m_6908_().contains(value)) continue;
                throw new IllegalArgumentException("Value '" + value + "' does not belong to property '" + property + "'!");
            }
            this.properties.put(property, (Comparable<?>[])acceptedValues);
            return this;
        }

        public MultipartConditionBuilder or(Consumer<MultipartConditionBuilder> alternativeBuilderConsumer) {
            MultipartConditionBuilder builder = new MultipartConditionBuilder(this.block);
            alternativeBuilderConsumer.accept(builder);
            if (builder.properties.isEmpty()) {
                throw new IllegalArgumentException("Alternative condition cannot be empty!");
            }
            this.or.add(builder);
            return this;
        }

        public MultipartConditionBuilder or() {
            MultipartConditionBuilder builder = new MultipartConditionBuilder(this.block);
            this.or.add(builder);
            return builder;
        }

        private void flatten() {
            this.or.add(0, this);
            for (int i = 1; i < this.or.size(); ++i) {
                this.or.addAll(this.or.get((int)i).or);
            }
        }
    }

    protected static class VariantModel {
        public final ResourceLocation modelLocation;
        public final int xRotation;
        public final int yRotation;
        public final boolean uvLock;
        public final int weight;

        public VariantModel(ResourceLocation modelLocation, int xRotation, int yRotation, boolean uvLock, int weight) {
            this.modelLocation = modelLocation;
            this.xRotation = xRotation;
            this.yRotation = yRotation;
            this.uvLock = uvLock;
            this.weight = weight;
        }
    }

    protected static class PartialBlockStateBuilder {
        private final Block block;
        private final Map<Property<?>, Comparable<?>> properties = new HashMap();

        protected PartialBlockStateBuilder(Block block) {
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }

        public <T extends Comparable<T>> PartialBlockStateBuilder set(Property<T> property, T value) {
            if (!this.block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            if (!property.m_6908_().contains(value)) {
                throw new IllegalArgumentException("Value '" + value + "' does not belong to property '" + property + "'!");
            }
            this.properties.put(property, value);
            return this;
        }

        public PartialBlockStateBuilder copy(BlockState state) {
            if (this.block != state.m_60734_()) {
                throw new IllegalArgumentException("Cannot copy properties of state for block '" + Registries.BLOCKS.getIdentifier(state.m_60734_()) + "' to block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            this.properties.putAll((Map<Property<?>, Comparable<?>>)state.m_61148_());
            return this;
        }

        public boolean has(Property<?> property) {
            return this.properties.containsKey(property);
        }

        public <T extends Comparable<T>> T get(Property<T> property) {
            if (!this.block.m_49965_().m_61092_().contains(property)) {
                throw new IllegalArgumentException("Property '" + property + "' is not a property of block '" + Registries.BLOCKS.getIdentifier(this.block) + "'!");
            }
            return (T)this.properties.get(property);
        }

        public PartialBlockState build() {
            return new PartialBlockState(this.block, this.properties);
        }
    }
}

