/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderConfiguration;
import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtils {
    private static final RenderConfiguration LINES = RenderConfiguration.create("supermartijn642corelib", "lines", DefaultVertexFormat.f_166851_, RenderConfiguration.PrimitiveType.TRIANGLE_LINES, 128, true, true, RenderStateConfiguration.builder().useShader(GameRenderer::m_172757_).useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration LINES_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "lines_no_depth", DefaultVertexFormat.f_166851_, RenderConfiguration.PrimitiveType.TRIANGLE_LINES, 128, true, true, RenderStateConfiguration.builder().useShader(GameRenderer::m_172757_).useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().disableDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS = RenderConfiguration.create("supermartijn642corelib", "quads", DefaultVertexFormat.f_85815_, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useShader(GameRenderer::m_172811_).useTranslucentTransparency().disableTexture().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "quads_no_depth", DefaultVertexFormat.f_85815_, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useShader(GameRenderer::m_172811_).useTranslucentTransparency().disableTexture().disableCulling().disableDepthTest().disableDepthMask().build());

    public static Vec3 getCameraPosition() {
        return ClientUtils.getMinecraft().m_91290_().f_114358_.m_90583_();
    }

    public static MultiBufferSource.BufferSource getMainBufferSource() {
        return ClientUtils.getMinecraft().m_91269_().m_110104_();
    }

    public static void renderShape(PoseStack poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? LINES : LINES_NO_DEPTH;
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        VertexConsumer builder = renderConfiguration.begin((MultiBufferSource)bufferSource);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            Vec3 normal = new Vec3(x2 - x1, y2 - y1, z2 - z1);
            normal.m_82541_();
            builder.m_252986_(matrix4f, (float)x1, (float)y1, (float)z1).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            builder.m_252986_(matrix4f, (float)x2, (float)y2, (float)z2).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShapeSides(PoseStack poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? QUADS : QUADS_NO_DEPTH;
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        VertexConsumer builder = renderConfiguration.begin((MultiBufferSource)bufferSource);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        shape.forEachBox(box -> {
            float minX = (float)box.f_82288_;
            float maxX = (float)box.f_82291_;
            float minY = (float)box.f_82289_;
            float maxY = (float)box.f_82292_;
            float minZ = (float)box.f_82290_;
            float maxZ = (float)box.f_82293_;
            builder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShape(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderShapeSides(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderBox(PoseStack poseStack, AABB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderBoxSides(PoseStack poseStack, AABB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderShape(PoseStack poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(PoseStack poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShape(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBox(PoseStack poseStack, AABB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBoxSides(PoseStack poseStack, AABB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }
}

