/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.util;

import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Either<X, Y> {
    public static <X, Y> Either<X, Y> left(X object) {
        return new Left(object);
    }

    public static <X, Y> Either<X, Y> right(Y object) {
        return new Right(object);
    }

    private Either() {
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract X left();

    public abstract Y right();

    public abstract X leftOrElse(X var1);

    public abstract Y rightOrElse(Y var1);

    public abstract X leftOrElseGet(Supplier<X> var1);

    public abstract Y rightOrElseGet(Supplier<Y> var1);

    public X leftOrNull() {
        return this.leftOrElse(null);
    }

    public Y rightOrNull() {
        return this.rightOrElse(null);
    }

    public abstract <S> Either<S, Y> mapLeft(Function<X, S> var1);

    public abstract <S> Either<X, S> mapRight(Function<Y, S> var1);

    public <R, S> Either<R, S> map(Function<X, R> mapLeft, Function<Y, S> mapRight) {
        return this.mapLeft(mapLeft).mapRight(mapRight);
    }

    private static class Left<X, Y>
    extends Either<X, Y> {
        private final X value;

        private Left(X value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public X left() {
            return this.value;
        }

        @Override
        public Y right() {
            throw new NoSuchElementException("Right value is not present!");
        }

        @Override
        public X leftOrElse(X other) {
            return this.value;
        }

        @Override
        public Y rightOrElse(Y other) {
            return other;
        }

        @Override
        public X leftOrElseGet(Supplier<X> other) {
            return this.value;
        }

        @Override
        public Y rightOrElseGet(Supplier<Y> other) {
            return other.get();
        }

        @Override
        public <S> Either<S, Y> mapLeft(Function<X, S> mapper) {
            return new Left<S, Y>(mapper.apply(this.value));
        }

        @Override
        public <S> Either<X, S> mapRight(Function<Y, S> mapper) {
            return this;
        }
    }

    private static class Right<X, Y>
    extends Either<X, Y> {
        private final Y value;

        private Right(Y value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public X left() {
            throw new NoSuchElementException("Left value is not present!");
        }

        @Override
        public Y right() {
            return this.value;
        }

        @Override
        public X leftOrElse(X other) {
            return other;
        }

        @Override
        public Y rightOrElse(Y other) {
            return this.value;
        }

        @Override
        public X leftOrElseGet(Supplier<X> other) {
            return other.get();
        }

        @Override
        public Y rightOrElseGet(Supplier<Y> other) {
            return this.value;
        }

        @Override
        public <S> Either<S, Y> mapLeft(Function<X, S> mapper) {
            return this;
        }

        @Override
        public <S> Either<X, S> mapRight(Function<Y, S> mapper) {
            return new Right<X, S>(mapper.apply(this.value));
        }
    }
}

