/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.init;

import com.girafi.waddles.entity.AdeliePenguinEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="waddles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PenguinRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"waddles");
    public static final DeferredRegister<Item> ITEM_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"waddles");
    public static final Collection<RegistryObject<Item>> SPAWN_EGGS = new ArrayList<RegistryObject<Item>>();
    public static final RegistryObject<EntityType<AdeliePenguinEntity>> ADELIE_PENGUIN = PenguinRegistry.registerPenguin("adelie_penguin", () -> AdeliePenguinEntity::new, 0.4f, 0.95f, 0, 0xFFFFFF);

    private static <T extends Animal> RegistryObject<EntityType<T>> registerPenguin(String name, Supplier<EntityType.EntityFactory<T>> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("waddles", name);
        RegistryObject entityType = ENTITY_DEFERRED.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)((EntityType.EntityFactory)factory.get()), (MobCategory)MobCategory.CREATURE).m_20699_(width, height).setTrackingRange(64).setUpdateInterval(1).m_20712_(location.toString()));
        RegistryObject spawnEgg = ITEM_DEFERRED.register(name + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)entityType, eggPrimary, eggSecondary, new Item.Properties()));
        SPAWN_EGGS.add((RegistryObject<Item>)spawnEgg);
        return entityType;
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ADELIE_PENGUIN.get(), AdeliePenguinEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void addToCreativeTab(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_256731_) {
            SPAWN_EGGS.forEach(arg_0 -> ((CreativeModeTabEvent.BuildContents)event).accept(arg_0));
        }
    }
}

