/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.client.color.BoardColorSampler;
import com.github.alexthe668.iwannaskate.client.gui.SkateManualScreen;
import com.github.alexthe668.iwannaskate.client.model.ModelRootRegistry;
import com.github.alexthe668.iwannaskate.client.particle.BeeParticle;
import com.github.alexthe668.iwannaskate.client.particle.HalloweenParticle;
import com.github.alexthe668.iwannaskate.client.particle.HoverParticle;
import com.github.alexthe668.iwannaskate.client.particle.IWSParticleRegistry;
import com.github.alexthe668.iwannaskate.client.particle.SparkleParticle;
import com.github.alexthe668.iwannaskate.client.render.IWSRenderTypes;
import com.github.alexthe668.iwannaskate.client.render.blockentity.SkateboardRackRenderer;
import com.github.alexthe668.iwannaskate.client.render.entity.SkateboardRenderer;
import com.github.alexthe668.iwannaskate.client.render.entity.SkaterSkeletonRenderer;
import com.github.alexthe668.iwannaskate.client.render.entity.WanderingSkaterRenderer;
import com.github.alexthe668.iwannaskate.client.render.item.IWSItemArmorProperties;
import com.github.alexthe668.iwannaskate.client.render.item.IWSItemRenderProperties;
import com.github.alexthe668.iwannaskate.client.render.item.IWSItemstackRenderer;
import com.github.alexthe668.iwannaskate.client.sound.SkateSoundType;
import com.github.alexthe668.iwannaskate.client.sound.SkateboardSound;
import com.github.alexthe668.iwannaskate.server.CommonProxy;
import com.github.alexthe668.iwannaskate.server.blockentity.IWSBlockEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.IWSEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.item.DyeableHatItem;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.potion.IWSEffectRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="iwannaskate", value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final Map<Integer, SkateboardSound> SKATEBOARD_SOUND_MAP = new HashMap<Integer, SkateboardSound>();
    protected static final ResourceLocation OVERCAFFENIATED_OVERLAY = new ResourceLocation("iwannaskate", "textures/gui/overcaffeniated_overlay.png");
    private static final ResourceLocation SKATEBOARD_INDICATOR_TEXTURE = new ResourceLocation("iwannaskate", "textures/gui/skateboard_peddle_indicator.png");
    private float prevCameraRoll = 0.0f;

    public static void onTexturesLoaded(TextureStitchEvent.Post event) {
        BoardColorSampler.sampleColorsOnLoad();
    }

    public static void setupItemColors(RegisterColorHandlersEvent.Item event) {
        IWannaSkateMod.LOGGER.info("loaded in item colorizer");
        if (IWSItemRegistry.BEANIE.isPresent()) {
            event.register((stack, colorIn) -> colorIn != 0 ? -1 : ((DyeableHatItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)IWSItemRegistry.BEANIE.get()});
        }
        if (IWSItemRegistry.SKATER_CAP.isPresent()) {
            event.register((stack, colorIn) -> colorIn != 0 ? -1 : ((DyeableHatItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)IWSItemRegistry.SKATER_CAP.get()});
        }
    }

    public static void setupParticles(RegisterParticleProvidersEvent registry) {
        IWannaSkateMod.LOGGER.debug("Registered particle factories");
        registry.register((ParticleType)IWSParticleRegistry.HALLOWEEN.get(), HalloweenParticle.Factory::new);
        registry.register((ParticleType)IWSParticleRegistry.BEE.get(), BeeParticle.Factory::new);
        registry.register((ParticleType)IWSParticleRegistry.HOVER.get(), (ParticleProvider)new HoverParticle.Factory());
        registry.register((ParticleType)IWSParticleRegistry.SPARKLE.get(), SparkleParticle.Factory::new);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            IWSItemstackRenderer.tick();
        }
    }

    @SubscribeEvent
    public void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Entity entity = Minecraft.m_91087_().f_91074_.m_20202_();
        if (entity instanceof SkateboardEntity) {
            SkateboardEntity skateboard = (SkateboardEntity)entity;
            if (((Boolean)IWannaSkateMod.CLIENT_CONFIG.rotateCameraOnBoard.get()).booleanValue()) {
                float partialTick = Minecraft.m_91087_().getPartialTick();
                float targetRot = skateboard.getZRot(partialTick);
                if (Math.abs(targetRot) <= 1.0f) {
                    targetRot = 0.0f;
                }
                float f = skateboard.approachRotation(this.prevCameraRoll, targetRot, 1.0f);
                float f1 = this.prevCameraRoll + (f - this.prevCameraRoll) * partialTick;
                this.prevCameraRoll = f;
                event.setRoll(f * 0.25f);
            }
        }
    }

    @SubscribeEvent
    public void onPreRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
        Entity entity;
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id()) && ((Boolean)IWannaSkateMod.CLIENT_CONFIG.hideExperienceBar.get()).booleanValue() && (entity = this.getClientSidePlayer().m_20202_()) instanceof SkateboardEntity) {
            SkateboardEntity skateboard = (SkateboardEntity)entity;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPostRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        Entity entity;
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.JUMP_BAR.id()) && ((Boolean)IWannaSkateMod.CLIENT_CONFIG.showInertiaIndicator.get()).booleanValue() && (entity = this.getClientSidePlayer().m_20202_()) instanceof SkateboardEntity) {
            SkateboardEntity skateboard = (SkateboardEntity)entity;
            int screenWidth = event.getWindow().m_85445_();
            int screenHeight = event.getWindow().m_85446_();
            int j = screenWidth / 2 - (Integer)IWannaSkateMod.CLIENT_CONFIG.inertiaIndicatorX.get();
            int k = screenHeight - (Integer)IWannaSkateMod.CLIENT_CONFIG.inertiaIndicatorY.get();
            float f = skateboard.getForwards() / skateboard.getMaxForwardsTicks();
            event.getPoseStack().m_85836_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKATEBOARD_INDICATOR_TEXTURE);
            GuiComponent.m_93143_((PoseStack)event.getPoseStack(), (int)j, (int)k, (int)50, (float)0.0f, (float)0.0f, (int)29, (int)9, (int)64, (int)64);
            GuiComponent.m_93143_((PoseStack)event.getPoseStack(), (int)j, (int)k, (int)50, (float)0.0f, (float)9.0f, (int)Math.round(29.0f * f), (int)9, (int)64, (int)64);
            event.getPoseStack().m_85849_();
        }
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.VIGNETTE.id()) && Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)IWSEffectRegistry.OVERCAFFEINATED.get()) && ((Boolean)IWannaSkateMod.CLIENT_CONFIG.overcaffeniatedOverlay.get()).booleanValue()) {
            int screenWidth = event.getWindow().m_85445_();
            int screenHeight = event.getWindow().m_85446_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69453_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)OVERCAFFENIATED_OVERLAY);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69482_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public void onComputeFOV(ComputeFovModifierEvent event) {
        if (Minecraft.m_91087_().f_91074_.m_21023_((MobEffect)IWSEffectRegistry.OVERCAFFEINATED.get()) && ((Boolean)IWannaSkateMod.CLIENT_CONFIG.overcaffeniatedOverlay.get()).booleanValue()) {
            event.setNewFovModifier(event.getFovModifier() + 1.0f);
        }
    }

    @SubscribeEvent
    public void onRegisterClientReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ModelRootRegistry.INSTANCE);
    }

    @Override
    public void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ClientProxy::setupParticles);
        modEventBus.addListener(ClientProxy::setupItemColors);
    }

    @Override
    public void clientInit() {
        Minecraft.m_91087_().m_91269_().f_110093_.put(IWSRenderTypes.SKATEBOARD_GLINT, new BufferBuilder(IWSRenderTypes.SKATEBOARD_GLINT.m_110507_()));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ClientProxy::onTexturesLoaded);
        EntityRenderers.m_174036_((EntityType)((EntityType)IWSEntityRegistry.SKATEBOARD.get()), SkateboardRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)IWSEntityRegistry.SKATER_SKELETON.get()), SkaterSkeletonRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)IWSEntityRegistry.WANDERING_SKATER.get()), WanderingSkaterRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)IWSBlockEntityRegistry.SKATEBOARD_RACK.get()), SkateboardRackRenderer::new);
    }

    @Override
    public Object getISTERProperties() {
        return new IWSItemRenderProperties();
    }

    @Override
    public Object getArmorRenderProperties() {
        return new IWSItemArmorProperties();
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public boolean isKeyDown(int keyType) {
        if (keyType == 0) {
            return Minecraft.m_91087_().f_91066_.f_92091_.m_90857_();
        }
        if (keyType == 1) {
            return Screen.m_96638_();
        }
        return false;
    }

    @Override
    public void onEntityStatus(Entity entity, byte updateKind) {
        if (entity instanceof SkateboardEntity) {
            SkateboardEntity skateboard = (SkateboardEntity)entity;
            if (entity.m_6084_() && updateKind == 67 && ((Boolean)IWannaSkateMod.CLIENT_CONFIG.skateboardLoopSounds.get()).booleanValue()) {
                SkateboardSound sound;
                if (SKATEBOARD_SOUND_MAP.get(entity.m_19879_()) == null || SKATEBOARD_SOUND_MAP.get(entity.m_19879_()).isDifferentBoard(entity)) {
                    sound = new SkateboardSound(SkateSoundType.getForSkateboard(skateboard), 0.0f, skateboard);
                    SKATEBOARD_SOUND_MAP.put(entity.m_19879_(), sound);
                } else {
                    sound = SKATEBOARD_SOUND_MAP.get(entity.m_19879_());
                }
                if (!Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)sound) && sound.m_7767_()) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
                }
            }
        }
    }

    @Override
    public void reloadConfig() {
        Minecraft.m_91087_().f_90991_.f_92521_ = 50.0f;
    }

    @Override
    public void openBookGUI(ItemStack book) {
        Minecraft.m_91087_().m_91152_((Screen)new SkateManualScreen(book));
    }
}

