/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.entity.SkaterPose;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;

public class SkateboardModel
extends AdvancedEntityModel<SkateboardEntity> {
    public final AdvancedModelBox root;
    public final AdvancedModelBox board;
    public final AdvancedModelBox frontAxel;
    public final AdvancedModelBox leftFrontWheel;
    public final AdvancedModelBox rightFrontWheel;
    public final AdvancedModelBox backAxel;
    public final AdvancedModelBox leftBackWheel;
    public final AdvancedModelBox rightBackWheel;

    public SkateboardModel() {
        this.texWidth = 128;
        this.texHeight = 64;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this, "root");
        this.root.setRotationPoint(0.0f, 20.0f, 0.0f);
        this.board = new AdvancedModelBox((AdvancedEntityModel)this, "board");
        this.board.setRotationPoint(0.0f, -5.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.board);
        this.board.setTextureOffset(0, 0).addBox(-4.0f, 4.0f, -15.0f, 8.0f, 1.0f, 30.0f, 0.0f, false);
        this.frontAxel = new AdvancedModelBox((AdvancedEntityModel)this, "frontAxel");
        this.frontAxel.setRotationPoint(0.0f, 5.0f, 9.5f);
        this.board.addChild((BasicModelPart)this.frontAxel);
        this.frontAxel.setTextureOffset(59, 4).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, 0.0f, false);
        this.frontAxel.setTextureOffset(59, 1).addBox(-3.0f, 2.0f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f, false);
        this.leftFrontWheel = new AdvancedModelBox((AdvancedEntityModel)this, "leftFrontWheel");
        this.leftFrontWheel.setRotationPoint(-3.0f, 2.5f, 0.0f);
        this.frontAxel.addChild((BasicModelPart)this.leftFrontWheel);
        this.leftFrontWheel.setTextureOffset(47, 0).addBox(-2.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f, true);
        this.rightFrontWheel = new AdvancedModelBox((AdvancedEntityModel)this, "rightFrontWeel");
        this.rightFrontWheel.setRotationPoint(3.0f, 2.5f, 0.0f);
        this.frontAxel.addChild((BasicModelPart)this.rightFrontWheel);
        this.rightFrontWheel.setTextureOffset(47, 0).addBox(0.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f, false);
        this.backAxel = new AdvancedModelBox((AdvancedEntityModel)this, "backAxel");
        this.backAxel.setRotationPoint(0.0f, 5.0f, -9.5f);
        this.board.addChild((BasicModelPart)this.backAxel);
        this.backAxel.setTextureOffset(59, 4).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f, 0.0f, false);
        this.backAxel.setTextureOffset(59, 1).addBox(-3.0f, 2.0f, -0.5f, 6.0f, 1.0f, 1.0f, 0.0f, false);
        this.leftBackWheel = new AdvancedModelBox((AdvancedEntityModel)this, "leftBackWheel");
        this.leftBackWheel.setRotationPoint(-3.0f, 2.5f, 0.0f);
        this.backAxel.addChild((BasicModelPart)this.leftBackWheel);
        this.leftBackWheel.setTextureOffset(47, 0).addBox(-2.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f, true);
        this.rightBackWheel = new AdvancedModelBox((AdvancedEntityModel)this, "rightBackWheel");
        this.rightBackWheel.setRotationPoint(3.0f, 2.5f, 0.0f);
        this.backAxel.addChild((BasicModelPart)this.rightBackWheel);
        this.rightBackWheel.setTextureOffset(47, 0).addBox(0.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.board, (Object)this.frontAxel, (Object)this.backAxel, (Object)this.rightFrontWheel, (Object)this.leftFrontWheel, (Object)this.rightBackWheel, (Object)this.leftBackWheel);
    }

    public void setupAnim(SkateboardEntity entity, float limbSwing, float limbSwingAmount, float age, float yaw, float pitch) {
        this.resetToDefaultPose();
        float partialTick = age - (float)entity.f_19797_;
        float wheelRot = (float)Math.toRadians(entity.getWheelRot(partialTick));
        float axelUp = (float)(Math.abs(Math.sin(wheelRot)) * 0.5);
        float maxRoll = (float)Math.toRadians(35.0);
        float ground = entity.getOnGroundProgress(partialTick);
        float boardRot = (float)Math.toRadians(entity.m_5686_(partialTick));
        float multi = boardRot < 0.0f ? 10.0f : 9.0f;
        float boardUp = multi * (float)Math.sin(boardRot) * ground;
        this.rightBackWheel.rotateAngleX -= (wheelRot -= ground * boardRot);
        this.leftBackWheel.rotateAngleX -= wheelRot;
        this.rightFrontWheel.rotateAngleX -= wheelRot;
        this.leftFrontWheel.rotateAngleX -= wheelRot;
        this.frontAxel.rotationPointY -= axelUp;
        this.backAxel.rotationPointY -= axelUp;
        this.root.rotateAngleX -= boardRot;
        this.root.rotationPointY += boardUp;
        this.backAxel.rotateAngleX += boardRot * 0.85f * ground;
        this.rightBackWheel.rotateAngleX -= boardRot * 0.85f * ground;
        this.leftBackWheel.rotateAngleX -= boardRot * 0.85f * ground;
        this.backAxel.rotationPointZ += boardUp * 0.1f;
        this.root.rotateAngleZ = (float)Math.toRadians(entity.getZRot(partialTick));
        this.frontAxel.rotateAngleZ -= Mth.m_14036_((float)this.root.rotateAngleZ, (float)(-maxRoll), (float)maxRoll);
        this.backAxel.rotateAngleZ -= Mth.m_14036_((float)this.root.rotateAngleZ, (float)(-maxRoll), (float)maxRoll);
        if (entity.getSkaterPose() == SkaterPose.KICKFLIP) {
            this.root.rotateAngleZ += (float)Math.toRadians(age * 40.0f);
        }
        if (entity.isGrinding()) {
            this.board.rotationPointZ += 8.0f;
        }
    }

    public void animateItem(SkateboardData data, float f) {
        this.resetToDefaultPose();
        this.root.rotateAngleZ = (float)((double)f * Math.PI);
    }

    public void animateCreativeTab(float f) {
        float f1 = f * 0.1f;
        this.root.rotateAngleX = (float)(-Math.sin(f1 * 1.0f) * Math.PI);
        this.root.rotateAngleY = (float)(Math.cos((double)(f1 * 0.6f) + 1.5707963267948966) * Math.PI);
        this.root.rotateAngleZ = (float)(Math.sin((double)(f1 * 0.3f) - 4.71238898038469) * Math.PI);
    }

    public void copyFrom(SkateboardModel other) {
        this.root.copyModelAngles((BasicModelPart)other.root);
        this.board.copyModelAngles((BasicModelPart)other.board);
        this.frontAxel.copyModelAngles((BasicModelPart)other.frontAxel);
        this.backAxel.copyModelAngles((BasicModelPart)other.backAxel);
        this.leftFrontWheel.copyModelAngles((BasicModelPart)other.leftFrontWheel);
        this.rightFrontWheel.copyModelAngles((BasicModelPart)other.rightFrontWheel);
        this.leftBackWheel.copyModelAngles((BasicModelPart)other.leftBackWheel);
        this.rightBackWheel.copyModelAngles((BasicModelPart)other.rightBackWheel);
    }

    public void hideWheels() {
        this.frontAxel.showModel = false;
        this.backAxel.showModel = false;
        this.leftFrontWheel.showModel = false;
        this.rightFrontWheel.showModel = false;
        this.leftBackWheel.showModel = false;
        this.rightBackWheel.showModel = false;
    }

    public void showWheels() {
        this.frontAxel.showModel = true;
        this.backAxel.showModel = true;
        this.leftFrontWheel.showModel = true;
        this.rightFrontWheel.showModel = true;
        this.leftBackWheel.showModel = true;
        this.rightBackWheel.showModel = true;
    }
}

