/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.render.entity;

import com.github.alexthe668.iwannaskate.client.color.BoardColorSampler;
import com.github.alexthe668.iwannaskate.client.color.DeckTexture;
import com.github.alexthe668.iwannaskate.client.model.SkateboardModel;
import com.github.alexthe668.iwannaskate.client.render.IWSRenderTypes;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;

public class SkateboardTexturer {
    private static final ResourceLocation[] RAW_DECK_TEXTURES = new ResourceLocation[]{new ResourceLocation("iwannaskate", "textures/entity/skateboard/deck/deck_0.png"), new ResourceLocation("iwannaskate", "textures/entity/skateboard/deck/deck_1.png"), new ResourceLocation("iwannaskate", "textures/entity/skateboard/deck/deck_2.png"), new ResourceLocation("iwannaskate", "textures/entity/skateboard/deck/deck_3.png")};
    private static final Map<DyeColor, ResourceLocation> GRIP_TAPE_TEXTURES = (Map)Util.m_137469_((Object)Maps.newEnumMap(DyeColor.class), map -> {
        for (DyeColor dyeColor : DyeColor.values()) {
            map.put(dyeColor, new ResourceLocation("iwannaskate", "textures/entity/skateboard/grip_tape/grip_tape_" + dyeColor.m_41065_() + ".png"));
        }
    });
    private static final ResourceLocation BASE = new ResourceLocation("iwannaskate", "textures/entity/skateboard/base.png");
    private static final Map<Holder<BannerPattern>, ResourceLocation> BANNER_PATTERN_RESOURCE_LOCATION_HASH_MAP = new HashMap<Holder<BannerPattern>, ResourceLocation>();
    private static final ResourceLocation SPOOKY_GLOW_TEXTURE = new ResourceLocation("iwannaskate", "textures/entity/skateboard/wheels/wheels_spooky_glow.png");
    private static final ResourceLocation HOVER_GLOW_TEXTURE = new ResourceLocation("iwannaskate", "textures/entity/skateboard/wheels/wheels_hover_glow.png");
    private static final Map<ResourceLocation, ResourceLocation> DECK_TEXTURES_FOR_BLOCK = new HashMap<ResourceLocation, ResourceLocation>();
    private static final SkateboardModel GRIPTAPE_MODEL = new SkateboardModel();
    private static final SkateboardModel TRUCKS_MODEL = new SkateboardModel();
    private static final SkateboardModel BANNER_MODEL = new SkateboardModel();
    private static final SkateboardModel WHEELS_MODEL = new SkateboardModel();

    public static void renderDeck(SkateboardModel model, SkateboardData data, PoseStack stack, MultiBufferSource source, int packedLight, boolean glint) {
        ResourceLocation deckTexture;
        if (DECK_TEXTURES_FOR_BLOCK.containsKey(data.getWoodBlock())) {
            deckTexture = DECK_TEXTURES_FOR_BLOCK.get(data.getWoodBlock());
        } else {
            ResourceLocation res = new ResourceLocation("iwannaskate", "textures/entity/skateboard/generated/deck_" + data.getWoodBlock().m_135827_() + "_" + data.getWoodBlock().m_135815_());
            int[] colors = BoardColorSampler.getColor(data.getWoodBlock());
            deckTexture = DeckTexture.getOrCreateDeckTexture(res, RAW_DECK_TEXTURES, colors);
            DECK_TEXTURES_FOR_BLOCK.put(data.getWoodBlock(), deckTexture);
        }
        model.hideWheels();
        model.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_110446_((ResourceLocation)deckTexture), glint), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        model.showWheels();
    }

    public static void renderBoard(SkateboardModel model, SkateboardData data, PoseStack stack, MultiBufferSource source, int packedLight, boolean glint) {
        SkateboardTexturer.renderDeck(model, data, stack, source, packedLight, glint);
        if (data.getWheelType().hideTrucks()) {
            TRUCKS_MODEL.hideWheels();
        }
        TRUCKS_MODEL.copyFrom(model);
        TRUCKS_MODEL.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_110458_((ResourceLocation)BASE), false), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (data.getWheelType().hideTrucks()) {
            TRUCKS_MODEL.showWheels();
        }
        if (data.hasBanner()) {
            BANNER_MODEL.copyFrom(model);
            List list = BannerBlockEntity.m_58484_((DyeColor)SkateboardTexturer.getBannerColor(data), (ListTag)SkateboardTexturer.getItemPatterns(data));
            for (int i = 0; i < 17 && i < list.size(); ++i) {
                ResourceLocation patternTexture;
                Pair pair = (Pair)list.get(i);
                float[] rgb = ((DyeColor)pair.getSecond()).m_41068_();
                Holder pattern = (Holder)pair.getFirst();
                if (BANNER_PATTERN_RESOURCE_LOCATION_HASH_MAP.containsKey(pattern)) {
                    patternTexture = BANNER_PATTERN_RESOURCE_LOCATION_HASH_MAP.get(pattern);
                } else {
                    patternTexture = SkateboardTexturer.generatePatternTexture((Holder<BannerPattern>)pattern);
                    BANNER_PATTERN_RESOURCE_LOCATION_HASH_MAP.put((Holder<BannerPattern>)pattern, patternTexture);
                }
                BANNER_MODEL.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_110482_((ResourceLocation)patternTexture), false), packedLight, OverlayTexture.f_118083_, rgb[0], rgb[1], rgb[2], 1.0f);
            }
        }
        if (data.hasGripTape()) {
            GRIPTAPE_MODEL.copyFrom(model);
            GRIPTAPE_MODEL.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_110473_((ResourceLocation)GRIP_TAPE_TEXTURES.get(data.getGripTapeColor())), glint), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        SkateboardWheels wheelType = data.getWheelType();
        WHEELS_MODEL.copyFrom(model);
        if (wheelType.isEmissive()) {
            WHEELS_MODEL.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_234338_((ResourceLocation)data.getWheelType().getTexture()), false), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            WHEELS_MODEL.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_110458_((ResourceLocation)data.getWheelType().getTexture()), false), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (wheelType == SkateboardWheels.SPOOKY) {
            WHEELS_MODEL.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_110488_((ResourceLocation)SPOOKY_GLOW_TEXTURE), false), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (wheelType == SkateboardWheels.HOVER) {
            WHEELS_MODEL.m_7695_(stack, SkateboardTexturer.getVertexConsumer(source, RenderType.m_110488_((ResourceLocation)HOVER_GLOW_TEXTURE), false), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static ResourceLocation generatePatternTexture(Holder<BannerPattern> pattern) {
        ResourceLocation res = ((ResourceKey)pattern.m_203543_().get()).m_135782_();
        return new ResourceLocation("iwannaskate", "textures/entity/skateboard/banner/" + res.m_135827_() + "/" + res.m_135815_() + ".png");
    }

    @Nullable
    private static DyeColor getBannerColor(SkateboardData data) {
        CompoundTag compoundtag = data.getBannerTag();
        return compoundtag != null ? DyeColor.m_41053_((int)compoundtag.m_128451_("Base")) : DyeColor.WHITE;
    }

    @Nullable
    private static ListTag getItemPatterns(SkateboardData data) {
        ListTag listtag = null;
        CompoundTag compoundtag = data.getBannerTag();
        if (compoundtag != null && compoundtag.m_128425_("Patterns", 9)) {
            listtag = compoundtag.m_128437_("Patterns", 10).m_6426_();
        }
        return listtag;
    }

    public static VertexConsumer getVertexConsumer(MultiBufferSource bufferSource, RenderType renderType, boolean glint) {
        return glint ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferSource.m_6299_(IWSRenderTypes.SKATEBOARD_GLINT), (VertexConsumer)bufferSource.m_6299_(renderType)) : bufferSource.m_6299_(renderType);
    }
}

