/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.client.render.entity;

import com.github.alexthe668.iwannaskate.client.model.IWSModelLayers;
import com.github.alexthe668.iwannaskate.client.model.WanderingSkaterModel;
import com.github.alexthe668.iwannaskate.server.entity.WanderingSkaterEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class WanderingSkaterRenderer
extends MobRenderer<WanderingSkaterEntity, WanderingSkaterModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("iwannaskate", "textures/entity/wandering_skater.png");

    public WanderingSkaterRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new WanderingSkaterModel(context.m_174023_(IWSModelLayers.WANDERING_SKATER)), 0.5f);
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_(new SkateboardItemLayer(this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(WanderingSkaterEntity trader) {
        return TEXTURE;
    }

    protected void scale(WanderingSkaterEntity trader, PoseStack poseStack, float f) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    class SkateboardItemLayer
    extends RenderLayer<WanderingSkaterEntity, WanderingSkaterModel> {
        private final ItemInHandRenderer itemInHandRenderer;

        public SkateboardItemLayer(WanderingSkaterRenderer renderer, ItemInHandRenderer p_234819_) {
            super((RenderLayerParent)renderer);
            this.itemInHandRenderer = p_234819_;
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, int i, WanderingSkaterEntity skater, float f, float f1, float f2, float f3, float f4, float f5) {
            poseStack.m_85836_();
            float swing = skater.getAttackingProgress(f2);
            float swing2 = (float)Math.sin((double)swing * Math.PI);
            ((WanderingSkaterModel)this.m_117386_()).translateToArms(poseStack);
            poseStack.m_85837_((double)(-swing2 * 0.5f + swing * 0.2f), (double)0.1f - (double)(1.2f * swing2) + (double)(swing * 0.2f), 0.05 - (double)(swing * 1.1f));
            poseStack.m_252781_(Axis.f_252393_.m_252977_(35.0f * (1.0f - swing)));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(170.0f + swing * 100.0f));
            poseStack.m_252781_(Axis.f_252392_.m_252977_(100.0f * (1.0f - swing)));
            ItemStack offhand = skater.m_6844_(EquipmentSlot.OFFHAND);
            this.itemInHandRenderer.m_109322_((LivingEntity)skater, offhand, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, poseStack, bufferSource, i);
            poseStack.m_85849_();
            poseStack.m_85836_();
            ((WanderingSkaterModel)this.m_117386_()).translateToArms(poseStack);
            poseStack.m_85837_(0.0, (double)0.3f, (double)-0.35f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            ItemStack itemstack = skater.m_6844_(EquipmentSlot.MAINHAND);
            this.itemInHandRenderer.m_109322_((LivingEntity)skater, itemstack, ItemTransforms.TransformType.GROUND, false, poseStack, bufferSource, i);
            poseStack.m_85849_();
        }
    }
}

