/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.block;

import com.github.alexthe668.iwannaskate.server.blockentity.IWSBlockEntityRegistry;
import com.github.alexthe668.iwannaskate.server.blockentity.SkateboardRackBlockEntity;
import com.github.alexthe668.iwannaskate.server.item.BaseSkateboardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SkateboardRackBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)13.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)10.0, (double)13.0, (double)15.0, (double)16.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)3.0), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)15.0, (double)6.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape)Block.m_49796_((double)10.0, (double)2.0, (double)3.0, (double)16.0, (double)15.0, (double)13.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)3.0, (double)12.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)3.0, (double)6.0, (double)15.0, (double)13.0));

    public SkateboardRackBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction dir = context.m_43719_();
        return dir.m_122434_() == Direction.Axis.Y ? Blocks.f_50016_.m_49966_() : (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkateboardRackBlockEntity) {
            EntityCollisionContext entityCollisionContext;
            SkateboardRackBlockEntity rack = (SkateboardRackBlockEntity)blockEntity;
            if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).m_193113_() != null) {
                rack.onHoverOver(entityCollisionContext.m_193113_());
            }
        }
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState pos, LevelAccessor p_51216_, BlockPos p_51217_, BlockPos p_51218_) {
        return !state.m_60710_((LevelReader)p_51216_, p_51217_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, pos, p_51216_, p_51217_, p_51218_);
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)blockState.m_61143_((Property)FACING);
        return SkateboardRackBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(dir.m_122424_()), (Direction)dir);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof SkateboardRackBlockEntity) {
            SkateboardRackBlockEntity rack = (SkateboardRackBlockEntity)blockEntity;
            if (!player.m_6144_()) {
                int lookingAtSlot;
                int n = lookingAtSlot = hit.m_82450_().m_82546_((Vec3)Vec3.m_82528_((Vec3i)pos)).f_82480_ > 0.5 ? 0 : 1;
                if (heldItem.m_41720_() instanceof BaseSkateboardItem && rack.m_8020_(lookingAtSlot).m_41619_()) {
                    rack.m_6836_(lookingAtSlot, heldItem.m_41777_());
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!rack.m_8020_(lookingAtSlot).m_41619_()) {
                    ItemStack copy = rack.m_8020_(lookingAtSlot).m_41777_();
                    if (!player.m_36356_(copy)) {
                        SkateboardRackBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)rack.m_8020_(lookingAtSlot).m_41777_());
                    }
                    rack.m_6836_(lookingAtSlot, ItemStack.f_41583_);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkateboardRackBlockEntity) {
            int lookingAtSlot;
            SkateboardRackBlockEntity rack = (SkateboardRackBlockEntity)blockEntity;
            int n = lookingAtSlot = target.m_82450_().m_82546_((Vec3)Vec3.m_82528_((Vec3i)pos)).f_82480_ > 0.5 ? 0 : 1;
            if (!rack.m_8020_(lookingAtSlot).m_41619_()) {
                return rack.m_8020_(lookingAtSlot).m_41777_();
            }
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof SkateboardRackBlockEntity) {
            SkateboardRackBlockEntity rack = (SkateboardRackBlockEntity)tileentity;
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)rack);
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return SkateboardRackBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)IWSBlockEntityRegistry.SKATEBOARD_RACK.get()), SkateboardRackBlockEntity::commonTick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SkateboardRackBlockEntity(pos, state);
    }
}

