/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.entity;

import com.github.alexthe666.citadel.server.entity.IModifiesTime;
import com.github.alexthe666.citadel.server.tick.ServerTickRateTracker;
import com.github.alexthe666.citadel.server.tick.modifier.LocalEntityTickRateModifier;
import com.github.alexthe666.citadel.server.tick.modifier.TickRateModifier;
import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.client.particle.IWSParticleRegistry;
import com.github.alexthe668.iwannaskate.server.enchantment.IWSEnchantmentRegistry;
import com.github.alexthe668.iwannaskate.server.entity.IWSEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardPartEntity;
import com.github.alexthe668.iwannaskate.server.entity.SkaterPose;
import com.github.alexthe668.iwannaskate.server.entity.ai.SkaterMoveControl;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.github.alexthe668.iwannaskate.server.misc.IWSAdvancements;
import com.github.alexthe668.iwannaskate.server.misc.IWSDamageTypes;
import com.github.alexthe668.iwannaskate.server.misc.IWSSoundRegistry;
import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import com.github.alexthe668.iwannaskate.server.misc.SkateQuality;
import com.github.alexthe668.iwannaskate.server.network.SkateboardKeyMessage;
import com.github.alexthe668.iwannaskate.server.potion.IWSEffectRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SkateboardEntity
extends Entity
implements PlayerRideableJumping,
IModifiesTime {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> X_ROT = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Z_ROT = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> WHEEL_ROT = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> REMOVE_SOON = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STOP_MOVEMENT_FLAG = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PEDAL_AMOUNT = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> FORWARDS = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> SKATER_POSE = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GRINDING = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_MOB_SPAWNED = SynchedEntityData.m_135353_(SkateboardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final SkateboardPartEntity front;
    public final SkateboardPartEntity back;
    public final double[][] trailPositions = new double[64][4];
    public final Vec3[] lightningPositions = new Vec3[4];
    private final PartEntity<?>[] allParts;
    public SkateQuality skateQuality = SkateQuality.LOW;
    public boolean trickFlag = false;
    public int trailPosPointer = -1;
    private SkateboardData skateboardData = SkateboardData.DEFAULT;
    private Map<Enchantment, Integer> enchantments;
    private float prevZRot;
    private float prevWheelRot;
    private float onGroundProgress;
    private float prevOnGroundProgress;
    private SkaterPose prevSkaterPose = SkaterPose.NONE;
    private float prevSkaterPoseProgress = 0.0f;
    private float skaterPoseProgress = 0.0f;
    private float prevPedalAmount = 0.0f;
    private int removeIn = 0;
    private int jiggleXTime;
    private float frontHeight;
    private float backHeight;
    private int offGroundTime = 0;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private int sprintDown = 0;
    private int jumpFor = 0;
    private Vec3 prevDelta = Vec3.f_82478_;
    private BlockPos lastBlockPos = null;
    private double totalDistanceTraveled = 0.0;
    private double lastDamagedDistance = 0.0;
    private int soundTimer = 0;
    private final List<Entity> slowedDownEntities = new ArrayList<Entity>();
    private int slowMotionCooldown = 100;
    private Player returnToPlayer = null;
    public EntityDimensions size;

    public SkateboardEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
        this.front = new SkateboardPartEntity(this);
        this.back = new SkateboardPartEntity(this);
        this.allParts = new SkateboardPartEntity[]{this.front, this.back};
        this.onGroundProgress = 5.0f;
        this.prevOnGroundProgress = 5.0f;
        this.size = this.m_6095_().m_20680_();
    }

    public SkateboardEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)IWSEntityRegistry.SKATEBOARD.get(), world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEMSTACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(X_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Z_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(WHEEL_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FORWARDS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PEDAL_AMOUNT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(REMOVE_SOON, (Object)false);
        this.f_19804_.m_135372_(STOP_MOVEMENT_FLAG, (Object)false);
        this.f_19804_.m_135372_(SKATER_POSE, (Object)0);
        this.f_19804_.m_135372_(GRINDING, (Object)false);
        this.f_19804_.m_135372_(IS_MOB_SPAWNED, (Object)false);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("BoardStack")) {
            this.setItemStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_("BoardStack")));
        }
        this.totalDistanceTraveled = tag.m_128457_("TotalDistanceTraveled");
        this.lastDamagedDistance = tag.m_128457_("LastDamagedDist");
        if (tag.m_128471_("SpawnedByMob")) {
            this.setMobSpawned();
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (!this.getItemStack().m_41619_()) {
            CompoundTag stackTag = new CompoundTag();
            this.getItemStack().m_41739_(stackTag);
            tag.m_128365_("BoardStack", (Tag)stackTag);
        }
        tag.m_128350_("TotalDistanceTraveled", (float)this.totalDistanceTraveled);
        tag.m_128350_("LastDamagedDist", (float)this.lastDamagedDistance);
        tag.m_128379_("SpawnedByMob", this.isMobSpawned());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(ITEMSTACK);
    }

    public void setItemStack(ItemStack item) {
        this.f_19804_.m_135381_(ITEMSTACK, (Object)item);
        this.skateboardData = SkateboardData.fromStack(item);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (ITEMSTACK.equals(entityDataAccessor)) {
            this.skateboardData = SkateboardData.fromStack(this.getItemStack());
            this.enchantments = EnchantmentHelper.m_44831_((ItemStack)this.getItemStack());
            this.m_6210_();
            this.front.m_6210_();
            this.back.m_6210_();
        }
        if (REMOVE_SOON.equals(entityDataAccessor)) {
            this.removeIn = 5;
        }
        if (SKATER_POSE.equals(entityDataAccessor)) {
            this.prevSkaterPoseProgress = 0.0f;
            this.skaterPoseProgress = 0.0f;
        }
    }

    public SkateboardData getSkateboardData() {
        return this.skateboardData == null ? SkateboardData.DEFAULT : this.skateboardData;
    }

    public float m_146909_() {
        return ((Float)this.f_19804_.m_135370_(X_ROT)).floatValue();
    }

    public void m_146926_(float f) {
        this.f_19804_.m_135381_(X_ROT, (Object)Float.valueOf(f));
    }

    public float m_146908_() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
    }

    public void m_146922_(float f) {
        this.f_19804_.m_135381_(Y_ROT, (Object)Float.valueOf(f));
    }

    public float getZRot() {
        return ((Float)this.f_19804_.m_135370_(Z_ROT)).floatValue();
    }

    public void setZRot(float f) {
        this.f_19804_.m_135381_(Z_ROT, (Object)Float.valueOf(f));
    }

    public float getZRot(float partialTick) {
        return this.prevZRot + (this.getZRot() - this.prevZRot) * partialTick;
    }

    public float getWheelRot() {
        return ((Float)this.f_19804_.m_135370_(WHEEL_ROT)).floatValue();
    }

    public void setWheelRot(float f) {
        this.f_19804_.m_135381_(WHEEL_ROT, (Object)Float.valueOf(f));
    }

    public float getWheelRot(float partialTick) {
        return this.prevWheelRot + (this.getWheelRot() - this.prevWheelRot) * partialTick;
    }

    public float getOnGroundProgress(float partialTick) {
        return (this.prevOnGroundProgress + (this.onGroundProgress - this.prevOnGroundProgress) * partialTick) * 0.2f;
    }

    public float getPedalAmount() {
        return ((Float)this.f_19804_.m_135370_(PEDAL_AMOUNT)).floatValue();
    }

    public void setPedalAmount(float f) {
        this.f_19804_.m_135381_(PEDAL_AMOUNT, (Object)Float.valueOf(f));
    }

    public float getPedalAmount(float partialTicks) {
        return this.prevPedalAmount + (this.getPedalAmount() - this.prevPedalAmount) * partialTicks;
    }

    public float getForwards() {
        return ((Float)this.f_19804_.m_135370_(FORWARDS)).floatValue();
    }

    public void setForwards(float f) {
        this.f_19804_.m_135381_(FORWARDS, (Object)Float.valueOf(f));
    }

    public SkaterPose getSkaterPose() {
        return SkaterPose.get((Integer)this.f_19804_.m_135370_(SKATER_POSE));
    }

    public void setSkaterPose(SkaterPose animation) {
        this.f_19804_.m_135381_(SKATER_POSE, (Object)animation.ordinal());
    }

    public SkaterPose getPrevSkaterPose() {
        return this.prevSkaterPose;
    }

    public float getSkaterPoseProgress(float partialTick) {
        return (this.prevSkaterPoseProgress + (this.skaterPoseProgress - this.prevSkaterPoseProgress) * partialTick) * 0.2f;
    }

    public boolean isGrinding() {
        return (Boolean)this.f_19804_.m_135370_(GRINDING);
    }

    public void setGrinding(boolean b) {
        this.f_19804_.m_135381_(GRINDING, (Object)b);
    }

    public void setMobSpawned() {
        this.f_19804_.m_135381_(IS_MOB_SPAWNED, (Object)true);
    }

    public boolean isMobSpawned() {
        return (Boolean)this.f_19804_.m_135370_(IS_MOB_SPAWNED);
    }

    public Vec3 rotateVec(Vec3 vec3, boolean xRot, float partialTicks) {
        Vec3 rotated = vec3;
        if (xRot) {
            rotated = vec3.m_82496_(-this.m_5686_(partialTicks) * ((float)Math.PI / 180));
        }
        return rotated.m_82524_(-this.m_5675_(partialTicks) * ((float)Math.PI / 180));
    }

    public float approachRotation(float current, float target, float max) {
        float f = Mth.m_14177_((float)(target - current));
        if (f > max) {
            f = max;
        }
        if (f < -max) {
            f = -max;
        }
        return Mth.m_14177_((float)(current + f));
    }

    public void m_8119_() {
        boolean grounded;
        super.m_8119_();
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        this.prevOnGroundProgress = this.onGroundProgress;
        boolean bl = grounded = this.m_20096_() && !this.isGrinding() && this.backHeight >= this.frontHeight;
        if (grounded && this.onGroundProgress < 5.0f) {
            this.onGroundProgress += 2.5f;
        }
        if (!grounded && this.onGroundProgress > 0.0f) {
            this.onGroundProgress -= 2.5f;
        }
        if (this.f_19853_.f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_());
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(this.m_146908_() + (float)(this.lyr - (double)this.m_146908_()) / (float)this.lSteps);
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            } else {
                this.m_20090_();
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.prevZRot = this.getZRot();
            this.prevWheelRot = this.getWheelRot();
        } else {
            List list;
            this.prevDelta = this.m_20184_();
            this.m_20101_();
            if (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.ONBOARDING.get()) && !(list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, 0.5, (double)0.2f), EntitySelector.m_20421_((Entity)this))).isEmpty()) {
                for (int j = 0; j < list.size(); ++j) {
                    Entity entity = (Entity)list.get(j);
                    if (entity.m_20363_((Entity)this)) continue;
                    if (!(this.m_20160_() || entity.m_20159_() || !(entity instanceof LivingEntity) || entity instanceof WaterAnimal || entity instanceof Player || entity.m_6095_().m_204039_(IWSTags.CANNOT_SKATE))) {
                        entity.m_20329_((Entity)this);
                        continue;
                    }
                    this.m_7334_(entity);
                }
            }
            this.tickMovement();
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82542_(this.getSlowdown(), this.getSlowdown(), this.getSlowdown()));
            this.totalDistanceTraveled += this.m_20184_().m_165924_();
            if (this.totalDistanceTraveled - this.lastDamagedDistance >= 20.0) {
                this.lastDamagedDistance = this.totalDistanceTraveled;
                if (this.takesDistanceDurabilityDamage()) {
                    int setDamage = this.getItemStack().m_41773_() + 1;
                    if (setDamage >= this.getItemStack().m_41776_() - 1) {
                        this.f_19804_.m_135381_(REMOVE_SOON, (Object)true);
                    } else {
                        this.getItemStack().m_41721_(setDamage);
                    }
                }
            }
            if (this.totalDistanceTraveled % 100.0 < 1.0 && this.totalDistanceTraveled > 10000.0) {
                IWSAdvancements.trigger(this.m_146895_(), IWSAdvancements.SKATE_10K);
            }
            this.tickRotation();
        }
        this.tickMultipart();
        this.tickControls();
        this.tickSound();
        if (((Boolean)this.f_19804_.m_135370_(REMOVE_SOON)).booleanValue()) {
            if (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.INSTANT_RETURN.get()) && this.returnToPlayer != null) {
                if (!this.f_19853_.f_46443_ && !this.returnToPlayer.m_36356_(this.getItemStack().m_41777_())) {
                    this.m_19983_(this.getItemStack().m_41777_());
                }
                this.m_146870_();
            } else {
                --this.removeIn;
                this.setZRot((float)Math.sin((double)((float)this.removeIn * 0.3f) * Math.PI) * 50.0f);
                if (this.removeIn <= 0 && !this.f_19853_.f_46443_) {
                    this.removeIn = 0;
                    this.m_19983_(this.getItemStack().m_41777_());
                    this.m_146870_();
                }
            }
        }
        this.tickAnimation();
        if (this.lastBlockPos != this.m_20183_()) {
            this.skateQuality = SkateQuality.getSkateQuality(this.m_20075_(), SkateQuality.LOW);
            this.lastBlockPos = this.m_20183_();
        }
        if (this.slowMotionCooldown > 0) {
            --this.slowMotionCooldown;
        }
        this.lastBlockPos = this.m_20183_();
    }

    private boolean takesDistanceDurabilityDamage() {
        Player player;
        Entity entity;
        return this.m_146895_() != null && ((entity = this.m_146895_()) instanceof Player && !(player = (Player)entity).m_7500_() || !(this.m_146895_() instanceof Player) && !this.m_146895_().m_6095_().m_204039_(IWSTags.MAINTAINS_SKATEBOARD_DURABILITY));
    }

    public double getSlowdown() {
        if (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.SURFING.get()) && (this.m_20072_() || this.isOnWater())) {
            return 0.95;
        }
        double d = this.getBlockSlowdown();
        if (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.EARTHCROSSER.get()) && d < 0.9) {
            d = 0.9;
        }
        if (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.BENTHIC.get()) && this.m_20072_() && d < 0.9) {
            d = 0.9;
        }
        return this.m_20077_() ? (double)0.1f : (this.m_20072_() && !this.hasEnchant((Enchantment)IWSEnchantmentRegistry.BENTHIC.get()) ? (double)0.6f : (this.m_20096_() ? d : (double)0.98f));
    }

    private double getBlockSlowdown() {
        return this.getOnGroundProgress(1.0f) >= 1.0f && this.skateQuality != null ? this.skateQuality.getInertia() : (double)0.95f;
    }

    private void tickControls() {
        Player player;
        if (this.sprintDown > 0) {
            --this.sprintDown;
        }
        if (this.f_19853_.f_46443_ && (player = IWannaSkateMod.PROXY.getClientSidePlayer()) != null && player.m_20365_((Entity)this) && IWannaSkateMod.PROXY.isKeyDown(0) && this.sprintDown < 2) {
            IWannaSkateMod.sendMSGToServer(new SkateboardKeyMessage(this.m_19879_(), player.m_19879_(), 0));
            this.sprintDown = 10;
        }
        if (this.jumpFor == 0 && this.m_20096_() && this.trickFlag) {
            this.m_5496_((SoundEvent)IWSSoundRegistry.SKATEBOARD_JUMP_LAND.get(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            this.trickFlag = false;
        }
    }

    private void tickAnimation() {
        ParticleOptions particleType;
        this.prevSkaterPoseProgress = this.skaterPoseProgress;
        SkaterPose skaterPose = this.getSkaterPose();
        if (this.prevSkaterPose != skaterPose) {
            if (this.skaterPoseProgress < 5.0f) {
                this.skaterPoseProgress += 1.0f;
            } else if (this.skaterPoseProgress >= 5.0f) {
                this.prevSkaterPose = skaterPose;
            }
        } else {
            this.skaterPoseProgress = 5.0f;
        }
        float wheelRot = this.getWheelRot();
        float wheelSpeed = (float)Math.min(this.m_20184_().m_165924_(), 1.0);
        if (wheelRot > 360.0f) {
            this.prevWheelRot -= 360.0f;
            wheelRot -= 360.0f;
        }
        this.setWheelRot(wheelRot + wheelSpeed * 100.0f);
        this.prevWheelRot = wheelRot;
        if (this.f_19853_.f_46443_ && this.skateboardData != null && (particleType = this.skateboardData.getWheelType().getWheelParticles()) != null && (this.skateboardData.getWheelType().particleSpawnOverride(this) || this.f_19796_.m_188501_() < 0.5f)) {
            Vec3 center = this.m_20182_().m_82520_(0.0, 0.15 + (double)this.getRenderOffGroundAmount(1.0f), 0.0);
            float ground = this.getOnGroundProgress(1.0f);
            float forwards = 0.8f * Math.abs((float)Math.sin(Math.toRadians(this.m_146909_()))) * ground;
            float up = -0.45f * (float)Math.sin(Math.toRadians(this.m_146909_())) * ground;
            float wheelSideways = this.skateboardData.getWheelType() == SkateboardWheels.HOVER ? 0.175f : 0.25f;
            Vec3 frontRightWheel = center.m_82549_(this.rotateVec(new Vec3((double)wheelSideways, (double)up, (double)(forwards + 0.55f)), true, 1.0f));
            Vec3 frontLeftWheel = center.m_82549_(this.rotateVec(new Vec3((double)(-wheelSideways), (double)up, (double)(forwards + 0.55f)), true, 1.0f));
            Vec3 backRightWheel = center.m_82549_(this.rotateVec(new Vec3((double)wheelSideways, (double)up, (double)(forwards - 0.55f)), true, 1.0f));
            Vec3 backLeftWheel = center.m_82549_(this.rotateVec(new Vec3((double)(-wheelSideways), (double)up, (double)(forwards - 0.55f)), true, 1.0f));
            Vec3 delta = this.m_20184_().m_82490_(1.0);
            boolean deltaOverride = delta.m_82553_() > 0.04;
            float particleChance = this.skateboardData.getWheelType().getParticleChancePerTick();
            if (deltaOverride || this.f_19796_.m_188501_() < particleChance) {
                this.addWheelParticle(frontRightWheel, particleType);
            }
            if (deltaOverride || this.f_19796_.m_188501_() < particleChance) {
                this.addWheelParticle(frontLeftWheel, particleType);
            }
            if (deltaOverride || this.f_19796_.m_188501_() < particleChance) {
                this.addWheelParticle(backRightWheel, particleType);
            }
            if (deltaOverride || this.f_19796_.m_188501_() < particleChance) {
                this.addWheelParticle(backLeftWheel, particleType);
            }
        }
    }

    private void addWheelParticle(Vec3 wheelVec, ParticleOptions partice) {
        if (partice == ParticleTypes.f_123760_) {
            this.f_19853_.m_7106_(partice, wheelVec.f_82479_, wheelVec.f_82480_, wheelVec.f_82481_, this.f_19796_.m_188500_() - 0.5, -this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - 0.5);
        } else if (partice == IWSParticleRegistry.HALLOWEEN.get()) {
            this.f_19853_.m_7106_(partice, wheelVec.f_82479_, wheelVec.f_82480_, wheelVec.f_82481_, (this.f_19796_.m_188500_() - 0.5) * (double)0.35f, this.f_19796_.m_188500_() * (double)0.2f, (this.f_19796_.m_188500_() - 0.5) * (double)0.35f);
        } else if (partice == ParticleTypes.f_175821_) {
            this.f_19853_.m_7106_(partice, wheelVec.f_82479_, wheelVec.f_82480_, wheelVec.f_82481_, (this.f_19796_.m_188500_() - 0.5) * (double)0.15f, this.f_19796_.m_188500_() * (double)0.1f, (this.f_19796_.m_188500_() - 0.5) * (double)0.15f);
        } else if (partice == IWSParticleRegistry.BEE.get()) {
            Vec3 randomOffset = new Vec3((this.f_19796_.m_188500_() - 0.5) * 1.0, this.f_19796_.m_188500_() * 0.75, (this.f_19796_.m_188500_() - 0.5) * 1.0);
            Vec3 spawning = wheelVec.m_82549_(randomOffset);
            this.f_19853_.m_7106_(partice, spawning.f_82479_, spawning.f_82480_, spawning.f_82481_, wheelVec.f_82479_, wheelVec.f_82480_, wheelVec.f_82481_);
        } else if (partice == IWSParticleRegistry.HOVER.get()) {
            double speed = this.m_20184_().m_165924_();
            double d = wheelVec.f_82480_;
            if (speed < (double)0.04f) {
                d += 0.1;
            }
            this.f_19853_.m_7106_(partice, wheelVec.f_82479_, d, wheelVec.f_82481_, (double)this.m_146908_(), (double)(-0.05f - 0.1f * this.getRenderOffGroundAmount(1.0f)), speed);
        } else if (partice == IWSParticleRegistry.SPARKLE.get()) {
            this.f_19853_.m_7106_(partice, wheelVec.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * (double)0.2f - this.m_20184_().f_82479_, wheelVec.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * (double)0.2f - this.m_20184_().f_82480_, wheelVec.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * (double)0.2f - this.m_20184_().f_82481_, 0.0, 0.0, 0.0);
        } else {
            Vec3 delta = this.m_20184_();
            this.f_19853_.m_7106_(partice, wheelVec.f_82479_, wheelVec.f_82480_, wheelVec.f_82481_, delta.f_82479_, delta.f_82480_, delta.f_82481_);
        }
    }

    private void tickMovement() {
        float gravity;
        boolean onWater;
        float heightDiff = this.backHeight - this.frontHeight;
        if (Math.abs(heightDiff) > 0.0f) {
            this.setForwards(Mth.m_14036_((float)(this.getForwards() - heightDiff * 0.8f), (float)0.0f, (float)this.getMaxForwardsTicks()));
        }
        this.setGrinding(this.m_20096_() && (this.m_20075_().m_204336_(IWSTags.GRINDS) || this.m_146900_().m_204336_(IWSTags.GRINDS)));
        boolean bl = onWater = this.hasEnchant((Enchantment)IWSEnchantmentRegistry.SURFING.get()) && this.isOnWater();
        if (onWater) {
            this.m_6853_(true);
            if (this.f_19797_ % 50 == 0) {
                IWSAdvancements.trigger(this.m_146895_(), IWSAdvancements.SKATE_SURFING);
            }
        }
        float f = gravity = this.m_20072_() ? -0.2f : -0.6f + (float)this.getSlowMotionLevel() * 0.25f;
        if (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.SURFING.get())) {
            if (onWater) {
                gravity = 0.0f;
            } else if (this.m_20072_()) {
                gravity = 0.05f;
            }
        }
        if (this.m_20160_()) {
            this.f_19812_ = true;
            float forwardsOne = this.getForwards() / this.getMaxForwardsTicks();
            float forwardsStrength = (float)Math.pow(forwardsOne, 0.5);
            float speed = Math.max(forwardsStrength, 0.01f * (float)this.jumpFor) * this.getMasterSpeed();
            float yRot = this.m_146908_();
            Vec3 prev = this.m_20184_();
            if (this.isGrinding()) {
                Direction dir = this.getZRot() > 0.0f ? this.m_6374_().m_122427_() : this.m_6374_().m_122428_();
                yRot = dir.m_122435_();
                speed = 11.5f * this.getMasterSpeed();
                prev = Vec3.f_82478_;
            }
            float f1 = -Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
            float jumpAdd = this.jumpFor > 0 ? 0.5f + (float)this.getSlowMotionLevel() * 0.2f : gravity;
            Vec3 moveVec = new Vec3((double)f1, 0.0, (double)f2).m_82490_((double)speed);
            Vec3 vec31 = prev.m_82490_((double)0.975f).m_82549_(moveVec);
            this.m_20256_(new Vec3(vec31.f_82479_, (double)(0.975f * jumpAdd), vec31.f_82481_));
        } else {
            this.m_20256_(new Vec3(0.0, (double)gravity, 0.0));
            if (this.getSkaterPose() != SkaterPose.NONE) {
                this.setSkaterPose(SkaterPose.NONE);
            }
        }
        if (this.jumpFor > 0) {
            --this.jumpFor;
        }
    }

    private float getMasterSpeed() {
        float f = this.prevSkaterPose == null ? 0.0f : this.prevSkaterPose.getSpeed(this.getPedalAmount());
        float f1 = this.getSkaterPose().getSpeed(this.getPedalAmount());
        float poseProgress = this.getSkaterPoseProgress(1.0f);
        return f * (1.0f - poseProgress) + f1 * poseProgress;
    }

    public float getForwardsDecay() {
        float f = this.getSkaterPose() == SkaterPose.PEDAL ? 1.0f : (this.getSkaterPose() == SkaterPose.CROUCH ? 0.15f : 0.25f);
        float inertial = 1.0f - 0.7f * (float)this.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.INERTIAL.get()) / 3.0f;
        return f * inertial;
    }

    public float getMaxForwardsTicks() {
        return 75.0f;
    }

    private void tickMultipart() {
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        float ground = this.getOnGroundProgress(1.0f);
        float forwards = 0.25f * Math.abs((float)Math.sin(Math.toRadians(this.m_146909_()))) * ground;
        float up = -0.25f * (float)Math.sin(Math.toRadians(this.m_146909_())) * ground;
        Vec3 center = this.m_20182_();
        Vec3 frontPos = center.m_82549_(this.rotateVec(new Vec3(0.0, (double)up, (double)(forwards + 0.55f)), true, 1.0f));
        Vec3 backPos = center.m_82549_(this.rotateVec(new Vec3(0.0, (double)up, (double)(forwards - 0.55f)), true, 1.0f));
        this.front.m_146884_(frontPos);
        this.back.m_146884_(backPos);
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
        Vec3 sampleFrontHeight = center.m_82549_(this.rotateVec(new Vec3(0.0, 0.0, (double)0.55f), false, 1.0f));
        Vec3 sampleBackHeight = center.m_82549_(this.rotateVec(new Vec3(0.0, 0.0, (double)-0.55f), false, 1.0f));
        this.frontHeight = this.front.getHeightBelow(sampleFrontHeight, this.frontHeight);
        this.backHeight = this.back.getHeightBelow(sampleBackHeight, this.backHeight);
        if (this.f_19853_.f_46443_) {
            int i;
            if (this.getSkateboardData().getWheelType().hasTrail()) {
                if (this.trailPosPointer < 0) {
                    for (i = 0; i < this.trailPositions.length; ++i) {
                        this.trailPositions[i][0] = this.m_20185_();
                        this.trailPositions[i][1] = this.m_20186_();
                        this.trailPositions[i][2] = this.m_20189_();
                        this.trailPositions[i][3] = this.m_146908_();
                    }
                }
                if (++this.trailPosPointer == this.trailPositions.length) {
                    this.trailPosPointer = 0;
                }
                this.trailPositions[this.trailPosPointer][0] = this.m_20185_();
                this.trailPositions[this.trailPosPointer][1] = this.m_20186_();
                this.trailPositions[this.trailPosPointer][2] = this.m_20189_();
                this.trailPositions[this.trailPosPointer][3] = this.m_146908_();
            }
            if (this.getSkateboardData().getWheelType() == SkateboardWheels.SHOCKING) {
                i = Mth.m_14045_((int)this.f_19796_.m_188503_(4), (int)0, (int)3);
                this.lightningPositions[i] = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f));
            }
        }
    }

    private void tickRotation() {
        if (this.jiggleXTime > 0) {
            --this.jiggleXTime;
        }
        if (this.m_20096_()) {
            float forwards = 0.25f * Math.abs((float)Math.sin(Math.toRadians(this.m_146909_()))) * this.getOnGroundProgress(1.0f);
            Vec3 frontPos = this.rotateVec(new Vec3(0.0, 0.0, (double)(forwards + 0.55f)), false, 1.0f).m_82520_(0.0, (double)this.frontHeight, 0.0);
            Vec3 backPos = this.rotateVec(new Vec3(0.0, 0.0, (double)(forwards - 0.55f)), false, 1.0f).m_82520_(0.0, (double)this.backHeight, 0.0);
            Vec3 sub = frontPos.m_82546_(backPos);
            float groundXRotTarget = (float)(Mth.m_14136_((double)sub.f_82480_, (double)sub.m_165924_()) * 57.2957763671875);
            float baselineXRot = Mth.m_14036_((float)groundXRotTarget, (float)-60.0f, (float)60.0f);
            float x1 = this.approachRotation(this.m_146909_(), baselineXRot, 15.0f);
            if (this.getSkaterPose() == SkaterPose.OLLIE) {
                x1 = this.approachRotation(this.m_146909_(), -60.0f, 40.0f);
            } else if (this.isGrinding()) {
                x1 = this.approachRotation(this.m_146909_(), -35.0f, 15.0f);
            }
            if (x1 == 0.0f && Math.abs(this.m_146909_() - x1) > 5.0f) {
                if (this.jiggleXTime == 0) {
                    this.m_5496_((SoundEvent)IWSSoundRegistry.SKATEBOARD_JUMP_START.get(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
                this.jiggleXTime = 5;
            }
            if (this.jiggleXTime > 0) {
                x1 -= Math.abs((float)Math.sin((double)((float)(5 - this.jiggleXTime) * 0.25f) * Math.PI) * 4.0f);
            }
            this.m_146926_(x1);
            if (!this.isRemoveLogic() && !this.isGrinding()) {
                if (this.m_20160_()) {
                    float forwardsMin = Math.min(1.0f, this.getForwards());
                    float sidewinderAdd = this.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.SIDEWINDER.get()) * 3;
                    float y1 = this.getZRot() * forwardsMin;
                    float max = 5.0f + sidewinderAdd;
                    this.m_146922_(this.approachRotation(this.m_146908_(), this.m_146908_() + y1, max));
                }
                this.setZRot(this.approachRotation(this.getZRot(), 0.0f, 5.0f));
            }
            this.offGroundTime = 0;
        } else {
            ++this.offGroundTime;
            float f2 = (float)(-((double)((float)this.m_20184_().f_82480_) * 57.2957763671875));
            this.m_146926_(this.approachRotation(this.m_146909_(), f2, 5.0f));
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_5829_() {
        return !this.isRemoveLogic();
    }

    public boolean m_6094_() {
        return !this.isRemoveLogic();
    }

    public boolean m_6087_() {
        return !this.isRemoveLogic();
    }

    public boolean m_142391_() {
        return !this.isRemoveLogic();
    }

    public boolean m_6097_() {
        return !this.isRemoveLogic();
    }

    public boolean m_20096_() {
        return super.m_20096_() || this.hasEnchant((Enchantment)IWSEnchantmentRegistry.SURFING.get()) && this.isOnWater();
    }

    private boolean isOnWater() {
        BlockPos ourPos = new BlockPos(this.m_20185_(), this.m_20186_() + (double)0.4f, this.m_20189_());
        BlockPos underPos = this.m_20097_();
        return this.f_19853_.m_6425_(underPos).m_205070_(FluidTags.f_13131_) && !this.f_19853_.m_6425_(ourPos).m_205070_(FluidTags.f_13131_);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isRemoveLogic() {
        return (Boolean)this.f_19804_.m_135370_(REMOVE_SOON) != false || this.m_213877_();
    }

    public boolean isMultipartEntity() {
        return !this.isRemoveLogic();
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        for (PartEntity<?> part : this.allParts) {
            part.m_142687_(removalReason);
        }
        super.m_142687_(removalReason);
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lSteps > 0) {
            this.lSteps = 0;
            this.m_19890_(this.lx, this.ly, this.lz, (float)this.lyr, (float)this.lxr);
        }
    }

    @Nullable
    public Entity m_6688_() {
        return null;
    }

    public Entity getHighestRider() {
        SkateboardEntity entity = this;
        while (entity.m_20160_()) {
            entity = entity.m_146895_();
        }
        return entity;
    }

    public double m_6048_() {
        double d = 0.315 + (double)this.getRenderOffGroundAmount(1.0f);
        if (this.getSkaterPose() == SkaterPose.KICKFLIP) {
            d += 0.4 * (double)this.getSkaterPoseProgress(1.0f);
        }
        return d;
    }

    public void setStopMovementFlag(boolean b) {
        this.f_19804_.m_135381_(STOP_MOVEMENT_FLAG, (Object)b);
    }

    public void tickPlayerRider(Player passenger) {
        float yawDeviate = Mth.m_14177_((float)(passenger.m_146908_() - this.m_146908_()));
        boolean preserveForwards = false;
        if (!this.f_19853_.f_46443_) {
            if (Math.abs(passenger.f_20902_) > 0.0f) {
                if (passenger.f_20902_ < 0.0f) {
                    this.setForwards(Math.min(this.getForwards() - 3.0f, 0.0f));
                    this.m_20256_(this.m_20184_().m_82542_((double)0.8f, 1.0, (double)0.8f));
                    this.setStopMovementFlag(true);
                } else {
                    this.setForwards(Math.min(this.getForwards() + this.getPedallingAddition(), this.getMaxForwardsTicks()));
                    this.setStopMovementFlag(false);
                    if (this.getPedalAmount() < 1.0f) {
                        this.setPedalAmount(Math.min(1.0f, this.getPedalAmount() + 0.05f));
                    }
                    preserveForwards = true;
                }
                this.setSkaterPose(SkaterPose.PEDAL);
            } else {
                if (!this.trickFlag) {
                    if (this.isGrinding()) {
                        IWSAdvancements.trigger(this.m_146895_(), IWSAdvancements.TRICK_GRIND);
                        this.setSkaterPose(SkaterPose.GRIND);
                    } else if (this.m_20184_().m_82553_() > (double)0.02f) {
                        this.setSkaterPose(this.sprintDown > 0 || !this.m_20096_() ? SkaterPose.CROUCH : SkaterPose.STAND_SIDEWAYS);
                    } else {
                        this.setSkaterPose(SkaterPose.NONE);
                    }
                }
                this.setPedalAmount(Math.max(0.0f, this.getPedalAmount() - 0.2f));
            }
            if (!preserveForwards) {
                this.setForwards(Math.max(0.0f, this.getForwards() - this.getForwardsDecay()));
            }
        }
        if (this.m_20184_().m_165924_() < (double)0.03f && this.getSkaterPose() == SkaterPose.PEDAL && ((Boolean)this.f_19804_.m_135370_(STOP_MOVEMENT_FLAG)).booleanValue()) {
            this.m_146926_(this.approachRotation(this.m_146909_(), -60.0f, 30.0f));
            this.m_146922_(this.approachRotation(this.m_146908_(), passenger.f_20883_, 15.0f));
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            this.setPedalAmount(0.0f);
        } else {
            float sidewinder = this.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.SIDEWINDER.get()) + 1;
            passenger.m_5618_(this.approachRotation(passenger.f_20883_, this.m_146908_(), 35.0f));
            if (Math.abs(passenger.f_20900_) > 0.0f && !this.trickFlag) {
                this.setZRot(this.approachRotation(this.getZRot(), (-10.0f - sidewinder * 15.0f) * Math.signum(passenger.f_20900_), sidewinder * 10.0f));
            }
            if (this.getSkaterPose() != SkaterPose.NONE) {
                if (Math.abs(yawDeviate) > 25.0f && !this.trickFlag) {
                    this.setZRot(this.approachRotation(this.getZRot(), Math.signum(yawDeviate), sidewinder * 5.0f));
                }
                if (Math.abs(yawDeviate) > 90.0f) {
                    passenger.m_146922_(this.approachRotation(passenger.m_146908_(), this.m_146908_(), 5.0f));
                }
            }
        }
        if (this.f_19862_) {
            double d11 = this.m_20184_().m_165924_();
            double d3 = this.prevDelta.m_165924_();
            double d7 = d3 - d11;
            float f1 = (float)(d7 * 10.0 - 5.0);
            if (f1 > 0.0f && !this.hasEnchant((Enchantment)IWSEnchantmentRegistry.SECURED.get())) {
                ItemStack itemstack = passenger.m_6844_(EquipmentSlot.HEAD);
                boolean damageBlocked = false;
                if (!itemstack.m_41619_() && itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41773_() + 3 + this.f_19796_.m_188503_(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        passenger.m_21166_(EquipmentSlot.HEAD);
                        passenger.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                    damageBlocked = true;
                }
                if (!damageBlocked) {
                    IWSAdvancements.trigger((Entity)passenger, IWSAdvancements.TAKE_SKATE_DAMAGE);
                    passenger.m_6469_(IWSDamageTypes.SKATE_DAMAGE, 2.0f + 2.0f * f1);
                }
                passenger.m_8127_();
            }
        }
    }

    public float getPedallingAddition() {
        return 1.0f + (float)this.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.PEDALLING.get()) * 0.5f;
    }

    public void tickSound() {
        if (this.prevSkaterPose != this.getSkaterPose() && this.getSkaterPoseProgress(1.0f) == 0.0f) {
            this.m_5496_((SoundEvent)IWSSoundRegistry.SKATEBOARD_CHANGE_POSE.get(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        if (this.getSkaterPose() == SkaterPose.PEDAL && !((Boolean)this.f_19804_.m_135370_(STOP_MOVEMENT_FLAG)).booleanValue() && this.soundTimer == 0) {
            this.soundTimer = 15 + this.f_19796_.m_188503_(10);
            this.m_5496_((SoundEvent)IWSSoundRegistry.SKATEBOARD_PEDAL.get(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        if (!this.m_20067_() && !this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)67);
        }
        if (this.soundTimer > 0) {
            --this.soundTimer;
        }
    }

    public void tickMobRider(Mob passenger) {
        if (!(passenger.m_21566_() instanceof SkaterMoveControl) && passenger.m_21566_() != null) {
            passenger.f_21342_ = new SkaterMoveControl(passenger, passenger.m_21566_());
        }
        passenger.f_20883_ = this.m_146908_();
        passenger.f_20885_ = Mth.m_14036_((float)passenger.f_20885_, (float)(passenger.f_20883_ - 90.0f), (float)(passenger.f_20883_ + 90.0f));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7332_(Entity passenger) {
        this.prevPedalAmount = this.getPedalAmount();
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                if (passenger instanceof Player) {
                    this.tickPlayerRider((Player)passenger);
                } else if (living instanceof Mob) {
                    this.tickMobRider((Mob)passenger);
                }
                if (this.getSkaterPose() != SkaterPose.NONE) {
                    living.f_20923_ = 0.0f;
                    living.f_20924_ = 0.0f;
                }
                double d0 = this.m_20186_() + this.m_6048_();
                if (living.m_6095_().m_204039_(IWSTags.OVERRIDES_SKATEBOARD_POSITIONING)) {
                    d0 += living.m_6049_();
                }
                living.m_6034_(this.m_20185_(), d0, this.m_20189_());
                return;
            }
        }
        super.m_7332_(passenger);
    }

    protected void m_20351_(Entity entity) {
        super.m_20351_(entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.INSTANT_RETURN.get())) {
                this.returnToPlayer = player;
                this.f_19804_.m_135381_(REMOVE_SOON, (Object)true);
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || this.hasEnchant((Enchantment)IWSEnchantmentRegistry.HARDWOOD.get()) && damageSource != DamageSource.f_19317_ && damageSource != DamageSource.f_19318_ && !(damageSource.m_7640_() instanceof Player);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (amount > 0.0f) {
            this.f_19804_.m_135381_(REMOVE_SOON, (Object)true);
            Entity entity = source.m_7639_();
            if (entity instanceof Player) {
                Player player;
                this.returnToPlayer = player = (Player)entity;
            }
            return true;
        }
        return false;
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (!this.m_20365_(entity) && this.m_20184_().m_82553_() > (double)0.1f && this.m_20160_() && entity instanceof LivingEntity) {
            Entity rider;
            LivingEntity living = (LivingEntity)entity;
            if (this.getContactDamage() > 0 && (rider = this.m_146895_()) != null && this.shouldRiderHurtMob(rider, living) && living.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)rider), (float)this.getContactDamage())) {
                living.m_147240_(0.5, living.m_20185_() - this.m_20185_(), living.m_20189_() - this.m_20189_());
                if ((double)living.m_21223_() <= 0.0 && this.hasEnchant((Enchantment)IWSEnchantmentRegistry.BASHING.get())) {
                    IWSAdvancements.trigger(this.m_146895_(), IWSAdvancements.SKATE_BASHING);
                }
            }
        }
    }

    private boolean shouldRiderHurtMob(Entity rider, LivingEntity living) {
        if (this.m_146895_() instanceof Monster) {
            return !(living instanceof Monster);
        }
        return !living.m_7307_(rider) && !rider.m_7307_((Entity)living);
    }

    public int getContactDamage() {
        LivingEntity living;
        int i = this.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.BASHING.get()) * 2;
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)IWSItemRegistry.SPIKED_SKATER_HELMET.get())) {
            i += 2;
        }
        return i;
    }

    public float getRenderOffGroundAmount(float partialTick) {
        if (this.skateboardData.getWheelType() == SkateboardWheels.HOVER) {
            return (0.8f + (float)Math.sin(((float)this.f_19797_ + partialTick) * 0.1f) * 0.5f) * 0.6f;
        }
        return 0.0f;
    }

    public void m_6043_() {
        Player entity;
        if (this.isMobSpawned() && !this.m_20160_() && (entity = this.f_19853_.m_45930_((Entity)this, -1.0)) != null) {
            int i;
            double d0 = entity.m_20280_((Entity)this);
            if (d0 > (double)((i = this.m_6095_().m_20674_().m_21611_()) * i)) {
                this.m_146870_();
            }
            int k = this.m_6095_().m_20674_().m_21612_();
            int l = k * k;
            if (this.f_19796_.m_188503_(800) == 0 && d0 > (double)l) {
                this.m_146870_();
            }
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public double getTrailVar(int pointer, int index, float partialTick) {
        if (this.isRemoveLogic()) {
            partialTick = 1.0f;
        }
        int i = this.trailPosPointer - pointer & 0x3F;
        int j = this.trailPosPointer - pointer - 1 & 0x3F;
        double d0 = this.trailPositions[j][index];
        double d1 = Mth.m_14175_((double)(this.trailPositions[i][index] - d0));
        return d0 + d1 * (double)partialTick;
    }

    public Vec3 getTrailOffset(int offset, float partialTick) {
        double d0 = Mth.m_14139_((double)partialTick, (double)this.f_19790_, (double)this.m_20185_());
        double d1 = Mth.m_14139_((double)partialTick, (double)this.f_19791_, (double)this.m_20186_());
        double d2 = Mth.m_14139_((double)partialTick, (double)this.f_19792_, (double)this.m_20189_());
        return new Vec3(this.getTrailVar(offset, 0, partialTick) - d0, this.getTrailVar(offset, 1, partialTick) - d1, this.getTrailVar(offset, 2, partialTick) - d2);
    }

    public void onInteractPacket(Entity interacter, int type) {
        switch (type) {
            case 0: {
                if (!(interacter instanceof Player)) break;
                Player player = (Player)interacter;
                this.m_6096_(player, player.m_7655_());
                break;
            }
            case 1: {
                this.f_19804_.m_135381_(REMOVE_SOON, (Object)true);
            }
        }
    }

    public void onKeyPacket(Entity keyPresser, int type) {
        switch (type) {
            case 0: {
                this.sprintDown = 10;
            }
        }
    }

    public void m_7888_(int barAmount) {
    }

    public boolean m_7132_(Player player) {
        return this.canJump();
    }

    public boolean canJump() {
        return this.getOnGroundProgress(1.0f) >= 0.1f && this.getSkaterPose().allowJumping() && this.getSkaterPoseProgress(1.0f) >= 0.5f;
    }

    public float getStepHeight() {
        return this.hasEnchant((Enchantment)IWSEnchantmentRegistry.CLAMBERING.get()) ? 1.0f : 0.51f;
    }

    public void m_7199_(int barAmount) {
        this.trickFlag = true;
        int aerial = this.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.AERIAL.get());
        if (this.getSlowMotionLevel() > 0 && ((Boolean)IWannaSkateMod.COMMON_CONFIG.enableSlowMotion.get()).booleanValue()) {
            IWSAdvancements.trigger(this.m_146895_(), IWSAdvancements.SLOW_MOTION);
            this.enterSlowMotion();
        }
        if (barAmount >= 80) {
            this.setSkaterPose(SkaterPose.KICKFLIP);
            IWSAdvancements.trigger(this.m_146895_(), IWSAdvancements.TRICK_KICKFLIP);
            this.jumpFor = aerial * 2 + 8;
        } else {
            this.setSkaterPose(SkaterPose.OLLIE);
            IWSAdvancements.trigger(this.m_146895_(), IWSAdvancements.TRICK_OLLIE);
            this.jumpFor = aerial * 2 + 4 + barAmount / 20;
        }
        this.m_5496_((SoundEvent)IWSSoundRegistry.SKATEBOARD_JUMP_START.get(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        this.sprintDown = this.jumpFor;
    }

    private void enterSlowMotion() {
        if (!this.f_19853_.f_46443_ && this.f_19853_ instanceof ServerLevel) {
            float speed = this.getSlowMotionLevel() + 1;
            ServerTickRateTracker tracker = ServerTickRateTracker.getForServer((MinecraftServer)this.f_19853_.m_7654_());
            for (TickRateModifier modifier : tracker.tickRateModifierList) {
                LocalEntityTickRateModifier entityTick;
                if (!(modifier instanceof LocalEntityTickRateModifier) || (entityTick = (LocalEntityTickRateModifier)modifier).getEntityId() != this.m_19879_()) continue;
                return;
            }
            tracker.addTickRateModifier((TickRateModifier)new LocalEntityTickRateModifier(this.m_19879_(), this.m_6095_(), (double)((Integer)IWannaSkateMod.COMMON_CONFIG.slowMotionDistance.get()).intValue(), this.f_19853_.m_46472_(), 200, speed));
        }
    }

    private int getSlowMotionLevel() {
        Player player;
        Entity entity = this.m_146895_();
        if (entity instanceof Player && (player = (Player)entity).m_21023_((MobEffect)IWSEffectRegistry.HIGH_OCTANE.get())) {
            MobEffectInstance instance = player.m_21124_((MobEffect)IWSEffectRegistry.HIGH_OCTANE.get());
            return instance == null ? 1 : instance.m_19564_() + 1;
        }
        return 0;
    }

    public void m_8012_() {
    }

    public boolean m_142535_(float fallDistance, float damageMod, DamageSource source) {
        float listenDistance = 5.0f + 2.0f * (float)this.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.AERIAL.get());
        if (this.m_20160_() && fallDistance > listenDistance && !this.hasEnchant((Enchantment)IWSEnchantmentRegistry.SECURED.get())) {
            for (Entity entity : this.m_20197_()) {
                IWSAdvancements.trigger(entity, IWSAdvancements.TAKE_SKATE_DAMAGE);
                entity.m_142535_(fallDistance, damageMod, IWSDamageTypes.SKATE_DAMAGE);
            }
            if (fallDistance > listenDistance + 3.0f) {
                this.m_20153_();
            }
        }
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return (this.hasEnchant((Enchantment)IWSEnchantmentRegistry.SURFING.get()) || this.hasEnchant((Enchantment)IWSEnchantmentRegistry.BENTHIC.get())) && type == ForgeMod.WATER_TYPE.get();
    }

    public boolean hasGlint() {
        return this.getItemStack().m_41790_();
    }

    public boolean hasEnchant(Enchantment enchantment) {
        return this.getEnchantLevel(enchantment) > 0;
    }

    public int getEnchantLevel(Enchantment enchantment) {
        return this.enchantments == null || !this.enchantments.containsKey(enchantment) ? 0 : this.enchantments.get(enchantment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 67) {
            IWannaSkateMod.PROXY.onEntityStatus(this, id);
        } else {
            super.m_7822_(id);
        }
    }

    @Nullable
    public Component getOnMountMessage() {
        if (this.getSlowdown() < (double)0.6f) {
            return Component.m_237115_((String)"entity.iwannaskate.skateboard.ground_warning");
        }
        return null;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.getItemStack().m_41777_();
    }

    public boolean m_6000_(double x, double y, double z) {
        boolean prev = super.m_6000_(x, y, z);
        return prev || this.m_20160_() && this.m_146895_() != null && this.m_146895_().m_6000_(x, y, z);
    }

    public boolean isTimeModificationValid(TickRateModifier tickRateModifier) {
        return this.getOnGroundProgress(0.0f) < 0.9f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.size.f_20378_ != this.getBoardHeight()) {
            this.size = EntityDimensions.m_20395_((float)this.size.f_20377_, (float)this.getBoardHeight());
        }
        return this.size;
    }

    public float getBoardHeight() {
        if (this.skateboardData != null && this.skateboardData.getWheelType() == SkateboardWheels.HOVER) {
            return 0.6f;
        }
        return 0.3125f;
    }

    public boolean canWheelsMakeSound() {
        return this.skateboardData == null || !this.skateboardData.getWheelType().hideTrucks();
    }
}

