/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.entity;

import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.network.SkateboardPartMessage;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.entity.PartEntity;

public class SkateboardPartEntity
extends PartEntity<SkateboardEntity> {
    private EntityDimensions size;
    public float scale = 1.0f;

    public SkateboardPartEntity(SkateboardEntity parent) {
        super((Entity)parent);
        this.f_19850_ = true;
        this.size = EntityDimensions.m_20395_((float)0.6f, (float)0.3125f);
    }

    public EntityDimensions m_6972_(Pose pose) {
        SkateboardEntity parent = (SkateboardEntity)this.getParent();
        if (parent != null && this.size.f_20378_ != parent.getBoardHeight()) {
            this.size = EntityDimensions.m_20395_((float)this.size.f_20377_, (float)parent.getBoardHeight());
        }
        return this.size;
    }

    public boolean m_5825_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        SkateboardEntity parent = (SkateboardEntity)this.getParent();
        if (parent == null) {
            return InteractionResult.PASS;
        }
        if (player.f_19853_.f_46443_) {
            IWannaSkateMod.sendMSGToServer(new SkateboardPartMessage(parent.m_19879_(), player.m_19879_(), 0));
        }
        return parent.m_6096_(player, hand);
    }

    public boolean m_20223_(CompoundTag tag) {
        return false;
    }

    public boolean m_5829_() {
        SkateboardEntity parent = (SkateboardEntity)this.getParent();
        return parent != null && parent.m_5829_();
    }

    public boolean m_6087_() {
        SkateboardEntity parent = (SkateboardEntity)this.getParent();
        return parent != null && parent.m_6087_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        SkateboardEntity parent = (SkateboardEntity)this.getParent();
        if (!this.m_6673_(source) && parent != null) {
            Entity player = source.m_7639_();
            if (player != null && player.f_19853_.f_46443_) {
                IWannaSkateMod.sendMSGToServer(new SkateboardPartMessage(parent.m_19879_(), player.m_19879_(), 1));
            }
            parent.m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_7306_(Entity entityIn) {
        return this == entityIn || this.getParent() == entityIn;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public boolean m_142391_() {
        return false;
    }

    public float getHeightBelow(Vec3 boardPos, float height) {
        SkateboardEntity parent = (SkateboardEntity)this.getParent();
        if (parent == null) {
            return 0.0f;
        }
        BlockPos pos = new BlockPos(boardPos.f_82479_, boardPos.f_82480_ + 0.001, boardPos.f_82481_);
        float dist = this.getDistance(parent.f_19853_, pos, boardPos);
        dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(parent.f_19853_, pos.m_7495_(), boardPos) + (float)boardPos.f_82480_ % 1.0f : (float)((double)dist - (1.0 - boardPos.f_82480_ % 1.0));
        if (height <= dist && parent.m_20096_()) {
            return height == dist ? height : Math.min(height + this.getFallSpeed(), dist);
        }
        return height == dist ? height : Math.max(height - this.getRiseSpeed(), dist);
    }

    private float getDistance(Level world, BlockPos pos, Vec3 position) {
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
        if (shape.m_83281_()) {
            return 1.0f;
        }
        Optional closest = shape.m_166067_(position);
        if (closest.isEmpty()) {
            return 1.0f;
        }
        float closestY = Math.min((float)((Vec3)closest.get()).f_82480_, 1.0f);
        return position.f_82480_ < 0.0 ? closestY : 1.0f - closestY;
    }

    protected float getFallSpeed() {
        return 1.0f;
    }

    protected float getRiseSpeed() {
        return 1.0f;
    }
}

