/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.entity.ai;

import com.github.alexthe668.iwannaskate.server.enchantment.IWSEnchantmentRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.entity.SkaterPose;
import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;

public class SkaterMoveControl
extends MoveControl {
    private final MoveControl actual;
    private int pedalFor;
    private int jumpCooldown;

    public SkaterMoveControl(Mob mob, MoveControl actual) {
        super(mob);
        this.actual = actual;
    }

    public void m_8126_() {
        Entity entity = this.f_24974_.m_20202_();
        if (entity instanceof SkateboardEntity) {
            SkateboardEntity skateboard = (SkateboardEntity)entity;
            boolean decreaseSpeedNaturally = true;
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 wanted = new Vec3(this.f_24975_, this.f_24976_, this.f_24977_);
                Vec3 sub = wanted.m_82546_(skateboard.front.m_20182_());
                float targetYRot = (float)(Mth.m_14136_((double)sub.f_82481_, (double)sub.f_82479_) * 57.2957763671875) - 90.0f;
                float currentYRot = skateboard.m_146908_();
                float sidewinder = skateboard.getEnchantLevel((Enchantment)IWSEnchantmentRegistry.SIDEWINDER.get()) + 1;
                float diff = Mth.m_14177_((float)(360.0f + targetYRot - currentYRot));
                if (Math.abs(diff) > 15.0f) {
                    int skill = this.isSkilled() ? 15 : 0;
                    skateboard.setZRot(skateboard.approachRotation(skateboard.getZRot(), Math.signum(diff) * (float)(35 + skill), 5.0f));
                }
                if (sub.m_82553_() < 1.0 || sub.m_82553_() < 4.0 && this.f_24974_.m_217043_().m_188503_(50) == 0) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
                if (skateboard.getForwards() < skateboard.getMaxForwardsTicks() * 0.2f) {
                    int n = this.pedalFor = this.isSkilled() ? 60 : 60 + this.f_24974_.m_217043_().m_188503_(120);
                }
                if (skateboard.isGrinding()) {
                    skateboard.setSkaterPose(SkaterPose.GRIND);
                } else if (this.pedalFor > 0) {
                    decreaseSpeedNaturally = false;
                    skateboard.setStopMovementFlag(false);
                    skateboard.setSkaterPose(SkaterPose.PEDAL);
                    skateboard.setPedalAmount(Math.min(skateboard.getPedalAmount() + 0.1f, 1.0f));
                    skateboard.setForwards(Math.min(skateboard.getForwards() + (this.isSkilled() ? 2.0f + skateboard.getPedallingAddition() : skateboard.getPedallingAddition()), skateboard.getMaxForwardsTicks()));
                } else if (skateboard.getForwards() > skateboard.getMaxForwardsTicks() * 0.65f && this.isSkilled()) {
                    skateboard.setPedalAmount(0.0f);
                    skateboard.setStopMovementFlag(false);
                    if (!skateboard.trickFlag) {
                        skateboard.setSkaterPose(SkaterPose.CROUCH);
                    }
                } else {
                    skateboard.setStopMovementFlag(false);
                    if (!skateboard.trickFlag) {
                        skateboard.setSkaterPose(SkaterPose.STAND_SIDEWAYS);
                    }
                }
                if (skateboard.canJump()) {
                    if (skateboard.f_19862_ && this.jumpCooldown == 0) {
                        skateboard.m_7199_((int)Math.min(sub.f_82480_ * 50.0, 100.0));
                        this.jumpCooldown = 20 + this.f_24974_.m_217043_().m_188503_(50);
                    } else if (this.f_24974_.m_217043_().m_188503_(this.isSkilled() ? 30 : 250) == 0 && this.jumpCooldown == 0) {
                        skateboard.m_7199_(Math.min(20 + this.f_24974_.m_217043_().m_188503_(this.isSkilled() ? 80 : 20), 100));
                        this.jumpCooldown = this.isSkilled() ? 20 + this.f_24974_.m_217043_().m_188503_(40) : 100 + this.f_24974_.m_217043_().m_188503_(100);
                    }
                }
            } else if (this.f_24981_ == MoveControl.Operation.WAIT) {
                skateboard.setSkaterPose(SkaterPose.PEDAL);
                skateboard.setForwards(Math.max(skateboard.getForwards() - 3.0f, 0.0f));
                skateboard.setStopMovementFlag(true);
                if (skateboard.m_20184_().m_82553_() < (double)0.03f) {
                    skateboard.m_146926_(skateboard.approachRotation(skateboard.m_146909_(), -60.0f, 30.0f));
                    skateboard.m_146922_(skateboard.approachRotation(skateboard.m_146908_(), this.f_24974_.f_20885_, 15.0f));
                    skateboard.setPedalAmount(0.0f);
                }
                decreaseSpeedNaturally = false;
                skateboard.setPedalAmount(Math.max(skateboard.getPedalAmount() - 0.1f, 0.0f));
            }
            if (decreaseSpeedNaturally) {
                skateboard.setForwards(Math.max(skateboard.getForwards() - skateboard.getForwardsDecay(), 0.0f));
            }
            if (this.pedalFor > 0) {
                --this.pedalFor;
            }
            if (this.jumpCooldown > 0) {
                --this.jumpCooldown;
            }
        } else {
            this.f_24974_.f_21342_ = this.actual;
        }
    }

    private boolean isSkilled() {
        return this.f_24974_.m_6095_().m_204039_(IWSTags.SKILLED_SKATERS);
    }
}

