/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.item;

import com.github.alexthe668.iwannaskate.server.entity.IWSEntityRegistry;
import com.github.alexthe668.iwannaskate.server.entity.SkateboardEntity;
import com.github.alexthe668.iwannaskate.server.item.BaseSkateboardItem;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SkateboardItem
extends BaseSkateboardItem {
    private static final Predicate<Entity> PICKABLE_ENTITIES = EntitySelector.f_20408_.and(Entity::m_6087_);

    public SkateboardItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 1;
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return ItemStack.TooltipPart.ENCHANTMENTS.m_41809_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockHitResult raytraceresult = SkateboardItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vector3d = player.m_20252_(1.0f);
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(vector3d.m_82490_(player.getReachDistance())).m_82400_(1.0), PICKABLE_ENTITIES);
        if (!list.isEmpty()) {
            Vec3 vector3d1 = player.m_20299_(1.0f);
            for (Entity entity : list) {
                AABB axisalignedbb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!axisalignedbb.m_82390_(vector3d1)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 vec3 = raytraceresult.m_82450_();
            SkateboardEntity skateboard = (SkateboardEntity)((EntityType)IWSEntityRegistry.SKATEBOARD.get()).m_20615_(level);
            skateboard.setItemStack(itemstack.m_41777_());
            skateboard.m_146884_(vec3);
            skateboard.m_146922_(player.m_146908_());
            skateboard.m_146926_(-70.0f);
            if (!level.m_45756_((Entity)skateboard, skateboard.m_20191_().m_82400_(-0.1))) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)skateboard);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    @Override
    public boolean canHoverOver(ItemStack itemStack) {
        return SkateboardData.fromStack(itemStack).hasBanner();
    }
}

