/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.misc;

import com.github.alexthe668.iwannaskate.server.misc.IWSTags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public enum SkateQuality {
    LOW(0.3, IWSTags.LOW_SKATE_QUALITY, Material.f_76314_, Material.f_76315_, Material.f_76300_, Material.f_164530_, Material.f_76317_, Material.f_164533_, Material.f_76280_, Material.f_76313_, Material.f_76277_, Material.f_164532_),
    MEDIUM((double)0.92f, IWSTags.MID_SKATE_QUALITY, Material.f_76320_, Material.f_76272_, Material.f_76321_, Material.f_164531_),
    HIGH((double)0.935f, IWSTags.HIGH_SKATE_QUALITY, Material.f_76278_, Material.f_76275_, Material.f_76319_),
    BEST((double)0.95f, IWSTags.BEST_SKATE_QUALITY, Material.f_76279_, Material.f_76281_);

    private final double inertia;
    private final TagKey<Block> blockTag;
    private final List<Material> materialList;

    private SkateQuality(double intertia, TagKey<Block> blockTag, Material ... materials) {
        this.inertia = intertia;
        this.blockTag = blockTag;
        this.materialList = ImmutableList.copyOf((Object[])materials);
    }

    public double getInertia() {
        return this.inertia;
    }

    public static SkateQuality getSkateQuality(BlockState state, SkateQuality floor) {
        if (state.m_60795_()) {
            return HIGH;
        }
        SkateQuality tagMatch = null;
        for (SkateQuality value : SkateQuality.values()) {
            if (value.ordinal() < floor.ordinal() || !state.m_204336_(value.blockTag)) continue;
            tagMatch = value;
        }
        if (tagMatch != null) {
            return tagMatch;
        }
        SkateQuality materialMatch = null;
        for (SkateQuality value : SkateQuality.values()) {
            if (value.ordinal() < floor.ordinal() || !value.materialList.contains(state.m_60767_())) continue;
            materialMatch = value;
        }
        return materialMatch == null ? floor : materialMatch;
    }
}

