/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.network;

import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import com.github.alexthe668.iwannaskate.IWannaSkateMod;
import com.github.alexthe668.iwannaskate.server.blockentity.SkateboardRackBlockEntity;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class SkateboardRackMessage {
    public long blockPos;
    public int slot;
    public ItemStack heldStack;

    public SkateboardRackMessage(long blockPos, int slot, ItemStack heldStack) {
        this.blockPos = blockPos;
        this.slot = slot;
        this.heldStack = heldStack;
    }

    public SkateboardRackMessage() {
    }

    public static SkateboardRackMessage read(FriendlyByteBuf buf) {
        return new SkateboardRackMessage(buf.readLong(), buf.readInt(), PacketBufferUtils.readItemStack((ByteBuf)buf));
    }

    public static void write(SkateboardRackMessage message, FriendlyByteBuf buf) {
        buf.writeLong(message.blockPos);
        buf.writeInt(message.slot);
        PacketBufferUtils.writeItemStack((ByteBuf)buf, (ItemStack)message.heldStack);
    }

    public static class Handler {
        public static void handle(SkateboardRackMessage message, Supplier<NetworkEvent.Context> context) {
            BlockEntity blockEntity;
            BlockPos pos;
            context.get().setPacketHandled(true);
            ServerPlayer player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IWannaSkateMod.PROXY.getClientSidePlayer();
            }
            if (player != null && player.f_19853_ != null && player.f_19853_.m_7702_(pos = BlockPos.m_122022_((long)message.blockPos)) != null && (blockEntity = player.f_19853_.m_7702_(pos)) instanceof SkateboardRackBlockEntity) {
                SkateboardRackBlockEntity blockEntity2 = (SkateboardRackBlockEntity)blockEntity;
                blockEntity2.m_6836_(message.slot, message.heldStack);
            }
        }
    }
}

