/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.recipe;

import com.github.alexthe666.citadel.recipe.SpecialRecipeInGuideBook;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.github.alexthe668.iwannaskate.server.recipe.IWSRecipeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WoolCarpetBlock;

public class RecipeSkateboardGripTape
extends CustomRecipe
implements SpecialRecipeInGuideBook {
    public RecipeSkateboardGripTape(ResourceLocation name, CraftingBookCategory category) {
        super(name, category);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack skateboard = ItemStack.f_41583_;
        ItemStack carpetStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemstack2 = craftingContainer.m_8020_(i);
            if (itemstack2.m_41619_()) continue;
            Block block = Block.m_49814_((Item)itemstack2.m_41720_());
            if (block instanceof WoolCarpetBlock) {
                if (!carpetStack.m_41619_()) {
                    return false;
                }
                carpetStack = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
                return false;
            }
            if (!skateboard.m_41619_()) {
                return false;
            }
            if (SkateboardData.fromStack(itemstack2).hasGripTape()) {
                return false;
            }
            skateboard = itemstack2;
        }
        return !skateboard.m_41619_() && !carpetStack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer container) {
        ItemStack carpet = ItemStack.f_41583_;
        ItemStack skateboard = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack2 = container.m_8020_(i);
            if (itemstack2.m_41619_()) continue;
            Block block = Block.m_49814_((Item)itemstack2.m_41720_());
            if (block instanceof WoolCarpetBlock) {
                carpet = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) continue;
            skateboard = itemstack2.m_41777_();
        }
        if (skateboard.m_41619_()) {
            return skateboard;
        }
        SkateboardData data = SkateboardData.fromStack(skateboard);
        Block block = Block.m_49814_((Item)carpet.m_41720_());
        if (block instanceof WoolCarpetBlock) {
            WoolCarpetBlock carpetBlock = (WoolCarpetBlock)block;
            data.setGripTape(carpetBlock.m_58309_());
        }
        SkateboardData.setStackData(skateboard, data);
        return skateboard;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)IWSRecipeRegistry.SKATEBOARD_GRIP_TAPE.get();
    }

    public NonNullList<Ingredient> getDisplayIngredients() {
        ItemStack skateboard = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
        SkateboardData data = SkateboardData.fromStack(skateboard);
        data.removeGripTape();
        data.removeBanner();
        data.setWheelType(SkateboardWheels.DEFAULT);
        SkateboardData.setStackData(skateboard, data);
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{skateboard}), Ingredient.m_204132_((TagKey)ItemTags.f_215867_)});
    }

    public ItemStack getDisplayResultFor(NonNullList<ItemStack> nonNullList) {
        ItemStack carpet = ItemStack.f_41583_;
        ItemStack skateboard = ItemStack.f_41583_;
        for (int i = 0; i < nonNullList.size(); ++i) {
            ItemStack itemstack2 = (ItemStack)nonNullList.get(i);
            if (itemstack2.m_41619_()) continue;
            Block block = Block.m_49814_((Item)itemstack2.m_41720_());
            if (block instanceof WoolCarpetBlock) {
                carpet = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) continue;
            skateboard = itemstack2.m_41777_();
        }
        if (skateboard.m_41619_()) {
            return skateboard;
        }
        SkateboardData data = SkateboardData.fromStack(skateboard);
        Block block = Block.m_49814_((Item)carpet.m_41720_());
        if (block instanceof WoolCarpetBlock) {
            WoolCarpetBlock carpetBlock = (WoolCarpetBlock)block;
            data.setGripTape(carpetBlock.m_58309_());
        }
        SkateboardData.setStackData(skateboard, data);
        return skateboard;
    }
}

