/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.recipe;

import com.github.alexthe666.citadel.recipe.SpecialRecipeInGuideBook;
import com.github.alexthe668.iwannaskate.server.enchantment.IWSEnchantmentRegistry;
import com.github.alexthe668.iwannaskate.server.item.IWSItemRegistry;
import com.github.alexthe668.iwannaskate.server.item.SkateboardData;
import com.github.alexthe668.iwannaskate.server.item.SkateboardWheels;
import com.github.alexthe668.iwannaskate.server.recipe.IWSRecipeRegistry;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeSkateboardShimmer
extends CustomRecipe
implements SpecialRecipeInGuideBook {
    public RecipeSkateboardShimmer(ResourceLocation name, CraftingBookCategory category) {
        super(name, category);
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack skateboard = ItemStack.f_41583_;
        ItemStack waxStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemstack2 = craftingContainer.m_8020_(i);
            if (itemstack2.m_41619_()) continue;
            if (itemstack2.m_150930_((Item)IWSItemRegistry.SHIMMERING_WAX.get())) {
                if (!waxStack.m_41619_()) {
                    return false;
                }
                waxStack = itemstack2;
                continue;
            }
            if (!itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) {
                return false;
            }
            if (!skateboard.m_41619_()) {
                return false;
            }
            skateboard = itemstack2;
        }
        return !skateboard.m_41619_() && !waxStack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer container) {
        CompoundTag tag;
        ItemStack skateboard = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack2 = container.m_8020_(i);
            if (itemstack2.m_41619_() || !itemstack2.m_150930_((Item)IWSItemRegistry.SKATEBOARD.get())) continue;
            skateboard = itemstack2.m_41777_();
        }
        if (skateboard.m_41619_()) {
            return skateboard;
        }
        boolean prevRemoveShimmer = (tag = skateboard.m_41784_()).m_128471_("RemovedShimmer");
        tag.m_128379_("RemovedShimmer", !prevRemoveShimmer);
        skateboard.m_41751_(tag);
        return skateboard;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)IWSRecipeRegistry.SKATEBOARD_SHIMMER.get();
    }

    public NonNullList<Ingredient> getDisplayIngredients() {
        ItemStack skateboard = new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
        Map map = EnchantmentHelper.m_44831_((ItemStack)skateboard);
        map.putIfAbsent((Enchantment)IWSEnchantmentRegistry.AERIAL.get(), 1);
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)skateboard);
        SkateboardData data = SkateboardData.fromStack(skateboard);
        data.removeGripTape();
        data.removeBanner();
        data.setWheelType(SkateboardWheels.DEFAULT);
        SkateboardData.setStackData(skateboard, data);
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{skateboard}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)IWSItemRegistry.SHIMMERING_WAX.get()})});
    }

    public ItemStack getDisplayResultFor(NonNullList<ItemStack> nonNullList) {
        return new ItemStack((ItemLike)IWSItemRegistry.SKATEBOARD.get());
    }
}

