/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.iwannaskate.server.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class IWSWorldData
extends SavedData {
    private static final String IDENTIFIER = "iwannaskate_world_data";
    private int skaterSpawnDelay;
    private float skaterSpawnChance;
    private UUID skaterUUID;
    private static Map<Level, IWSWorldData> dataMap = new HashMap<Level, IWSWorldData>();

    public static IWSWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_7654_().m_129880_(Level.f_46428_);
            IWSWorldData fromMap = dataMap.get(overworld);
            if (fromMap == null) {
                DimensionDataStorage storage = overworld.m_8895_();
                IWSWorldData data = (IWSWorldData)storage.m_164861_(IWSWorldData::load, IWSWorldData::new, IDENTIFIER);
                if (data != null) {
                    data.m_77762_();
                }
                dataMap.put(world, data);
                return data;
            }
            return fromMap;
        }
        return null;
    }

    public static IWSWorldData load(CompoundTag nbt) {
        IWSWorldData data = new IWSWorldData();
        if (nbt.m_128425_("SkaterSpawnDelay", 99)) {
            data.skaterSpawnDelay = nbt.m_128451_("SkaterSpawnDelay");
        }
        if (nbt.m_128425_("SkaterSpawnChance", 99)) {
            data.skaterSpawnChance = nbt.m_128457_("SkaterSpawnChance");
        }
        if (nbt.m_128425_("SkaterUUID", 8)) {
            data.skaterUUID = UUID.fromString(nbt.m_128461_("SkaterUUID"));
        }
        return data;
    }

    public int getSkaterSpawnDelay() {
        return this.skaterSpawnDelay;
    }

    public void setSkaterSpawnDelay(int delay) {
        this.skaterSpawnDelay = delay;
    }

    public float getSkaterSpawnChance() {
        return this.skaterSpawnChance;
    }

    public void setSkaterSpawnChance(float chance) {
        this.skaterSpawnChance = chance;
    }

    public void setSkaterUUID(UUID id) {
        this.skaterUUID = id;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_("beachedCachalotSpawnDelay", this.skaterSpawnDelay);
        compound.m_128350_("beachedCachalotSpawnChance", this.skaterSpawnChance);
        if (this.skaterUUID != null) {
            compound.m_128359_("beachedCachalotId", this.skaterUUID.toString());
        }
        return compound;
    }
}

