/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.config.Config;
import com.autovw.advancednetherite.core.registry.ModItems;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class MobDropsLootModifier
extends LootModifier {
    public static final Codec<MobDropsLootModifier> CODEC = RecordCodecBuilder.create(instance -> MobDropsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MobDropsLootModifier::new));

    public MobDropsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity killer = (Entity)context.m_78953_(LootContextParams.f_81458_);
        Entity victim = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (killer instanceof Player) {
            Player player = (Player)killer;
            if (victim != null && ((Boolean)Config.AdditionalDropsConfig.enableAdditionalMobDrops.get()).booleanValue()) {
                ItemStack useItem = player.m_21205_();
                RandomSource random = context.m_230907_();
                if (useItem.m_150930_((Item)ModItems.NETHERITE_IRON_SWORD.get()) && victim.m_6095_() == EntityType.f_20509_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalPhantomDropChance.get()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42714_, random.m_216332_(0, 2)));
                }
                if ((useItem.m_150930_((Item)ModItems.NETHERITE_GOLD_SWORD.get()) || useItem.m_150930_((Item)ModItems.NETHERITE_DIAMOND_SWORD.get())) && victim.m_6095_() == EntityType.f_20531_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalZombifiedPiglinDropChance.get()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42587_, random.m_216332_(0, 3)));
                }
                if ((useItem.m_150930_((Item)ModItems.NETHERITE_GOLD_SWORD.get()) || useItem.m_150930_((Item)ModItems.NETHERITE_DIAMOND_SWORD.get())) && victim.m_6095_() == EntityType.f_20511_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalPiglinDropChance.get()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42417_, random.m_216332_(1, 1)));
                }
                if ((useItem.m_150930_((Item)ModItems.NETHERITE_EMERALD_SWORD.get()) || useItem.m_150930_((Item)ModItems.NETHERITE_DIAMOND_SWORD.get())) && victim.m_6095_() == EntityType.f_20566_ && (double)random.m_188501_() <= (Double)Config.AdditionalDropProperties.additionalEndermanDropChance.get()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42584_, random.m_216332_(0, 1)));
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

