/*
 * Decompiled with CFR 0.152.
 */
package team.creative.playerrevive.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.playerrevive.PlayerRevive;
import team.creative.playerrevive.api.IBleeding;
import team.creative.playerrevive.client.TensionSound;
import team.creative.playerrevive.mixin.LocalPlayerAccessor;
import team.creative.playerrevive.mixin.MinecraftAccessor;
import team.creative.playerrevive.packet.GiveUpPacket;
import team.creative.playerrevive.server.PlayerReviveServer;

@OnlyIn(value=Dist.CLIENT)
public class ReviveEventClient {
    public static Minecraft mc = Minecraft.m_91087_();
    public boolean lastShader = false;
    public boolean lastHighTension = false;
    public static TensionSound sound;
    public static UUID helpTarget;
    public static boolean helpActive;
    private boolean addedEffect = false;
    private int giveUpTimer = 0;

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        IBleeding revive = PlayerReviveServer.getBleeding(event.player);
        if (revive.isBleeding() && event.player != ReviveEventClient.mc.f_91074_) {
            event.player.m_20124_(Pose.SWIMMING);
        }
    }

    @SubscribeEvent
    public void click(InputEvent.InteractionKeyMappingTriggered event) {
        IBleeding revive;
        LocalPlayer player = ReviveEventClient.mc.f_91074_;
        if (player != null && (revive = PlayerReviveServer.getBleeding((Player)player)).isBleeding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = ReviveEventClient.mc.f_91074_) != null) {
            IBleeding revive = PlayerReviveServer.getBleeding((Player)player);
            if (revive.isBleeding()) {
                if (ReviveEventClient.mc.f_91066_.f_92096_.m_90857_()) {
                    if (this.giveUpTimer > PlayerRevive.CONFIG.bleeding.giveUpSeconds * 20) {
                        PlayerRevive.NETWORK.sendToServer((CreativePacket)new GiveUpPacket());
                        this.giveUpTimer = 0;
                    } else {
                        ++this.giveUpTimer;
                    }
                } else {
                    this.giveUpTimer = 0;
                }
            } else {
                this.giveUpTimer = 0;
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = ReviveEventClient.mc.f_91074_;
        if (player != null) {
            IBleeding revive = PlayerReviveServer.getBleeding((Player)player);
            if (!revive.isBleeding()) {
                Player other;
                this.lastHighTension = false;
                if (this.lastShader) {
                    ReviveEventClient.mc.f_91063_.m_109106_(mc.m_91288_());
                    this.lastShader = false;
                }
                if (this.addedEffect) {
                    player.m_21195_(MobEffects.f_19603_);
                    ((LocalPlayerAccessor)player).setHandsBusy(false);
                    this.addedEffect = false;
                }
                if (sound != null) {
                    mc.m_91106_().m_120399_((SoundInstance)sound);
                    sound = null;
                }
                if (helpActive && !ReviveEventClient.mc.f_91066_.f_92062_ && ReviveEventClient.mc.f_91080_ == null && (other = player.f_19853_.m_46003_(helpTarget)) != null) {
                    ArrayList<Component> list = new ArrayList<Component>();
                    IBleeding bleeding = PlayerReviveServer.getBleeding(other);
                    list.add((Component)Component.m_237110_((String)"playerrevive.gui.label.time_left", (Object[])new Object[]{this.formatTime(bleeding.timeLeft())}));
                    list.add((Component)Component.m_237113_((String)(bleeding.getProgress() + "/" + PlayerRevive.CONFIG.revive.requiredReviveProgress)));
                    ReviveEventClient.render(list);
                }
            } else {
                player.m_20124_(Pose.SWIMMING);
                ((LocalPlayerAccessor)player).setHandsBusy(true);
                ((MinecraftAccessor)mc).setMissTime(2);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 0, -10));
                player.f_20916_ = 0;
                this.addedEffect = true;
                if (revive.timeLeft() < 400) {
                    if (!this.lastHighTension) {
                        if (!PlayerRevive.CONFIG.disableMusic) {
                            mc.m_91106_().m_120399_((SoundInstance)sound);
                            sound = new TensionSound(new ResourceLocation("playerrevive", "hightension"), PlayerRevive.CONFIG.countdownMusicVolume, 1.0f, false);
                            mc.m_91106_().m_120367_((SoundInstance)sound);
                        }
                        this.lastHighTension = true;
                    }
                } else if (!this.lastShader) {
                    if (sound != null) {
                        mc.m_91106_().m_120399_((SoundInstance)sound);
                    }
                    if (!PlayerRevive.CONFIG.disableMusic) {
                        sound = new TensionSound(new ResourceLocation("playerrevive", "tension"), PlayerRevive.CONFIG.bleedingMusicVolume, 1.0f, true);
                        mc.m_91106_().m_120367_((SoundInstance)sound);
                    }
                }
                if (!this.lastShader) {
                    if (PlayerRevive.CONFIG.bleeding.hasShaderEffect) {
                        ReviveEventClient.mc.f_91063_.m_109128_(new ResourceLocation("shaders/post/blobs2.json"));
                    }
                    this.lastShader = true;
                }
                if (!ReviveEventClient.mc.f_91066_.f_92062_ && ReviveEventClient.mc.f_91080_ == null) {
                    ArrayList<Component> list = new ArrayList<Component>();
                    IBleeding bleeding = PlayerReviveServer.getBleeding((Player)player);
                    list.add((Component)Component.m_237110_((String)"playerrevive.gui.label.time_left", (Object[])new Object[]{this.formatTime(bleeding.timeLeft())}));
                    list.add((Component)Component.m_237113_((String)(bleeding.getProgress() + "/" + PlayerRevive.CONFIG.revive.requiredReviveProgress)));
                    list.add((Component)Component.m_237110_((String)"playerrevive.gui.hold", (Object[])new Object[]{ReviveEventClient.mc.f_91066_.f_92096_.getKey().m_84875_(), (PlayerRevive.CONFIG.bleeding.giveUpSeconds * 20 - this.giveUpTimer) / 20 + 1}));
                    ReviveEventClient.render(list);
                }
            }
        }
    }

    public static void render(List<Component> list) {
        String text;
        int i;
        int space = 15;
        int width = 0;
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            width = Math.max(width, ReviveEventClient.mc.f_91062_.m_92895_(text) + 10);
        }
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        for (i = 0; i < list.size(); ++i) {
            text = list.get(i).getString();
            ReviveEventClient.mc.f_91062_.m_92750_(new PoseStack(), text, (float)(mc.m_91268_().m_85445_() / 2 - ReviveEventClient.mc.f_91062_.m_92895_(text) / 2), (float)(mc.m_91268_().m_85446_() / 2 + (list.size() / 2 * space - space * (i + 1))), 0xFCFCFC);
        }
        RenderSystem.m_69482_();
    }

    public String formatTime(int timeLeft) {
        int lengthOfMinute = 1200;
        int lengthOfHour = lengthOfMinute * 60;
        int hours = timeLeft / lengthOfHour;
        int minutes = (timeLeft -= hours * lengthOfHour) / lengthOfMinute;
        int seconds = (timeLeft -= minutes * lengthOfMinute) / 20;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    static {
        helpActive = false;
    }
}

