/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.capability;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.message.AncientMobMessage;
import baguchan.enchantwithmob.message.MobEnchantFromOwnerMessage;
import baguchan.enchantwithmob.message.MobEnchantedMessage;
import baguchan.enchantwithmob.message.RemoveAllMobEnchantMessage;
import baguchan.enchantwithmob.message.RemoveMobEnchantOwnerMessage;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class MobEnchantCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("6699a403-e2cc-31e6-195e-4757200e0935");
    private static final AttributeModifier HEALTH_MODIFIER = new AttributeModifier(HEALTH_MODIFIER_UUID, "Health boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private List<MobEnchantHandler> mobEnchants = Lists.newArrayList();
    private Optional<LivingEntity> enchantOwner = Optional.empty();
    private boolean fromOwner;
    private EnchantType enchantType = EnchantType.NORMAL;

    public void addMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        if (!entity.f_19853_.f_46443_) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        entity.m_6210_();
    }

    public void addMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel, boolean ancient) {
        this.addMobEnchant(entity, mobEnchant, enchantLevel);
        this.setEnchantType(entity, ancient ? EnchantType.ANCIENT : EnchantType.NORMAL);
    }

    public void setEnchantType(LivingEntity entity, EnchantType enchantType) {
        this.enchantType = enchantType;
        if (!entity.f_19853_.f_46443_) {
            AncientMobMessage message = new AncientMobMessage((Entity)entity, enchantType.name());
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void addMobEnchantFromOwner(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel, LivingEntity owner) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        if (!entity.f_19853_.f_46443_) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        entity.m_6210_();
    }

    public void addOwner(LivingEntity entity, @Nullable LivingEntity owner) {
        this.fromOwner = true;
        this.enchantOwner = Optional.ofNullable(owner);
        if (!entity.f_19853_.f_46443_) {
            MobEnchantFromOwnerMessage message = new MobEnchantFromOwnerMessage((Entity)entity, (Entity)owner);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void removeOwner(LivingEntity entity) {
        this.fromOwner = false;
        this.enchantOwner = Optional.empty();
        if (!entity.f_19853_.f_46443_) {
            RemoveMobEnchantOwnerMessage message = new RemoveMobEnchantOwnerMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void removeAllMobEnchant(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.f_19853_.f_46443_) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        entity.m_6210_();
    }

    public void removeMobEnchantFromOwner(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.f_19853_.f_46443_) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        this.removeOwner(entity);
        entity.m_6210_();
    }

    public void onNewEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.f_19853_.f_46443_) {
            AttributeInstance modifiableattributeinstance;
            enchant.applyAttributesModifiersToEntity(entity, entity.m_21204_(), enchantLevel);
            if (((Boolean)EnchantConfig.COMMON.dungeonsLikeHealth.get()).booleanValue() && (modifiableattributeinstance = entity.m_21204_().m_22146_(Attributes.f_22276_)) != null && !modifiableattributeinstance.m_22109_(HEALTH_MODIFIER)) {
                modifiableattributeinstance.m_22130_(HEALTH_MODIFIER);
                modifiableattributeinstance.m_22125_(HEALTH_MODIFIER);
                entity.m_21153_(entity.m_21223_() * 1.25f);
            }
        }
    }

    protected void onChangedEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.f_19853_.f_46443_) {
            enchant.applyAttributesModifiersToEntity(entity, entity.m_21204_(), enchantLevel);
        }
    }

    protected void onRemoveEnchantEffect(LivingEntity entity, MobEnchant enchant) {
        if (!entity.f_19853_.m_5776_()) {
            enchant.removeAttributesModifiersFromEntity(entity, entity.m_21204_());
            AttributeInstance modifiableattributeinstance = entity.m_21204_().m_22146_(Attributes.f_22276_);
            if (modifiableattributeinstance != null && modifiableattributeinstance.m_22109_(HEALTH_MODIFIER)) {
                entity.m_21153_(entity.m_21223_() / 1.25f);
                modifiableattributeinstance.m_22130_(HEALTH_MODIFIER);
            }
        }
    }

    public List<MobEnchantHandler> getMobEnchants() {
        return this.mobEnchants;
    }

    public boolean hasEnchant() {
        return !this.mobEnchants.isEmpty();
    }

    public Optional<LivingEntity> getEnchantOwner() {
        return this.enchantOwner;
    }

    public boolean hasOwner() {
        return this.enchantOwner.isPresent() && this.enchantOwner.get().m_6084_();
    }

    public boolean isFromOwner() {
        return this.fromOwner;
    }

    public EnchantType getEnchantType() {
        return this.enchantType;
    }

    public boolean isAncient() {
        return this.enchantType == EnchantType.ANCIENT;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == EnchantWithMob.MOB_ENCHANT_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            listnbt.add((Object)this.mobEnchants.get(i).writeNBT());
        }
        nbt.m_128365_("StoredMobEnchants", (Tag)listnbt);
        nbt.m_128379_("FromOwner", this.fromOwner);
        nbt.m_128359_("EnchantType", this.enchantType.name());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = MobEnchantUtils.getEnchantmentListForNBT(nbt);
        this.mobEnchants.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundnbt = list.m_128728_(i);
            MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
            if (mobEnchant == null) continue;
            this.mobEnchants.add(new MobEnchantHandler(mobEnchant, MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt)));
        }
        this.fromOwner = nbt.m_128471_("FromOwner");
        this.enchantType = EnchantType.get(nbt.m_128461_("EnchantType"));
    }

    public static enum EnchantType {
        NORMAL,
        ANCIENT;


        public static EnchantType get(String nameIn) {
            for (EnchantType enchantType : EnchantType.values()) {
                if (!enchantType.name().equals(nameIn)) continue;
                return enchantType;
            }
            return NORMAL;
        }
    }
}

