/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.client.render.layer;

import baguchan.enchantwithmob.EnchantWithMob;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class EnchantLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected static final RenderStateShard.LightmapStateShard LIGHTMAP = new RenderStateShard.LightmapStateShard(true);
    protected static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("additive_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172747_);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENERGY_SWIRL_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172703_);
    protected static final RenderStateShard.CullStateShard NO_CULL = new RenderStateShard.CullStateShard(false);
    protected static final RenderStateShard.TexturingStateShard ENTITY_GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> EnchantLayer.setupGlintTexturing(0.16f), () -> RenderSystem.m_157423_());
    protected static final RenderStateShard.DepthTestStateShard EQUAL_DEPTH_TEST = new RenderStateShard.DepthTestStateShard("==", 514);
    public static final ResourceLocation ANCIENT_GLINT = new ResourceLocation("enchantwithmob", "textures/entity/ancient_glint.png");

    public EnchantLayer(RenderLayerParent<T, M> p_i50947_1_) {
        super(p_i50947_1_);
    }

    public void render(PoseStack poseStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float tick = (float)((LivingEntity)entitylivingbaseIn).f_19797_ + partialTicks;
        entitylivingbaseIn.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (cap.hasEnchant() && !entitylivingbaseIn.m_20145_()) {
                float intensity = cap.getMobEnchants().size() < 3 ? (float)cap.getMobEnchants().size() / 3.0f : 3.0f;
                float f = (float)entitylivingbaseIn.f_19797_ + partialTicks;
                EntityModel entitymodel = this.m_117386_();
                entitymodel.m_6839_((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
                this.m_117386_().m_102624_(entitymodel);
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(EnchantLayer.enchantSwirl(cap.isAncient() ? ANCIENT_GLINT : ItemRenderer.f_115092_));
                entitymodel.m_6973_((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                entitymodel.m_7695_(poseStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, intensity, intensity, intensity, 1.0f);
            }
        });
    }

    public static RenderType enchantSwirl(ResourceLocation resourceLocation) {
        return RenderType.m_173215_((String)"entity_enchant_glint", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ENERGY_SWIRL_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).m_110661_(NO_CULL).m_110671_(LIGHTMAP).m_110663_(EQUAL_DEPTH_TEST).m_110685_(ADDITIVE_TRANSPARENCY).m_110683_(ENTITY_GLINT_TEXTURING).m_110691_(false));
    }

    public static RenderType enchantBeamSwirl(ResourceLocation resourceLocation) {
        return RenderType.m_173215_((String)"entity_enchant_bean_glint", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ENERGY_SWIRL_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, false, false)).m_110661_(NO_CULL).m_110671_(LIGHTMAP).m_110685_(ADDITIVE_TRANSPARENCY).m_110683_(ENTITY_GLINT_TEXTURING).m_110691_(false));
    }

    private static void setupGlintTexturing(float p_110187_) {
        long i = Util.m_137550_() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(-f, f1, 0.0f);
        matrix4f.rotateZ(0.17453292f).scale(p_110187_);
        RenderSystem.m_253091_((Matrix4f)matrix4f);
    }
}

