/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mobenchant;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.EnchantWithMob;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.MobEnchants;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class PoisonCloudMobEnchant
extends MobEnchant {
    public PoisonCloudMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 20;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return 50;
    }

    @Override
    public void tick(LivingEntity entity, int level) {
        super.tick(entity, level);
    }

    @Override
    public boolean isCompatibleMob(LivingEntity livingEntity) {
        return ((List)EnchantConfig.COMMON.WHITELIST_SHOOT_ENTITY.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)livingEntity.m_6095_()).toString()) && !(livingEntity instanceof Witch) || livingEntity instanceof Player;
    }

    @Override
    protected boolean canApplyTogether(MobEnchant ench) {
        return ench != MobEnchants.POISON.get() && super.canApplyTogether(ench);
    }

    @Override
    public boolean isTresureEnchant() {
        return true;
    }

    @SubscribeEvent
    public static void onImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!PoisonCloudMobEnchant.shooterIsLiving(projectile) || ((List)EnchantConfig.COMMON.DISABLE_POISON_CLOUD_PROJECTILE.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)projectile.m_6095_()).toString())) {
            return;
        }
        LivingEntity owner = (LivingEntity)projectile.m_37282_();
        owner.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.POISON_CLOUD.get());
            if (cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.POISON_CLOUD.get()) && (!(projectile instanceof AbstractArrow) || !projectile.m_20096_())) {
                AreaEffectCloud areaeffectcloud = new AreaEffectCloud(owner.f_19853_, event.getRayTraceResult().m_82450_().f_82479_, event.getRayTraceResult().m_82450_().f_82480_, event.getRayTraceResult().m_82450_().f_82481_);
                areaeffectcloud.m_19712_(0.6f);
                areaeffectcloud.m_19732_(-0.01f);
                areaeffectcloud.m_19740_(10);
                areaeffectcloud.m_19734_(80);
                areaeffectcloud.m_19718_(owner);
                areaeffectcloud.m_19738_(-0.001f);
                areaeffectcloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 80, i - 1));
                owner.f_19853_.m_7967_((Entity)areaeffectcloud);
            }
        });
    }

    public static boolean shooterIsLiving(Projectile projectile) {
        return projectile.m_37282_() != null && projectile.m_37282_() instanceof LivingEntity;
    }
}

