/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.DungeonsPlus;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.function.TriFunction;

public class DPUtil {
    public static final Direction[] HORIZONTAL_DIR = (Direction[])Arrays.stream(Direction.values()).filter(d -> d.m_122434_().m_122479_()).toArray(Direction[]::new);

    public static boolean isInEllipsoid(double w, double h, double d, double x, double y, double z) {
        return ((x = w - x / 2.0) - w) * (x - w) / w + ((y = h - y / 2.0) - h) * (y - h) / h + ((z = d - z / 2.0) - d) * (z - d) / d < 1.0;
    }

    public static void fillBlob(ServerLevelAccessor level, BlockPos pos, int range, TriFunction<ServerLevelAccessor, BlockPos, RandomSource, BlockState> stateFunc, RandomSource rand, float chance) {
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos placePos;
                    BlockState state;
                    if (!DPUtil.isInEllipsoid(range, range, range, x, y, z) || !(rand.m_188501_() < chance) || (state = (BlockState)stateFunc.apply((Object)level, (Object)(placePos = pos.m_7918_(x, y, z)), (Object)rand)) == null) continue;
                    level.m_7731_(placePos, state, 2);
                }
            }
        }
    }

    public static void fillBlob(ServerLevelAccessor level, BlockPos pos, int range, BlockState state, TriPredicate<ServerLevelAccessor, BlockPos, BlockState> canPlace, RandomSource rand, float chance) {
        DPUtil.fillBlob(level, pos, range, (TriFunction<ServerLevelAccessor, BlockPos, RandomSource, BlockState>)((TriFunction)(l, p, r) -> canPlace.test(l, p, (Object)l.m_8055_(p)) ? state : null), rand, chance);
    }

    public static void fillBelow(WorldGenLevel level, RandomSource rand, BoundingBox bounds, PiecesContainer pieces, BiFunction<BlockState, RandomSource, BlockState> blockStateFunc) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minHeight = level.m_141937_();
        BoundingBox pieceBounds = pieces.m_192756_();
        int maxHeight = pieceBounds.m_162396_();
        for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
            block1: for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                pos.m_122178_(x, maxHeight, z);
                BlockState bottomState = level.m_8055_((BlockPos)pos);
                if (level.m_46859_((BlockPos)pos) || !pieceBounds.m_71051_((Vec3i)pos) || !pieces.m_192751_((BlockPos)pos)) continue;
                for (int y = maxHeight - 1; y > minHeight; --y) {
                    pos.m_142448_(y);
                    if (!level.m_8055_((BlockPos)pos).m_60767_().m_76336_()) continue block1;
                    level.m_7731_((BlockPos)pos, blockStateFunc.apply(bottomState, rand), 2);
                }
            }
        }
    }

    public static BlockPos randOffset(BlockPos pos, int range, RandomSource rand) {
        return pos.m_7918_(DPUtil.range(range, rand), DPUtil.range(range, rand), DPUtil.range(range, rand));
    }

    public static int range(int range, RandomSource rand) {
        return rand.m_188503_(range * 2) - range;
    }

    public static void placeWaystone(ServerLevelAccessor level, BlockPos pos, RandomSource rand, @Nullable Block defaultBlock) {
        if (DungeonsPlus.isWaystonesLoaded && (double)rand.m_188501_() < (Double)DPConfig.COMMON.towerWaystoneChance.get()) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            try {
                Feature waystoneFeature = (Feature)level.m_8891_().m_175515_(Registries.f_256833_).m_7745_(new ResourceLocation("waystones", "waystone"));
                if (waystoneFeature != null) {
                    level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
                    WorldGenLevel worldGenRegion = level instanceof WorldGenLevel ? (WorldGenLevel)level : level.m_6018_();
                    waystoneFeature.m_142674_(new FeaturePlaceContext(Optional.empty(), worldGenRegion, level.m_6018_().m_7726_().m_8481_(), rand, pos, (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
                    return;
                }
            }
            catch (Throwable t) {
                DungeonsPlus.LOGGER.error((Object)String.format("Failed to place waystone at (%d, %d, %d)", pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), new Object[0]);
                DungeonsPlus.LOGGER.error((Object)t, new Object[0]);
            }
        }
        level.m_7731_(pos, (defaultBlock != null ? defaultBlock : Blocks.f_50016_).m_49966_(), 2);
    }

    public static TerrainAdjustment readTerrainAdjustment(String id) {
        for (TerrainAdjustment t : TerrainAdjustment.values()) {
            if (!id.equals(t.m_7912_())) continue;
            return t;
        }
        return TerrainAdjustment.NONE;
    }
}

