/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;

@OnlyIn(value=Dist.CLIENT)
public interface CustomHandRenderer {
    public static final CustomHandRenderer SOUL_BLASTER = CustomHandRenderer::soulBlaster;

    public boolean renderItem(RenderHandEvent var1, ItemStack var2, InteractionHand var3);

    private static boolean soulBlaster(RenderHandEvent event, ItemStack stack, InteractionHand hand) {
        boolean isMainHand = hand == InteractionHand.MAIN_HAND;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player.m_6117_() && player.m_7655_() == hand) {
            HumanoidArm arm = isMainHand ? player.m_5737_() : player.m_5737_().m_20828_();
            PoseStack poseStack = event.getPoseStack();
            float swingProgress = event.getSwingProgress();
            float equipProgress = event.getEquipProgress();
            int handOffset = isMainHand ? 1 : -1;
            float x = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float y = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * ((float)Math.PI * 2)));
            float z = -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
            float useTime = (float)stack.m_41779_() - ((float)player.m_21212_() - event.getPartialTick() + 1.0f);
            float maxTime = 20.0f;
            float useProgress = Math.min(useTime, maxTime) / maxTime;
            float bob = Mth.m_14031_((float)(useTime * (useProgress + 1.0f))) * 0.015f * useProgress;
            double xBob = (float)handOffset * bob / 2.0f;
            double yBob = (double)bob + (double)useProgress / 5.0;
            double zBob = (double)useProgress / 10.0;
            poseStack.m_85836_();
            poseStack.m_85837_((double)x + xBob, (double)y + yBob, (double)z + zBob);
            float windUpRot = 10.935f * (float)handOffset;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(windUpRot * useProgress));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(-handOffset) * windUpRot * useProgress));
            CustomHandRenderer.applyItemArmTransform(poseStack, arm, equipProgress);
            CustomHandRenderer.applyItemArmAttackTransform(poseStack, arm, swingProgress);
            mc.m_91290_().m_234586_().m_109322_((LivingEntity)player, stack, isMainHand ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !isMainHand, poseStack, event.getMultiBufferSource(), event.getPackedLight());
            poseStack.m_85849_();
            return true;
        }
        return false;
    }

    private static void renderUnusedItem(PoseStack poseStack, HumanoidArm arm, float equipProgress, float swingProgress) {
        float x = -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
        float y = 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * ((float)Math.PI * 2)));
        float z = -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        int offset = arm == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_252880_((float)offset * x, y, z);
        CustomHandRenderer.applyItemArmTransform(poseStack, arm, equipProgress);
        CustomHandRenderer.applyItemArmAttackTransform(poseStack, arm, swingProgress);
    }

    private static void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm, float equipProgress) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        poseStack.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + equipProgress * -0.6f), (double)-0.72f);
    }

    private static void applyItemArmAttackTransform(PoseStack poseStack, HumanoidArm arm, float swingProgress) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        float f = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * (45.0f + f * -20.0f)));
        float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)i * f1 * -20.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f1 * -80.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)i * -45.0f));
    }

    private static void renderPlayerArm(PoseStack poseStack, MultiBufferSource buffSource, int packedLight, float swingProgress, float equipProgress, HumanoidArm arm) {
        poseStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        boolean isMain = arm != HumanoidArm.LEFT;
        float mainOffset = isMain ? 1.0f : -1.0f;
        float equip = Mth.m_14116_((float)equipProgress);
        float f2 = -0.3f * Mth.m_14031_((float)(equip * (float)Math.PI));
        float f3 = 0.4f * Mth.m_14031_((float)(equip * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.m_14031_((float)(equipProgress * (float)Math.PI));
        poseStack.m_252880_(mainOffset * (f2 + 0.64000005f), f3 + -0.6f + swingProgress * -0.6f, f4 + -0.71999997f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(mainOffset * 45.0f));
        float f5 = Mth.m_14031_((float)(equipProgress * equipProgress * (float)Math.PI));
        float f6 = Mth.m_14031_((float)(equip * (float)Math.PI));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(mainOffset * f6 * 70.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(mainOffset * f5 * -20.0f));
        LocalPlayer abstractclientplayer = mc.f_91074_;
        RenderSystem.m_157456_((int)0, (ResourceLocation)abstractclientplayer.m_108560_());
        poseStack.m_85837_((double)(mainOffset * -1.0f), (double)3.6f, 3.5);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(mainOffset * 120.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(200.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(mainOffset * -135.0f));
        poseStack.m_85837_((double)(mainOffset * 5.6f), 0.0, 0.0);
        PlayerRenderer playerRenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)abstractclientplayer);
        if (isMain) {
            playerRenderer.m_117770_(poseStack, buffSource, packedLight, (AbstractClientPlayer)abstractclientplayer);
        } else {
            playerRenderer.m_117813_(poseStack, buffSource, packedLight, (AbstractClientPlayer)abstractclientplayer);
        }
        poseStack.m_85849_();
    }
}

