/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.client.renderers;

import com.legacy.dungeons_plus.entities.WarpedAxeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WarpedAxeRenderer
extends EntityRenderer<WarpedAxeEntity> {
    private static final float MIN_CAMERA_DISTANCE_SQUARED = 12.25f;
    private final ItemRenderer itemRenderer;

    public WarpedAxeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
    }

    public void render(WarpedAxeEntity entity, float p_116086_, float partialTicks, PoseStack poseStack, MultiBufferSource buffSource, int packedLight) {
        if (entity.f_19797_ >= 2 || !(this.f_114476_.f_114358_.m_90592_().m_20280_((Entity)entity) < 12.25)) {
            poseStack.m_85836_();
            float spinRot = Mth.m_14179_((float)partialTicks, (float)entity.oldSpinRot, (float)entity.spinRot);
            poseStack.m_85837_(0.0, 0.126, 0.0);
            if (entity.isInBlock()) {
                double y = entity.m_20182_().f_82480_;
                double blockY = (double)entity.m_20183_().m_123342_() + 0.5;
                spinRot = y > blockY + 0.45 ? -20.0f : (y < blockY - 0.45 ? 120.0f : 60.0f);
            }
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f - entity.getRenderRotation()));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(spinRot));
            poseStack.m_252781_(Axis.f_252495_.m_252977_((float)Math.sin(spinRot) * 7.0f));
            poseStack.m_85837_(0.0, -0.35, 0.0);
            float s = 2.0f;
            poseStack.m_85841_(s, s, s);
            this.itemRenderer.m_174269_(entity.getAxe(), ItemTransforms.TransformType.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffSource, entity.m_19879_());
            poseStack.m_85849_();
            super.m_7392_((Entity)entity, p_116086_, partialTicks, poseStack, buffSource, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(WarpedAxeEntity entity) {
        return TextureAtlas.f_118259_;
    }
}

