/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.data.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.legacy.dungeons_plus.DungeonsPlus;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ThrownItemHitBlockTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = DungeonsPlus.locate("thrown_item_hit_block");
    private static final String ITEM_KEY = "item";
    private static final String BLOCK_KEY = "block";
    private static final String STATE_KEY = "state";
    public static final ThrownItemHitBlockTrigger TRIGGER = new ThrownItemHitBlockTrigger();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject json, EntityPredicate.Composite entityPredicate, DeserializationContext context) {
        ItemPredicate itemPredicate = null;
        if (json.has(ITEM_KEY)) {
            itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get(ITEM_KEY));
        }
        Block block = ThrownItemHitBlockTrigger.deserializeBlock(json);
        StatePropertiesPredicate statePredicate = StatePropertiesPredicate.m_67679_((JsonElement)json.get(STATE_KEY));
        if (block != null) {
            statePredicate.m_67672_(block.m_49965_(), s -> {
                throw new JsonSyntaxException("Block " + block + " has no property " + s);
            });
        }
        return new TriggerInstance(entityPredicate, itemPredicate, block, statePredicate);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject json) {
        if (json.has(BLOCK_KEY)) {
            ResourceLocation blockID = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)BLOCK_KEY));
            return (Block)BuiltInRegistries.f_256975_.m_6612_(blockID).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + blockID + "'"));
        }
        return null;
    }

    public void trigger(ServerPlayer player, ItemStack stack, BlockState state) {
        this.m_66234_(player, trigger -> trigger.matches(stack, state));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final ItemPredicate item;
        @Nullable
        private final Block block;
        private final StatePropertiesPredicate state;

        public TriggerInstance(EntityPredicate.Composite entityPredicate, @Nullable ItemPredicate itemPredicate, @Nullable Block block, StatePropertiesPredicate statePredicate) {
            super(ID, entityPredicate);
            this.item = itemPredicate;
            this.block = block;
            this.state = statePredicate;
        }

        public static TriggerInstance of(@Nullable ItemPredicate itemPredicate, @Nullable Block block) {
            return new TriggerInstance(EntityPredicate.Composite.f_36667_, itemPredicate, block, StatePropertiesPredicate.f_67658_);
        }

        public static TriggerInstance hitsBlock(@Nullable Block block) {
            return TriggerInstance.of(ItemPredicate.f_45028_, block);
        }

        public static TriggerInstance withItem(@Nullable ItemPredicate itemPredicate) {
            return TriggerInstance.of(itemPredicate, null);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            if (this.item != null) {
                json.add(ThrownItemHitBlockTrigger.ITEM_KEY, this.item.m_45048_());
            }
            if (this.block != null) {
                json.addProperty(ThrownItemHitBlockTrigger.BLOCK_KEY, BuiltInRegistries.f_256975_.m_7981_((Object)this.block).toString());
            }
            json.add(ThrownItemHitBlockTrigger.STATE_KEY, this.state.m_67666_());
            return json;
        }

        public boolean matches(ItemStack stack, BlockState state) {
            boolean itemMatches = this.item == null ? true : this.item.m_45049_(stack);
            boolean blockMatches = this.block == null ? true : state.m_60713_(this.block);
            boolean stateMatches = this.state == null ? true : this.state.m_67667_(state);
            return itemMatches && blockMatches && stateMatches;
        }
    }
}

