/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.data.providers;

import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.data.advancement.ThrownItemHitBlockTrigger;
import com.legacy.dungeons_plus.registry.DPEntityTypes;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class DPAdvancementProv
extends ForgeAdvancementProvider {
    public DPAdvancementProv(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, ExistingFileHelper existingFileHelper) {
        super(packOutput, lookup, existingFileHelper, List.of(new DungeonsPlusAdvancements()));
    }

    protected static class DungeonsPlusAdvancements
    implements ForgeAdvancementProvider.AdvancementGenerator {
        protected static Advancement findTower;
        protected static Advancement findReanimatedRuins;
        protected static Advancement findLeviathan;
        protected static Advancement findSnowyTemple;
        protected static Advancement findWarpedGarden;
        protected static Advancement findSoulPrison;
        protected static Advancement findEndRuins;
        protected static Advancement killGhast;
        protected static Advancement zombieVillagerWeakness;
        protected static Advancement hideInSnow;
        protected static Advancement axeTarget;
        protected static Advancement axePhantom;
        private String section = "";

        protected DungeonsPlusAdvancements() {
        }

        public void generate(HolderLookup.Provider lookup, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
            Advancement adventureRoot = this.builder((ItemLike)Items.f_41905_, "adventure", FrameType.TASK).m_138386_("trigger", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48141_()).m_138403_(new ResourceLocation("adventure/root"));
            Advancement netherRoot = this.builder((ItemLike)Items.f_41905_, "nether", FrameType.TASK).m_138386_("trigger", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48141_()).m_138403_(new ResourceLocation("nether/root"));
            Advancement endEnterGateway = this.builder((ItemLike)Items.f_41905_, "end", FrameType.TASK).m_138386_("trigger", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48141_()).m_138403_(new ResourceLocation("end/enter_end_gateway"));
            this.setSection("adventure");
            findTower = this.inAnyStructure(this.builder((ItemLike)Blocks.f_50223_, "find_tower", FrameType.TASK).m_138398_(adventureRoot), DPStructures.TOWER).m_138389_(saver, this.locate("find_tower"));
            findReanimatedRuins = this.inAnyStructure(this.builder((ItemLike)Blocks.f_50079_, "find_reanimated_ruins", FrameType.TASK).m_138398_(findTower), DPStructures.REANIMATED_RUINS).m_138389_(saver, this.locate("find_reanimated_ruins"));
            findLeviathan = this.inAnyStructure(this.builder((ItemLike)Blocks.f_50453_, "find_leviathan", FrameType.GOAL).m_138398_(findReanimatedRuins), DPStructures.LEVIATHAN).m_138389_(saver, this.locate("find_leviathan"));
            findSnowyTemple = this.inAnyStructure(this.builder((ItemLike)Blocks.f_50354_, "find_snowy_temple", FrameType.GOAL).m_138398_(findReanimatedRuins), DPStructures.SNOWY_TEMPLE).m_138389_(saver, this.locate("find_snowy_temple"));
            findWarpedGarden = this.inAnyStructure(this.builder((ItemLike)Blocks.f_50691_, "find_warped_garden", FrameType.GOAL).m_138398_(findReanimatedRuins), DPStructures.WARPED_GARDEN).m_138389_(saver, this.locate("find_warped_garden"));
            zombieVillagerWeakness = this.builder((ItemLike)DPItems.LEVIATHAN_BLADE.get(), "zombie_villager_leviathan", FrameType.TASK).m_138398_(findLeviathan).m_138386_("hit_zombie_villager", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_156058_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_148143_(EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)DPItems.LEVIATHAN_BLADE.get()}).m_45077_()).m_32207_()).m_36662_()), (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20530_).m_36662_())).m_138389_(saver, this.locate("zombie_villager_leviathan"));
            hideInSnow = this.builder((ItemLike)DPItems.FROSTED_COWL.get(), "hide_in_snow", FrameType.TASK).m_138398_(findSnowyTemple).m_138386_("stand_in_snow", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222633_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_32205_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)DPItems.FROSTED_COWL.get()}).m_45077_()).m_32207_()).m_36650_(LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{Blocks.f_152499_}).m_17931_()).m_52658_()).m_36662_())).m_138389_(saver, this.locate("hide_in_snow"));
            axeTarget = this.builder((ItemLike)Items.f_42793_, "axe_a_target", FrameType.TASK).m_138398_(findWarpedGarden).m_138386_("hit_target", (CriterionTriggerInstance)ThrownItemHitBlockTrigger.TriggerInstance.of(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)DPItems.WARPED_AXE.get()}).m_45077_(), Blocks.f_50716_)).m_138389_(saver, this.locate("axe_a_target"));
            axePhantom = this.builder((ItemLike)DPItems.WARPED_AXE.get(), "axe_a_phantom", FrameType.CHALLENGE).m_138398_(axeTarget).m_138354_(AdvancementRewards.Builder.m_10005_((int)50)).m_138386_("hit_phantom", (CriterionTriggerInstance)PlayerHurtEntityTrigger.TriggerInstance.m_156058_((DamagePredicate.Builder)DamagePredicate.Builder.m_24931_().m_24932_(DamageSourcePredicate.Builder.m_25471_().m_25474_(Boolean.valueOf(true)).m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)DPEntityTypes.WARPED_AXE.get()))), (EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20509_).m_36638_(DistancePredicate.m_148840_((MinMaxBounds.Doubles)MinMaxBounds.Doubles.m_154804_((double)25.0))).m_36662_())).m_138389_(saver, this.locate("axe_a_phantom"));
            this.setSection("nether");
            findSoulPrison = this.inAnyStructure(this.builder((ItemLike)Blocks.f_50085_, "find_soul_prison", FrameType.GOAL).m_138398_(netherRoot), DPStructures.SOUL_PRISON).m_138389_(saver, this.locate("find_soul_prison"));
            killGhast = this.builder((ItemLike)DPItems.SOUL_CANNON.get(), "shoot_ghast_with_soul", FrameType.TASK).m_138398_(findSoulPrison).m_138386_("kill_ghast", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48136_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20453_), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.m_25471_().m_25474_(Boolean.valueOf(true)).m_25472_(EntityPredicate.Builder.m_36633_().m_36636_((EntityType)DPEntityTypes.SOUL_FIREBALL.get())))).m_138389_(saver, this.locate("shoot_ghast_with_soul"));
            this.setSection("end");
            findEndRuins = this.inAnyStructure(this.builder((ItemLike)Blocks.f_50443_, "find_end_ruins", FrameType.GOAL).m_138398_(endEnterGateway), DPStructures.END_RUINS).m_138389_(saver, this.locate("find_end_ruins"));
        }

        private MutableComponent translate(String key) {
            return Component.m_237115_((String)("dungeons_plus:advancements" + (String)(this.section.equals("") ? "" : "." + this.section) + "." + key));
        }

        private void setSection(String name) {
            this.section = name;
        }

        private PlayerTrigger.TriggerInstance inStructure(ResourceKey<Structure> structure) {
            return PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(structure));
        }

        private Advancement.Builder inAnyStructure(Advancement.Builder builder, StructureRegistrar<?> structure) {
            structure.getStructures().forEach((name, holder) -> builder.m_138386_("in_" + (name.isEmpty() ? "structure" : name), (CriterionTriggerInstance)this.inStructure((ResourceKey<Structure>)holder.getKey())));
            builder.m_138360_(RequirementsStrategy.f_15979_);
            return builder;
        }

        private String locate(String key) {
            return DungeonsPlus.locate((String)(this.section.equals("") ? "" : this.section + "/") + key).toString();
        }

        private Advancement.Builder builder(ItemLike displayItem, String name, ResourceLocation background, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.m_138353_().m_138371_(displayItem, (Component)this.translate(name + ".title"), (Component)this.translate(name + ".description"), background, frameType, showToast, announceToChat, hidden);
        }

        private Advancement.Builder builder(ItemLike displayItem, String name, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
            return this.builder(displayItem, name, null, frameType, showToast, announceToChat, hidden);
        }

        private Advancement.Builder builder(ItemLike displayItem, String name, FrameType frameType) {
            return this.builder(displayItem, name, frameType, true, true, false);
        }
    }
}

