/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.registry;

import com.google.common.collect.ImmutableMap;
import com.legacy.dungeons_plus.structures.DPProcessors;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class DPTemplatePools {
    public static final RegistrarHandler<StructureTemplatePool> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_256948_, (String)"dungeons_plus").bootstrap(DPTemplatePools::init);
    public static final ResourceKey<StructureTemplatePool> REANIMATED_RUINS_MOSSY = HANDLER.key("reanimated_ruins/center_mossy");
    public static final ResourceKey<StructureTemplatePool> REANIMATED_RUINS_MESA = HANDLER.key("reanimated_ruins/center_mesa");
    public static final ResourceKey<StructureTemplatePool> REANIMATED_RUINS_FROZEN = HANDLER.key("reanimated_ruins/center_frozen");
    public static final ResourceKey<StructureTemplatePool> LEVIATHAN = HANDLER.key("leviathan/skeleton/spine");
    public static final ResourceKey<StructureTemplatePool> WARPED_GARDEN = HANDLER.key("warped_garden/root");
    public static final ResourceKey<StructureTemplatePool> END_RUINS = HANDLER.key("end_ruins/root");

    private static void init(BootstapContext<StructureTemplatePool> context) {
        DPTemplatePools.reanimatedRuins(context);
        DPTemplatePools.leviathan(context);
        DPTemplatePools.warpedGarden(context);
        DPTemplatePools.endRuins(context);
    }

    private static void reanimatedRuins(BootstapContext<StructureTemplatePool> context) {
        int i;
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_plus", "reanimated_ruins/", context);
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"center/mossy_0"}).maintainWater(false)).register(REANIMATED_RUINS_MOSSY);
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"center/mesa_0"}).maintainWater(false)).register(REANIMATED_RUINS_MESA);
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"center/frozen_0"}).maintainWater(false)).register(REANIMATED_RUINS_FROZEN);
        JigsawPoolBuilder basicPoolBuilder = registry.poolBuilder().maintainWater(false);
        registry.register("terminator", basicPoolBuilder.clone().names(new String[]{"terminator/0", "terminator/1"}));
        HashMap<CallSite, Integer> rooms = new HashMap<CallSite, Integer>();
        for (i = 0; i <= 11; ++i) {
            rooms.put((CallSite)((Object)("room/small_" + i)), 2);
        }
        for (i = 0; i <= 4; ++i) {
            rooms.put((CallSite)((Object)("room/large_" + i)), 2);
        }
        for (i = 0; i <= 12; ++i) {
            rooms.put((CallSite)((Object)("hallway/" + i)), 3);
        }
        for (i = 0; i <= 2; ++i) {
            rooms.put((CallSite)((Object)("stairs/" + i)), 3);
        }
        registry.registerBuilder().fallback("terminator").pools(basicPoolBuilder.clone().names(rooms)).register("room");
    }

    private static void leviathan(BootstapContext<StructureTemplatePool> context) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_plus", "leviathan/", context);
        JigsawRegistryHelper skeleton = registry.setPrefix(registry.prefix + "skeleton/");
        skeleton.registerBuilder().pools(skeleton.poolBuilder().maintainWater(false).names(new String[]{"spine_front_1", "spine_front_2"})).register(LEVIATHAN);
        skeleton.register("spine_back", skeleton.poolBuilder().maintainWater(false).names(new String[]{"spine_back_1", "spine_back_2"}));
        skeleton.register("skull", skeleton.poolBuilder().maintainWater(false).names(new String[]{"skull_1", "skull_2"}));
        skeleton.register("tail", skeleton.poolBuilder().maintainWater(false).names(new String[]{"tail_1", "tail_2"}));
        JigsawRegistryHelper temple = registry.setPrefix(registry.prefix + "temple/");
        temple.register("entrance", temple.poolBuilder().maintainWater(false).names(new String[]{"entrance_0"}));
        temple.register("main_room", temple.poolBuilder().maintainWater(false).names(new String[]{"main_room_0"}));
        temple.register("side_room_left", temple.poolBuilder().maintainWater(false).names(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).stream().map(i -> "side_room/left/" + i).toList()));
        temple.register("side_room_right", temple.poolBuilder().maintainWater(false).names(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)).stream().map(i -> "side_room/right/" + i).toList()));
        temple.register("pillar", temple.poolBuilder().maintainWater(false).names(Map.of("pillar/broken", 1, "pillar/damaged", 2, "pillar/cracked", 3, "pillar/intact", 5)));
        temple.register("statue", temple.poolBuilder().maintainWater(false).names(new String[]{"statue/creeper"}));
    }

    private static void warpedGarden(BootstapContext<StructureTemplatePool> context) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_plus", "warped_garden/", context);
        JigsawPoolBuilder builder = registry.poolBuilder().maintainWater(false);
        registry.registerBuilder().pools(builder.clone().names(new String[]{"main_0"})).register(WARPED_GARDEN);
        registry.register("cap", builder.clone().names(new String[]{"path_cap"}));
        registry.register("path", "cap", builder.clone().names(new String[]{"path_i_0", "path_l_0", "path_t_0", "path_cross_0", "path_cross_1"}));
        registry.register("bubble", "cap", builder.clone().names(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)).stream().map(i -> "bubble_" + i).toList()));
    }

    private static void endRuins(BootstapContext<StructureTemplatePool> context) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_plus", "end_ruins/", context);
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"root"})).register(END_RUINS);
        registry.register("pylon_plate_spacer", registry.poolBuilder().names(new String[]{"pylon_plate_spacer"}));
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"pylon_plate"})).projection(StructureTemplatePool.Projection.TERRAIN_MATCHING).register("pylon_plate");
        registry.register("pylon", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registry.poolBuilder().names(new String[]{"pylon/tall", "pylon/medium", "pylon/small"}), registry.poolBuilder().weight(2).names(new String[]{"pylon/tall_broken", "pylon/medium_broken", "pylon/small_broken"})}));
        registry.register("pylon/debris", registry.poolBuilder().names(new String[]{"pylon/debris_1", "pylon/debris_2", "pylon/debris_3", "pylon/debris_4"}));
        JigsawRegistryHelper towerRegistry = registry.setPrefix("end_ruins/tower/");
        JigsawPoolBuilder towerPieces = towerRegistry.poolBuilder().processors(DPProcessors.END_RUINS_TOWER.getKey());
        towerRegistry.register("base", towerPieces.clone().names(new String[]{"base_1", "base_2"}));
        towerRegistry.register("mid", towerPieces.clone().names(new String[]{"mid_1", "mid_2"}));
        towerRegistry.register("top", towerPieces.clone().names(new String[]{"top_1", "top_2"}));
        towerRegistry.register("block_pile", towerRegistry.poolBuilder().names((Map)ImmutableMap.of((Object)"block_pile_1", (Object)2, (Object)"block_pile_2", (Object)2, (Object)"block_pile_3", (Object)2, (Object)"block_pile_4", (Object)1)));
    }
}

