/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ShapedNoMirrorRecipe
extends ShapedRecipe {
    public ShapedNoMirrorRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> inputs, ItemStack output) {
        super(id, group, category, width, height, inputs, output);
    }

    public boolean m_5818_(CraftingContainer inventory, Level level) {
        for (int i = 0; i <= inventory.m_39347_() - this.getRecipeWidth(); ++i) {
            for (int j = 0; j <= inventory.m_39346_() - this.getRecipeHeight(); ++j) {
                if (!this.checkMatch(inventory, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SHAPED_NO_MIRROR.get();
    }

    private boolean checkMatch(CraftingContainer inventory, int x, int y) {
        for (int i = 0; i < inventory.m_39347_(); ++i) {
            for (int j = 0; j < inventory.m_39346_(); ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.getRecipeWidth() && l < this.getRecipeHeight()) {
                    ingredient = (Ingredient)this.m_7527_().get(k + l * this.getRecipeWidth());
                }
                if (ingredient.test(inventory.m_8020_(i + j * inventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedNoMirrorRecipe> {
        public ShapedNoMirrorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map key = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])pattern, (Map)key, (int)width, (int)height);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ShapedNoMirrorRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public ShapedNoMirrorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < ingredients.size(); ++k) {
                ingredients.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new ShapedNoMirrorRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)ingredients, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedNoMirrorRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.getRecipeWidth());
            buffer.m_130130_(recipe.getRecipeHeight());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

