/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.lib.ModTags;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class BasePaxelItem
extends DiggerItem {
    public BasePaxelItem(Tier tier) {
        this(tier, p -> p);
    }

    public BasePaxelItem(Tier tier, Function<Item.Properties, Item.Properties> properties) {
        super(4.0f, -3.2f, tier, ModTags.MINEABLE_WITH_PAXEL, properties.apply(new Item.Properties().m_41499_((int)((double)tier.m_6609_() * 1.5))));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(action) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(action) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(action);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = BasePaxelItem.tryAxeUseOn(context);
        if (result == InteractionResult.PASS) {
            result = BasePaxelItem.tryShovelUseOn(context);
        }
        return result;
    }

    private static InteractionResult tryAxeUseOn(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        InteractionHand hand = context.m_43724_();
        BlockState state = level.m_8055_(pos);
        Optional<BlockState> axeStripped = Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        Optional<BlockState> axeScraped = Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false));
        Optional<BlockState> axeWaxedOff = Optional.ofNullable(state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false));
        Optional<Object> modifiedState = Optional.empty();
        if (axeStripped.isPresent()) {
            level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            modifiedState = axeStripped;
        } else if (axeScraped.isPresent()) {
            level.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, pos, 0);
            modifiedState = axeScraped;
        } else if (axeWaxedOff.isPresent()) {
            level.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, pos, 0);
            modifiedState = axeWaxedOff;
        }
        if (modifiedState.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
            }
            level.m_7731_(pos, (BlockState)modifiedState.get(), 11);
            if (player != null) {
                stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult tryShovelUseOn(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        InteractionHand hand = context.m_43724_();
        BlockState state = level.m_8055_(pos);
        BlockState modifiedState = state.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
        BlockState newState = null;
        if (modifiedState != null && level.m_46859_(pos.m_7494_())) {
            level.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            newState = modifiedState;
        } else if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_(null, 1009, pos, 0);
            }
            CampfireBlock.m_152749_((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            newState = (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.FALSE);
        }
        if (newState != null) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, newState, 11);
                if (player != null) {
                    stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
                }
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }
}

