/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import com.natamus.treeharvester_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TreeEvent {
    private static boolean setupBlacklistRan = false;
    private static final HashMap<Level, CopyOnWriteArrayList<List<BlockPos>>> processleaves = new HashMap();
    private static final HashMap<Pair<Level, Player>, Pair<Date, Integer>> harvestSpeedCache = new HashMap();

    public static void setupBlacklist() {
        if (setupBlacklistRan) {
            return;
        }
        setupBlacklistRan = true;
        try {
            Util.setupAxeBlacklist();
        }
        catch (Exception ex) {
            System.out.println("[Tree Harvester] Something went wrong setting up the axe blacklist file.");
        }
    }

    public static void onWorldLoad(ServerLevel level) {
        processleaves.put((Level)level, new CopyOnWriteArrayList());
    }

    public static void onWorldTick(ServerLevel level) {
        if (processleaves.get(level).size() == 0) {
            return;
        }
        block0: for (List<BlockPos> leaves : processleaves.get(level)) {
            BlockPos lasttr = null;
            int size = leaves.size();
            if (size > 0) {
                for (int i = 0; i < ConfigHandler.amountOfLeavesBrokenPerTick && !leaves.isEmpty(); ++i) {
                    BlockPos tr = leaves.get(0);
                    BlockFunctions.dropBlock((Level)level, (BlockPos)tr);
                    leaves.remove(0);
                    lasttr = tr.m_7949_();
                }
            }
            if (leaves.size() != 0) continue;
            processleaves.get(level).remove(leaves);
            if (lasttr == null || !ConfigHandler.replaceSaplingOnTreeHarvest || Util.lowerlogs.size() <= 0) continue;
            BlockPos lowerlasttrpos = new BlockPos(lasttr.m_123341_(), 1, lasttr.m_123343_());
            for (Pair<BlockPos, CopyOnWriteArrayList<BlockPos>> pair : Util.lowerlogs) {
                BlockPos breakpos = (BlockPos)pair.getFirst();
                if (!BlockPosFunctions.withinDistance((BlockPos)lowerlasttrpos, (BlockPos)new BlockPos(breakpos.m_123341_(), 1, breakpos.m_123343_()), (int)5).booleanValue()) continue;
                Util.replaceSapling((Level)level, breakpos, (CopyOnWriteArrayList)pair.getSecond(), 1, null);
                Util.lowerlogs.remove(pair);
                continue block0;
            }
        }
    }

    public static boolean onTreeHarvest(Level level, Player player, BlockPos bpos, BlockState state, BlockEntity blockEntity) {
        int logcount;
        if (level.f_46443_) {
            return true;
        }
        Block block = level.m_8055_(bpos).m_60734_();
        if (!CompareBlockFunctions.isTreeLog((Block)block) && !Util.isGiantMushroomStemBlock(block)) {
            return true;
        }
        if (ConfigHandler.treeHarvestWithoutSneak ? player.m_6144_() : !player.m_6144_()) {
            return true;
        }
        ItemStack hand = player.m_21120_(InteractionHand.MAIN_HAND);
        Item handitem = hand.m_41720_();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return true;
            }
            if (!Util.allowedAxes.contains(handitem)) {
                return true;
            }
        }
        if (ConfigHandler.automaticallyFindBottomBlock) {
            BlockPos temppos = bpos.m_7949_();
            while (level.m_8055_(temppos.m_7495_()).m_60734_().equals(block)) {
                temppos = temppos.m_7495_().m_7949_();
            }
            for (BlockPos belowpos : BlockPos.m_121976_((int)(temppos.m_123341_() - 1), (int)(temppos.m_123342_() - 1), (int)(temppos.m_123343_() - 1), (int)(temppos.m_123341_() + 1), (int)(temppos.m_123342_() - 1), (int)(temppos.m_123343_() + 1))) {
                if (!level.m_8055_(belowpos).m_60734_().equals(block)) continue;
                temppos = belowpos.m_7949_();
                while (level.m_8055_(temppos.m_7495_()).m_60734_().equals(block)) {
                    temppos = temppos.m_7495_().m_7949_();
                }
                break block1;
            }
            bpos = temppos.m_7949_();
        }
        if ((logcount = Util.isTreeAndReturnLogAmount(level, bpos)) < 0) {
            return true;
        }
        int durabilitylosecount = (int)Math.ceil(1.0 / ConfigHandler.loseDurabilityModifier);
        int durabilitystartcount = -1;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos highestlog = bpos.m_7949_();
        List<BlockPos> logstobreak = Util.getAllLogsToBreak(level, bpos, logcount, block);
        for (BlockPos logpos : logstobreak) {
            if (logpos.m_123342_() > highestlog.m_123342_()) {
                highestlog = logpos.m_7949_();
            }
            BlockState logstate = level.m_8055_(logpos);
            Block log = logstate.m_60734_();
            BlockFunctions.dropBlock((Level)level, (BlockPos)logpos);
            if (player.m_7500_()) continue;
            if (ConfigHandler.loseDurabilityPerHarvestedLog) {
                if (durabilitystartcount == -1) {
                    durabilitystartcount = durabilitylosecount;
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)hand, (ServerPlayer)serverPlayer, (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
                } else if (--durabilitylosecount == 0) {
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)hand, (ServerPlayer)serverPlayer, (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
                    durabilitylosecount = durabilitystartcount;
                }
            }
            if (!ConfigHandler.increaseExhaustionPerHarvestedLog) continue;
            player.m_36399_(0.025f * (float)ConfigHandler.increaseExhaustionModifier);
        }
        if (logstobreak.size() == 0) {
            return true;
        }
        if (ConfigHandler.enableFastLeafDecay && !ConfigHandler.instantBreakLeavesAround) {
            ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
            ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
            for (BlockPos next : BlockPos.m_121976_((int)(bpos.m_123341_() - 8), (int)bpos.m_123342_(), (int)(bpos.m_123343_() - 8), (int)(bpos.m_123341_() + 8), (int)Util.highestleaf.get(bpos), (int)(bpos.m_123343_() + 8))) {
                Block nextblock = level.m_8055_(next).m_60734_();
                if (!CompareBlockFunctions.isTreeLog((Block)nextblock) && !Util.isGiantMushroomStemBlock(nextblock) || !nextblock.equals(block)) continue;
                logs.add(next.m_7949_());
            }
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(level, bpos, block, logcount);
            int h = (Integer)hv.getFirst();
            CopyOnWriteArrayList<BlockPos> leftoverleaves = new CopyOnWriteArrayList<BlockPos>();
            Block leafblock = level.m_8055_(highestlog.m_7494_()).m_60734_();
            for (BlockPos next : BlockPos.m_121976_((int)(bpos.m_123341_() - h), (int)bpos.m_123342_(), (int)(bpos.m_123343_() - h), (int)(bpos.m_123341_() + h), (int)Util.highestleaf.get(bpos), (int)(bpos.m_123343_() + h))) {
                Block nextblock = level.m_8055_(next).m_60734_();
                if (!leafblock.equals(nextblock) && (!ConfigHandler.enableNetherTrees || !nextblock.equals(Blocks.f_50701_)) || !CompareBlockFunctions.isTreeLeaf((Block)nextblock, (boolean)ConfigHandler.enableNetherTrees) && !Util.isGiantMushroomLeafBlock(nextblock)) continue;
                boolean logclose = false;
                for (BlockPos log : logs) {
                    double distance = log.m_123331_((Vec3i)next);
                    if (!BlockPosFunctions.withinDistance((BlockPos)log, (BlockPos)next, (int)3).booleanValue()) continue;
                    logclose = true;
                    break;
                }
                if (!logclose) {
                    leaves.add(next.m_7949_());
                    continue;
                }
                leftoverleaves.add(next.m_7949_());
            }
            for (BlockPos leftoverleaf : leftoverleaves) {
                if (leftoverleaves.isEmpty()) break;
                Pair<Boolean, List<BlockPos>> connectedpair = Util.isConnectedToLogs(level, leftoverleaf);
                if (((Boolean)connectedpair.getFirst()).booleanValue()) {
                    for (BlockPos connectedpos : (List)connectedpair.getSecond()) {
                        leftoverleaves.remove(connectedpos);
                    }
                    continue;
                }
                for (BlockPos connectedpos : (List)connectedpair.getSecond()) {
                    if (!leaves.contains(connectedpos)) {
                        leaves.add(connectedpos.m_7949_());
                    }
                    leftoverleaves.remove(connectedpos);
                }
            }
            Collections.shuffle(leaves);
            processleaves.get(level).add(leaves);
            Util.highestleaf.remove(bpos);
            if (ConfigHandler.increaseHarvestingTimePerLog) {
                Pair keypair = new Pair((Object)level, (Object)bpos);
                harvestSpeedCache.remove(keypair);
            }
        }
        return false;
    }

    public static float onHarvestBreakSpeed(Level level, Player player, float digSpeed, BlockState state) {
        if (!ConfigHandler.increaseHarvestingTimePerLog) {
            return digSpeed;
        }
        Block block = state.m_60734_();
        if (!CompareBlockFunctions.isTreeLog((Block)block) && !Util.isGiantMushroomStemBlock(block)) {
            return digSpeed;
        }
        if (ConfigHandler.treeHarvestWithoutSneak ? player.m_6144_() : !player.m_6144_()) {
            return digSpeed;
        }
        ItemStack hand = player.m_21120_(InteractionHand.MAIN_HAND);
        Item handitem = hand.m_41720_();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return digSpeed;
            }
            if (!Util.allowedAxes.contains(handitem)) {
                return digSpeed;
            }
        }
        int logcount = -1;
        Date now = new Date();
        Pair keypair = new Pair((Object)level, (Object)player);
        if (harvestSpeedCache.containsKey(keypair)) {
            Pair<Date, Integer> valuepair = harvestSpeedCache.get(keypair);
            long ms = now.getTime() - ((Date)valuepair.getFirst()).getTime();
            if (ms < 1000L) {
                logcount = (Integer)valuepair.getSecond();
            } else {
                harvestSpeedCache.remove(keypair);
            }
        }
        BlockPos bpos = null;
        HitResult hitResult = player.m_19907_(20.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            bpos = ((BlockHitResult)hitResult).m_82425_();
        }
        if (bpos == null) {
            return digSpeed;
        }
        if (logcount < 0) {
            if (Util.isTreeAndReturnLogAmount(level, bpos) < 0) {
                return digSpeed;
            }
            logcount = BlockPosFunctions.getBlocksNextToEachOtherMaterial((Level)level, (BlockPos)bpos, Arrays.asList(Material.f_76320_), (int)30).size();
            if (logcount <= 0) {
                return digSpeed;
            }
            harvestSpeedCache.put((Pair<Level, Player>)keypair, (Pair<Date, Integer>)new Pair((Object)now, (Object)logcount));
        }
        return digSpeed / (1.0f + (float)logcount * (float)ConfigHandler.increasedHarvestingTimePerLogModifier);
    }
}

