/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.varia.LogicFacing;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LogicSlabBlock
extends BaseBlock {
    public static final EnumProperty<LogicFacing> LOGIC_FACING = EnumProperty.m_61587_((String)"logic_facing", LogicFacing.class);
    public static final VoxelShape BLOCK_DOWN = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    public static final VoxelShape BLOCK_UP = Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_NORTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.25);
    public static final VoxelShape BLOCK_SOUTH = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_WEST = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0);
    public static final VoxelShape BLOCK_EAST = Shapes.m_83048_((double)0.75, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public LogicSlabBlock(BlockBuilder builder) {
        super(builder);
    }

    public static Direction rotateLeft(Direction downSide, Direction inputSide) {
        return switch (downSide) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> inputSide.m_122427_();
            case Direction.UP -> inputSide.m_122428_();
            case Direction.NORTH -> OrientationTools.rotateAround(inputSide, Direction.Axis.Z);
            case Direction.SOUTH -> OrientationTools.rotateAround(inputSide.m_122424_(), Direction.Axis.Z);
            case Direction.WEST -> OrientationTools.rotateAround(inputSide, Direction.Axis.X);
            case Direction.EAST -> OrientationTools.rotateAround(inputSide.m_122424_(), Direction.Axis.X);
        };
    }

    public static Direction rotateRight(Direction downSide, Direction inputSide) {
        return LogicSlabBlock.rotateLeft(downSide.m_122424_(), inputSide);
    }

    @Override
    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 hit = context.m_43720_();
        BlockPos pos = context.m_8083_();
        double hx = hit.f_82479_ - (double)pos.m_123341_();
        double hy = hit.f_82480_ - (double)pos.m_123342_();
        double hz = hit.f_82481_ - (double)pos.m_123343_();
        double dx = Math.abs(0.5 - hx);
        double dy = Math.abs(0.5 - hy);
        double dz = Math.abs(0.5 - hz);
        Direction side = context.m_43719_().m_122424_();
        return (BlockState)super.m_5573_(context).m_61124_(LOGIC_FACING, (Comparable)((Object)(switch (side) {
            case Direction.DOWN -> {
                if (dx < dz) {
                    yield hz < 0.5 ? LogicFacing.DOWN_TOSOUTH : LogicFacing.DOWN_TONORTH;
                }
                yield hx < 0.5 ? LogicFacing.DOWN_TOEAST : LogicFacing.DOWN_TOWEST;
            }
            case Direction.UP -> {
                if (dx < dz) {
                    yield hz < 0.5 ? LogicFacing.UP_TOSOUTH : LogicFacing.UP_TONORTH;
                }
                yield hx < 0.5 ? LogicFacing.UP_TOEAST : LogicFacing.UP_TOWEST;
            }
            case Direction.NORTH -> {
                if (dx < dy) {
                    yield hy < 0.5 ? LogicFacing.NORTH_TOUP : LogicFacing.NORTH_TODOWN;
                }
                yield hx < 0.5 ? LogicFacing.NORTH_TOEAST : LogicFacing.NORTH_TOWEST;
            }
            case Direction.SOUTH -> {
                if (dx < dy) {
                    yield hy < 0.5 ? LogicFacing.SOUTH_TOUP : LogicFacing.SOUTH_TODOWN;
                }
                yield hx < 0.5 ? LogicFacing.SOUTH_TOEAST : LogicFacing.SOUTH_TOWEST;
            }
            case Direction.WEST -> {
                if (dy < dz) {
                    yield hz < 0.5 ? LogicFacing.WEST_TOSOUTH : LogicFacing.WEST_TONORTH;
                }
                yield hy < 0.5 ? LogicFacing.WEST_TOUP : LogicFacing.WEST_TODOWN;
            }
            case Direction.EAST -> {
                if (dy < dz) {
                    yield hz < 0.5 ? LogicFacing.EAST_TOSOUTH : LogicFacing.EAST_TONORTH;
                }
                yield hy < 0.5 ? LogicFacing.EAST_TOUP : LogicFacing.EAST_TODOWN;
            }
            default -> LogicFacing.DOWN_TOWEST;
        })));
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch (((LogicFacing)((Object)state.m_61143_(LOGIC_FACING))).getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> BLOCK_DOWN;
            case Direction.UP -> BLOCK_UP;
            case Direction.NORTH -> BLOCK_NORTH;
            case Direction.SOUTH -> BLOCK_SOUTH;
            case Direction.WEST -> BLOCK_WEST;
            case Direction.EAST -> BLOCK_EAST;
        };
    }

    protected int getInputStrength(Level world, BlockPos pos, Direction side) {
        BlockState blockState;
        Block b;
        int power = world.m_46681_(pos.m_121945_(side), side);
        if (power < 15 && (b = (blockState = world.m_8055_(pos.m_121945_(side))).m_60734_()) == Blocks.f_50088_) {
            power = Math.max(power, (Integer)blockState.m_61143_((Property)RedStoneWireBlock.f_55500_));
        }
        return power;
    }

    @Override
    @Deprecated
    protected void checkRedstone(Level world, BlockPos pos) {
        super.checkRedstone(world, pos);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof GenericTileEntity) {
            GenericTileEntity generic = (GenericTileEntity)te;
            Direction inputSide = LogicSupport.getFacing(world.m_8055_(pos)).getInputSide();
            int power = this.getInputStrength(world, pos, inputSide);
            generic.setPowerInput(power);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (state.m_60734_() instanceof LogicSlabBlock && te instanceof GenericTileEntity) {
            Direction direction = LogicSupport.getFacing(state).getInputSide();
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH, Direction.SOUTH -> {
                    if (side == Direction.NORTH || side == Direction.SOUTH) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.WEST, Direction.EAST -> {
                    if (side == Direction.WEST || side == Direction.EAST) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.DOWN, Direction.UP -> side == Direction.DOWN || side == Direction.UP;
            };
        }
        return false;
    }

    protected int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (state.m_60734_() instanceof LogicSlabBlock && te instanceof GenericTileEntity) {
            GenericTileEntity generic = (GenericTileEntity)te;
            return generic.getRedstoneOutput(state, world, pos, side);
        }
        return 0;
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        if (state.m_60734_() instanceof LogicSlabBlock) {
            LogicFacing facing = (LogicFacing)((Object)state.m_61143_(LOGIC_FACING));
            LogicFacing newfacing = LogicFacing.rotate(facing);
            BlockState newstate = (BlockState)state.m_60734_().m_49966_().m_61124_(LOGIC_FACING, (Comparable)((Object)newfacing));
            world.m_7731_(pos, newstate, 3);
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof GenericTileEntity) {
                ((GenericTileEntity)te).rotateBlock(rot);
            }
            return newstate;
        }
        return state;
    }

    public boolean m_7899_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6378_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockAccess, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return this.getRedstoneOutput(blockState, blockAccess, pos, side);
    }

    @Override
    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LOGIC_FACING});
    }
}

