/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.api.ITabExpander;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DefaultModSetup {
    private Logger logger;
    protected CreativeModeTab creativeTab;
    private List<Supplier<ItemStack>> tabItems = new ArrayList<Supplier<ItemStack>>();

    public void init(FMLCommonSetupEvent e) {
        this.logger = LogManager.getLogger();
        this.setupModCompat();
    }

    protected abstract void setupModCompat();

    protected void createTab(String modid, String name, Supplier<ItemStack> stack) {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(event -> event.registerCreativeModeTab(new ResourceLocation(modid, name), arg_0 -> this.lambda$createTab$2(name, (Supplier)stack, arg_0)));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Item.Properties defaultProperties() {
        return new Item.Properties();
    }

    public CreativeModeTab getTab() {
        return this.creativeTab;
    }

    public <T extends Item> Supplier<T> tab(Supplier<T> supplier) {
        Lazy lazyItem = Lazy.of(supplier);
        this.tabItems.add(() -> new ItemStack((ItemLike)lazyItem.get()));
        return lazyItem;
    }

    private /* synthetic */ void lambda$createTab$2(String name, Supplier stack, CreativeModeTab.Builder builder) {
        builder.m_257941_((Component)Component.m_237115_((String)("itemGroup." + name))).m_257737_(((Supplier)stack)::get).m_257501_((enabledFeatures, output, tab) -> this.tabItems.forEach(s -> {
            ITabExpander expander;
            List<ItemStack> itemsForTab;
            boolean todo = true;
            ItemStack st = (ItemStack)s.get();
            Item patt1900$temp = st.m_41720_();
            if (patt1900$temp instanceof ITabExpander && !(itemsForTab = (expander = (ITabExpander)patt1900$temp).getItemsForTab()).isEmpty()) {
                todo = false;
                itemsForTab.forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
            }
            if (todo) {
                output.m_246342_(st);
            }
        }));
    }
}

