/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.tileentity.AnnotationHolder;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.ValueHolder;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NamedEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnnotationTools {
    static AnnotationHolder createAnnotationHolder(BlockEntityType ttype, Class<? extends GenericTileEntity> clazz) {
        AnnotationHolder holder = new AnnotationHolder();
        AnnotationHolder.annotations.put(ttype, holder);
        AnnotationTools.scanServerCommands(clazz, holder);
        AnnotationTools.scanGuiValues(clazz, holder);
        AnnotationTools.scanCaps(clazz, holder);
        holder.valueMap.put(GenericTileEntity.VALUE_RSMODE.name(), new ValueHolder<GenericTileEntity, Integer>(GenericTileEntity.VALUE_RSMODE, GenericTileEntity::getRSModeInt, GenericTileEntity::setRSModeInt));
        return holder;
    }

    private static void scanCaps(Class<? extends GenericTileEntity> clazz, AnnotationHolder holder) {
        Field[] caps;
        for (Field cap : caps = FieldUtils.getFieldsWithAnnotation(clazz, Cap.class)) {
            Cap annotation = cap.getAnnotation(Cap.class);
            holder.capabilityList.add((Pair<Field, Cap>)Pair.of((Object)cap, (Object)annotation));
        }
    }

    private static void scanServerCommands(Class<? extends GenericTileEntity> clazz, AnnotationHolder holder) {
        Field[] commandFields;
        for (Field field : commandFields = FieldUtils.getFieldsWithAnnotation(clazz, ServerCommand.class)) {
            ServerCommand serverCommand = field.getAnnotation(ServerCommand.class);
            try {
                Object o = field.get(null);
                if (o instanceof Command) {
                    Command cmd = (Command)o;
                    holder.serverCommands.put(cmd.name(), cmd.cmd());
                    continue;
                }
                if (o instanceof ResultCommand) {
                    ResultCommand cmd = (ResultCommand)o;
                    holder.serverCommandsWithResult.put(cmd.name(), cmd.getCmd());
                    holder.clientCommands.put(cmd.name(), cmd.getClientCommand());
                    continue;
                }
                if (o instanceof ListCommand) {
                    ListCommand cmd = (ListCommand)o;
                    holder.serverCommandsWithListResult.put(cmd.name(), cmd.cmd());
                    holder.clientCommandsWithList.put(cmd.name(), cmd.clientCommand());
                    if (serverCommand.type() != Void.TYPE) {
                        ISerializer instance = AnnotationTools.getSerializer(serverCommand);
                        McJtyLib.registerListCommandInfo(cmd.name(), serverCommand.type(), instance.getDeserializer(), instance.getSerializer());
                    }
                    continue;
                }
                throw new IllegalStateException("Only use @ServerCommand with either a Command, a ListCommand or a ResultCommand!");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void scanGuiValues(Class<? extends GenericTileEntity> clazz, AnnotationHolder holder) {
        Field[] valFields;
        for (Field field : valFields = FieldUtils.getFieldsWithAnnotation(clazz, GuiValue.class)) {
            GuiValue val = field.getAnnotation(GuiValue.class);
            try {
                Value value = Modifier.isStatic(field.getModifiers()) ? (Value)field.get(null) : AnnotationTools.setupInstanceValue(field, val);
                holder.valueMap.put(value.key().name(), new ValueHolder(value.key(), value.supplier(), value.consumer()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private static Value setupInstanceValue(Field field, GuiValue val) {
        String name = val.name().isEmpty() ? field.getName() : val.name();
        if (field.getType().isEnum()) {
            if (!NamedEnum.class.isAssignableFrom(field.getType())) throw new RuntimeException("Field " + field.getName() + " is an enum but the enum doesn't extend NamedEnum!");
            return Value.createEnum((String)name, (NamedEnum[])AnnotationTools.getEnumFields(field.getType().asSubclass(NamedEnum.class)), te -> {
                try {
                    return (NamedEnum)FieldUtils.readField((Field)field, (Object)te, (boolean)true);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Problem accessing field '" + name + "'!");
                }
            }, (te, v) -> {
                try {
                    FieldUtils.writeField((Field)field, (Object)te, (Object)v, (boolean)true);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Problem accessing field '" + name + "'!");
                }
            });
        }
        Type type = AnnotationTools.guessType(field);
        return Value.create(name, type, te -> {
            try {
                return FieldUtils.readField((Field)field, (Object)te, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Problem accessing field '" + name + "'!");
            }
        }, (te, v) -> {
            try {
                FieldUtils.writeField((Field)field, (Object)te, (Object)v, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Problem accessing field '" + name + "'!");
            }
            te.m_6596_();
        });
    }

    private static NamedEnum[] getEnumFields(Class<? extends NamedEnum> clazz) {
        Field[] fields = FieldUtils.getAllFields(clazz);
        return (NamedEnum[])Arrays.stream(fields).filter(Field::isEnumConstant).map(f -> {
            try {
                return (NamedEnum)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Problem getting enum field '" + f.getName() + "'!");
            }
        }).toArray(NamedEnum[]::new);
    }

    private static Type guessType(Field field) {
        if (field.getType().isPrimitive()) {
            if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                return Type.INTEGER;
            }
            if (field.getType() == Short.TYPE || field.getType() == Short.class) {
                return Type.INTEGER;
            }
            if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                return Type.BOOLEAN;
            }
            if (field.getType() == Float.TYPE || field.getType() == Float.class) {
                return Type.FLOAT;
            }
            if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                return Type.DOUBLE;
            }
        }
        if (field.getType() == String.class) {
            return Type.STRING;
        }
        throw new RuntimeException("Can't guess type for field " + field.getName() + "!");
    }

    @Nonnull
    private static ISerializer getSerializer(ServerCommand serverCommand) throws IllegalAccessException {
        if (serverCommand.type() == Integer.class) {
            return new ISerializer.IntegerSerializer();
        }
        if (serverCommand.type() == String.class) {
            return new ISerializer.StringSerializer();
        }
        if (serverCommand.type() == BlockPos.class) {
            return new ISerializer.BlockPosSerializer();
        }
        if (serverCommand.type() == ItemStack.class) {
            return new ISerializer.ItemStackSerializer();
        }
        if (serverCommand.type() == FluidStack.class) {
            return new ISerializer.FluidStackSerializer();
        }
        Class<? extends ISerializer> serializer = serverCommand.serializer();
        try {
            return serializer.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Can't instantiate serializer!", e);
        }
    }
}

