/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.TriConsumer;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class NBTTools {
    public static BlockState readBlockState(CompoundTag tag) {
        return NbtUtils.m_247651_((HolderGetter)LevelTools.getOverworld().m_246945_(Registries.f_256747_), (CompoundTag)tag);
    }

    public static BlockState readBlockState(Level level, CompoundTag tag) {
        return NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)tag);
    }

    public static <T> T getInfoNBT(ItemStack stack, BiFunction<CompoundTag, String, T> getter, String name, T def) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return def;
        }
        CompoundTag info = tag.m_128469_("BlockEntityTag").m_128469_("Info");
        if (info.m_128441_(name)) {
            return getter.apply(info, name);
        }
        return def;
    }

    public static <T> T getBlockEntityNBT(ItemStack stack, BiFunction<CompoundTag, String, T> getter, String name, T def) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return def;
        }
        CompoundTag info = tag.m_128469_("BlockEntityTag");
        if (info.m_128441_(name)) {
            return getter.apply(info, name);
        }
        return def;
    }

    public static <T> void setInfoNBT(ItemStack stack, TriConsumer<CompoundTag, String, T> setter, String name, T value) {
        CompoundTag entityTag = stack.m_41698_("BlockEntityTag");
        CompoundTag info = entityTag.m_128469_("Info");
        setter.accept(info, name, value);
        entityTag.m_128365_("Info", (Tag)info);
    }

    public static boolean hasInfoNBT(ItemStack stack, String name) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        CompoundTag info = tag.m_128469_("BlockEntityTag").m_128469_("Info");
        return info.m_128441_(name);
    }

    public static int getInt(ItemStack stack, String name, int def) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return def;
        }
        if (tag.m_128441_(name)) {
            return tag.m_128451_(name);
        }
        return def;
    }

    public static float getFloat(ItemStack stack, String name, float def) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return def;
        }
        if (tag.m_128441_(name)) {
            return tag.m_128457_(name);
        }
        return def;
    }

    public static String getString(ItemStack stack, String name, String def) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return def;
        }
        if (tag.m_128441_(name)) {
            return tag.m_128461_(name);
        }
        return def;
    }

    @Nonnull
    public static Optional<CompoundTag> getTag(@Nonnull ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_());
    }

    @Nonnull
    public static <R> R mapTag(@Nonnull ItemStack stack, Function<CompoundTag, R> mapping, @Nonnull R def) {
        if (stack.m_41782_()) {
            return mapping.apply(stack.m_41783_());
        }
        return def;
    }

    @Nonnull
    public static Function<ItemStack, String> intGetter(String tag, Integer def) {
        return stack -> Integer.toString(NBTTools.mapTag(stack, nbt -> nbt.m_128451_(tag), def));
    }

    @Nonnull
    public static Function<ItemStack, String> strGetter(String tag, String def) {
        return stack -> NBTTools.mapTag(stack, nbt -> nbt.m_128461_(tag), def);
    }

    @Nonnull
    public static Stream<Tag> getListStream(CompoundTag compound, String tag) {
        ListTag list = compound.m_128437_("Items", 10);
        return StreamSupport.stream(list.spliterator(), false);
    }
}

