/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.handler;

import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class HudHandler {
    private static final ResourceLocation HUD_TEXTURE = new ResourceLocation("ironjetpacks", "textures/gui/hud.png");
    private static final IGuiOverlay HUD_OVERLAY = (gui, matrix, partialTick, width, height) -> {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && HudHandler.isVisible(mc)) {
            HudPos pos;
            ItemStack chest = JetpackUtils.getEquippedJetpack((Player)mc.f_91074_);
            Item item = chest.m_41720_();
            if (!chest.m_41619_() && item instanceof JetpackItem && (pos = HudHandler.getHudPos()) != null) {
                int xPos = (int)((double)pos.x / 0.33) - 18;
                int yPos = (int)((double)pos.y / 0.33) - 78;
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_TEXTURE);
                matrix.m_85836_();
                matrix.m_85841_(0.33f, 0.33f, 1.0f);
                Screen.m_93133_((PoseStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)28, (int)156, (int)256, (int)256);
                int i2 = HudHandler.getEnergyBarScaled(chest);
                Screen.m_93133_((PoseStack)matrix, (int)xPos, (int)(166 - i2 + yPos - 10), (float)28.0f, (float)(156 - i2), (int)28, (int)i2, (int)256, (int)256);
                matrix.m_85849_();
                String fuel = "\u00a77" + HudHandler.getFuelString(chest);
                String throttle = "\u00a77T: " + (int)(JetpackUtils.getThrottle(chest) * 100.0) + "%";
                String engine = "\u00a77E: " + HudHandler.getStatusString(JetpackUtils.isEngineOn(chest));
                String hover = "\u00a77H: " + HudHandler.getStatusString(JetpackUtils.isHovering(chest));
                if (pos.side == 1) {
                    mc.f_91062_.m_92750_(matrix, fuel, (float)(pos.x - 8 - mc.f_91062_.m_92895_(fuel)), (float)(pos.y - 21), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, fuel, (float)(pos.x - 8 - mc.f_91062_.m_92895_(throttle)), (float)(pos.y - 6), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, engine, (float)(pos.x - 8 - mc.f_91062_.m_92895_(engine)), (float)(pos.y + 4), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, hover, (float)(pos.x - 8 - mc.f_91062_.m_92895_(hover)), (float)(pos.y + 14), 0xF9FFFE);
                } else {
                    mc.f_91062_.m_92750_(matrix, fuel, (float)(pos.x + 6), (float)(pos.y - 21), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, throttle, (float)(pos.x + 6), (float)(pos.y - 6), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, engine, (float)(pos.x + 6), (float)(pos.y + 4), 0xF9FFFE);
                    mc.f_91062_.m_92750_(matrix, hover, (float)(pos.x + 6), (float)(pos.y + 14), 0xF9FFFE);
                }
            }
        }
    };

    @SubscribeEvent
    public void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "jetpack_hud", HUD_OVERLAY);
    }

    private static HudPos getHudPos() {
        Window window = Minecraft.m_91087_().m_91268_();
        int xOffset = (Integer)ModConfigs.HUD_OFFSET_X.get();
        int yOffset = (Integer)ModConfigs.HUD_OFFSET_Y.get();
        return switch ((Integer)ModConfigs.HUD_POSITION.get()) {
            case 0 -> new HudPos(10 + xOffset, 30 + yOffset, 0);
            case 1 -> new HudPos(10 + xOffset, window.m_85446_() / 2 + yOffset, 0);
            case 2 -> new HudPos(10 + xOffset, window.m_85446_() - 30 + yOffset, 0);
            case 3 -> new HudPos(window.m_85445_() - 8 - xOffset, 30 + yOffset, 1);
            case 4 -> new HudPos(window.m_85445_() - 8 - xOffset, window.m_85446_() / 2 + yOffset, 1);
            case 5 -> new HudPos(window.m_85445_() - 8 - xOffset, window.m_85446_() - 30 + yOffset, 1);
            default -> null;
        };
    }

    private static int getEnergyBarScaled(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (jetpack.creative) {
            return 156;
        }
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        int i = energy.getEnergyStored();
        int j = energy.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * 156L / (long)j : 0L);
    }

    private static String getFuelString(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (jetpack.creative) {
            return ModTooltips.INFINITE.buildString() + "\u00a77 FE";
        }
        int number = JetpackUtils.getEnergyStorage(stack).getEnergyStored();
        if (number >= 1000000000) {
            int big;
            int small = (number - (big = number / 1000000000) * 1000000000) / 100000000;
            return big + (String)(small != 0 ? "." + small : "") + "\u00a77G FE";
        }
        if (number >= 1000000) {
            int big;
            int small = (number - (big = number / 1000000) * 1000000) / 100000;
            return big + (String)(small != 0 ? "." + small : "") + "\u00a77M FE";
        }
        if (number >= 1000) {
            return number / 1000 + "\u00a77k FE";
        }
        return number + "\u00a77 FE";
    }

    private static String getStatusString(boolean on) {
        return on ? "\u00a7a" + ModTooltips.ON.buildString() : "\u00a7c" + ModTooltips.OFF.buildString();
    }

    private static boolean isVisible(Minecraft mc) {
        return (Boolean)ModConfigs.ENABLE_HUD.get() != false && ((Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get() != false || (Boolean)ModConfigs.SHOW_HUD_OVER_CHAT.get() == false && !(mc.f_91080_ instanceof ChatScreen)) && !mc.f_91066_.f_92062_ && !mc.f_91066_.f_92063_;
    }

    private static class HudPos {
        public int x;
        public int y;
        public int side;

        public HudPos(int x, int y, int side) {
            this.x = x;
            this.y = y;
            this.side = side;
        }
    }
}

