/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.mod.IModBlockHandler;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.mod.vanilla.BedBlockProxy;
import journeymap.client.mod.vanilla.FlowerBlockProxy;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.properties.CoreProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public final class VanillaBlockHandler
implements IModBlockHandler {
    ListMultimap<Material, BlockFlag> materialFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Class<?>, BlockFlag> blockClassFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    ListMultimap<Block, BlockFlag> blockFlags = MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    HashMap<Material, Float> materialAlphas = new HashMap();
    HashMap<Block, Float> blockAlphas = new HashMap();
    HashMap<Class<?>, Float> blockClassAlphas = new HashMap();
    private boolean mapPlants;
    private boolean mapPlantShadows;
    private boolean mapCrops;

    public VanillaBlockHandler() {
        this.preInitialize();
    }

    private void preInitialize() {
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        this.mapPlants = coreProperties.mapPlants.get();
        this.mapCrops = coreProperties.mapCrops.get();
        this.mapPlantShadows = coreProperties.mapPlantShadows.get();
        this.setFlags(Material.f_76282_, BlockFlag.Ignore);
        this.setFlags(Material.f_76296_, BlockFlag.Ignore);
        this.setFlags(Material.f_76275_, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(Material.f_76315_, BlockFlag.Grass);
        if (coreProperties.caveIgnoreGlass.get().booleanValue()) {
            this.setFlags(Material.f_76275_, BlockFlag.OpenToSky);
        }
        this.setFlags(Material.f_76307_, Float.valueOf(1.0f), BlockFlag.NoShadow);
        this.setFlags(Material.f_76305_, Float.valueOf(0.25f), BlockFlag.Water, BlockFlag.NoShadow);
        this.setFlags(Material.f_76320_, BlockFlag.NoTopo);
        this.setFlags(Material.f_76302_, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(Material.f_76300_, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(Blocks.f_50571_, BlockFlag.NoTopo);
        this.setFlags(Blocks.f_50570_, BlockFlag.NoTopo);
        this.materialAlphas.put(Material.f_76276_, Float.valueOf(0.8f));
        this.materialAlphas.put(Material.f_76316_, Float.valueOf(0.8f));
        this.setFlags(Blocks.f_50183_, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(Blocks.f_50083_, BlockFlag.NoShadow);
        this.setFlags(Blocks.f_50155_, BlockFlag.OpenToSky);
        this.setFlags(Blocks.f_50125_, BlockFlag.NoTopo, BlockFlag.NoShadow);
        this.setFlags(Blocks.f_50267_, BlockFlag.Ignore);
        this.setFlags(Blocks.f_50266_, BlockFlag.Ignore);
        this.setFlags(Blocks.f_50033_, BlockFlag.OpenToSky, BlockFlag.NoShadow);
        this.setFlags(FenceBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(FenceGateBlock.class, Float.valueOf(0.4f), BlockFlag.Transparency);
        this.setFlags(GrassBlock.class, BlockFlag.Grass);
        this.setFlags(LeavesBlock.class, BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoTopo);
        this.setFlags(RailBlock.class, BlockFlag.NoShadow, BlockFlag.NoTopo);
        this.setFlags(RedStoneWireBlock.class, BlockFlag.Ignore);
        this.setFlags(TorchBlock.class, BlockFlag.Ignore);
        this.setFlags(VineBlock.class, Float.valueOf(0.2f), BlockFlag.OpenToSky, BlockFlag.Foliage, BlockFlag.NoShadow);
        this.setFlags(BushBlock.class, BlockFlag.Plant);
        this.setFlags(CactusBlock.class, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(SugarCaneBlock.class, BlockFlag.Plant, BlockFlag.NoTopo);
        this.setFlags(SeagrassBlock.class, BlockFlag.Plant, BlockFlag.NoTopo);
    }

    @Override
    public void initialize(BlockMD blockMD) {
        String uid;
        Block block = blockMD.getBlockState().m_60734_();
        Material material = blockMD.getBlockState().m_60767_();
        BlockState blockState = blockMD.getBlockState();
        if (blockState.m_60799_() == RenderShape.INVISIBLE && !(blockState.m_60734_() instanceof LiquidBlock)) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
        blockMD.addFlags(this.materialFlags.get((Object)material));
        Float alpha = this.materialAlphas.get(material);
        if (alpha != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        if (this.blockFlags.containsKey((Object)block)) {
            blockMD.addFlags(this.blockFlags.get((Object)block));
        }
        if ((alpha = this.blockAlphas.get(block)) != null) {
            blockMD.setAlpha(alpha.floatValue());
        }
        for (Class parentClass : this.blockClassFlags.keys()) {
            if (!parentClass.isAssignableFrom(block.getClass())) continue;
            blockMD.addFlags(this.blockClassFlags.get((Object)parentClass));
            alpha = this.blockClassAlphas.get(parentClass);
            if (alpha == null) break;
            blockMD.setAlpha(alpha.floatValue());
            break;
        }
        if (block instanceof LiquidBlock) {
            blockMD.addFlags(BlockFlag.Fluid, BlockFlag.NoShadow);
            blockMD.setAlpha(0.7f);
        }
        if (material == Material.f_76275_ && (BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_().equalsIgnoreCase("glowstone") || block instanceof LanternBlock || block instanceof BeaconBlock || block.equals(Blocks.f_50141_))) {
            blockMD.removeFlags(BlockFlag.OpenToSky, BlockFlag.Transparency);
            blockMD.setAlpha(1.0f);
        }
        if (block instanceof BushBlock && blockMD.getBlockState().m_61147_().contains(DoublePlantBlock.f_52858_) && blockMD.getBlockState().m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
            blockMD.addFlags(BlockFlag.Ignore);
        }
        if (block instanceof CropBlock) {
            blockMD.addFlags(BlockFlag.Crop);
        }
        if (block instanceof FlowerBlock || block instanceof FlowerPotBlock) {
            blockMD.setBlockColorProxy(FlowerBlockProxy.INSTANCE);
        }
        if (block instanceof BedBlock) {
            blockMD.setBlockColorProxy(BedBlockProxy.INSTANCE);
        }
        if ((uid = blockMD.getBlockId()).equals("minecraft:bell")) {
            blockMD.setBlockColorProxy(ModBlockDelegate.INSTANCE.getMaterialBlockColorProxy());
            return;
        }
        if (blockMD.isVanillaBlock()) {
            return;
        }
        if (uid.toLowerCase().contains("torch")) {
            blockMD.addFlags(BlockFlag.Ignore);
            return;
        }
    }

    public void postInitialize(BlockMD blockMD) {
        if (blockMD.hasFlag(BlockFlag.Crop)) {
            blockMD.removeFlags(BlockFlag.Plant);
        }
        if (blockMD.hasAnyFlag(BlockMD.FlagsPlantAndCrop)) {
            if (!this.mapPlants && blockMD.hasFlag(BlockFlag.Plant) || !this.mapCrops && blockMD.hasFlag(BlockFlag.Crop)) {
                blockMD.addFlags(BlockFlag.Ignore);
            } else if (!this.mapPlantShadows) {
                blockMD.addFlags(BlockFlag.NoShadow);
            }
        }
        if (blockMD.isIgnore()) {
            blockMD.removeFlags(BlockMD.FlagsNormal);
        }
    }

    private void setFlags(Material material, BlockFlag ... flags) {
        this.materialFlags.putAll((Object)material, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Material material, Float alpha, BlockFlag ... flags) {
        this.materialAlphas.put(material, alpha);
        this.setFlags(material, flags);
    }

    private void setFlags(Class parentClass, BlockFlag ... flags) {
        this.blockClassFlags.putAll((Object)parentClass, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Class parentClass, Float alpha, BlockFlag ... flags) {
        this.blockClassAlphas.put(parentClass, alpha);
        this.setFlags(parentClass, flags);
    }

    private void setFlags(Block block, BlockFlag ... flags) {
        this.blockFlags.putAll((Object)block, new ArrayList<BlockFlag>(Arrays.asList(flags)));
    }

    private void setFlags(Block block, Float alpha, BlockFlag ... flags) {
        this.blockAlphas.put(block, alpha);
        this.setFlags(block, flags);
    }
}

