/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.util.FormattedCharSequence;

public class ScrollListPane<T extends Slot>
extends AbstractSelectionList {
    private final JmUI parent;
    public SlotMetadata lastTooltipMetadata;
    public List<FormattedCharSequence> lastTooltip;
    public long lastTooltipTime;
    public long hoverDelay = 400L;
    protected int hpad = 12;
    private List<T> rootSlots;
    private SlotMetadata lastPressed;
    protected int lastClickedIndex;
    protected int scrollbarX;
    protected int listWidth;
    private boolean alignTop;

    public ScrollListPane(JmUI parent, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.parent = parent;
        this.m_93437_(width, height, top, bottom);
    }

    public void setHover(boolean hover) {
        for (Slot slot : this.rootSlots) {
            slot.displayHover(hover);
        }
    }

    public void m_93437_(int width, int height, int top, int bottom) {
        super.m_93437_(width, height, top, bottom);
        this.scrollbarX = this.f_93388_ - this.hpad;
        this.listWidth = this.f_93388_ - this.hpad * 4;
    }

    public void setSlots(List<T> slots) {
        this.rootSlots = slots;
        this.updateSlots();
    }

    public List<T> getRootSlots() {
        return this.rootSlots;
    }

    public void updateSlots() {
        int sizeBefore = this.m_5773_();
        this.m_6702_().clear();
        int columnWidth = 0;
        for (Slot slot : this.rootSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
            super.m_7085_((AbstractSelectionList.Entry)slot);
            List<? extends Slot> childSlots = slot.getChildSlots(this.listWidth, columnWidth);
            if (childSlots == null || childSlots.isEmpty()) continue;
            for (Slot slot2 : childSlots) {
                super.m_7085_((AbstractSelectionList.Entry)slot2);
            }
        }
        int sizeAfter = this.m_5773_();
        if (sizeBefore < sizeAfter) {
            this.m_93429_(-(sizeAfter * this.f_93387_));
            this.m_93429_(this.lastClickedIndex * this.f_93387_);
        }
    }

    public void scrollTo(Slot slot) {
        this.m_93429_(-(this.m_6702_().size() * this.f_93389_));
        this.m_93429_(this.m_6702_().indexOf((Object)slot) * this.f_93389_);
    }

    public boolean m_7987_(int index) {
        return super.m_7987_(index);
    }

    protected int m_7610_(int slotIndex) {
        return super.m_7610_(slotIndex);
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        try {
            SlotMetadata tooltipMetadata;
            super.m_93488_(false);
            Slot slot = (Slot)this.m_93412_(mouseX, mouseY);
            if (slot != null && (tooltipMetadata = slot.getCurrentTooltip()) != null && !tooltipMetadata.getTooltip().equals(this.lastTooltip)) {
                this.lastTooltipMetadata = tooltipMetadata;
                this.lastTooltip = tooltipMetadata.getTooltip();
                this.lastTooltipTime = System.currentTimeMillis();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_239227_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_239227_(poseStack, mouseX, mouseY, partialTicks);
    }

    public int m_5759_() {
        return this.listWidth;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clicked = super.m_6375_(mouseX, mouseY, button);
        if (super.m_5953_(mouseX, mouseY)) {
            Slot slot = (Slot)this.m_93412_(mouseX, mouseY);
            if (slot == null) {
                return false;
            }
            this.lastClickedIndex = this.m_6702_().indexOf((Object)slot);
            this.lastPressed = slot.getLastPressed();
            if (slot instanceof CategorySlot) {
                this.updateSlots();
            }
        }
        return clicked;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        for (int slotIndex = 0; slotIndex < this.m_5773_(); ++slotIndex) {
            Slot slot;
            if (slotIndex != this.lastClickedIndex || !(slot = this.getSlot(this.lastClickedIndex)).m_6348_(mouseX, mouseY, mouseButton)) continue;
            this.lastPressed = null;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.m_6702_().isEmpty()) {
            return false;
        }
        if (this.lastClickedIndex > -1 && this.getSlot(this.lastClickedIndex) != null && this.getSlot(this.lastClickedIndex).m_7979_(mouseX, mouseY, button, mouseDX, mouseDY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public Slot getSlot(int index) {
        if (super.m_5773_() > index) {
            return (Slot)((Object)this.m_6702_().get(index));
        }
        return null;
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public void resetLastPressed() {
        this.lastPressed = null;
    }

    public Slot getLastPressedParentSlot() {
        if (this.lastPressed != null) {
            for (Slot slot : this.rootSlots) {
                if (!slot.contains(this.lastPressed)) continue;
                return slot;
            }
        }
        return null;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        for (int slotIndex = 0; slotIndex < this.m_5773_(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).m_5534_(typedChar, keyCode);
        }
        return false;
    }

    public boolean m_7933_(int key, int value, int modifier) {
        for (int slotIndex = 0; slotIndex < this.m_5773_(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).m_7933_(key, value, modifier);
        }
        return false;
    }

    protected int m_5756_() {
        return this.scrollbarX;
    }

    protected void m_7733_(PoseStack poseStack) {
        this.m_93179_(poseStack, 0, 0, this.f_93388_, this.f_93389_, -1072689136, -804253680);
    }

    protected int m_5775_() {
        int contentHeight = super.m_5775_();
        if (this.alignTop) {
            contentHeight = Math.max(this.getBottom() - this.getTop() - 4, contentHeight);
        }
        return contentHeight;
    }

    public int getTop() {
        return this.f_93390_;
    }

    public int getBottom() {
        return this.f_93391_;
    }

    public int getHeight() {
        return this.f_93389_;
    }

    public void setAlignTop(boolean alignTop) {
        this.alignTop = alignTop;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

