/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.events;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.LoaderHooks;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.PlayerData;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.PermissionsManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerEventHandler {
    private static int playerUpdateTicks = 5;

    public void onServerTickEvent(Level world) {
        if (((ServerOption)PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadar.get()).enabled()) {
            playerUpdateTicks = PropertiesManager.getInstance().getGlobalProperties().worldPlayerRadarUpdateTime.get();
            if (world != null && world.m_46468_() % (long)playerUpdateTicks == 0L) {
                this.sendPlayersOnRadarToPlayers();
            }
        }
    }

    public void onEntityJoinWorldEvent(Entity entity) {
        if (entity instanceof ServerPlayer) {
            this.sendConfigsToPlayer((ServerPlayer)entity);
        }
    }

    public void onPlayerLoggedInEvent(Player player) {
        if (player instanceof ServerPlayer) {
            Journeymap.getInstance().getDispatcher().sendHandshakePacket((ServerPlayer)player, Journeymap.JM_VERSION.toJson());
            this.sendConfigsToPlayer((ServerPlayer)player);
            PlayerData.getPlayerData().getPlayer((ServerPlayer)player);
        }
    }

    public void sendConfigsToPlayer(ServerPlayer player) {
        PermissionsManager.getInstance().sendPermissions(player);
    }

    private void sendPlayersOnRadarToPlayers() {
        GlobalProperties prop = PropertiesManager.getInstance().getGlobalProperties();
        ServerOption option = (ServerOption)prop.worldPlayerRadar.get();
        for (ServerPlayer player : LoaderHooks.getServer().m_6846_().m_11314_()) {
            boolean playerRadarEnabled = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension((Entity)player)).playerRadarEnabled.get();
            boolean receiverOp = Journeymap.isOp((Player)player);
            if ((!option.enabled() || !playerRadarEnabled) && (!option.canOps() || !receiverOp)) continue;
            try {
                this.sendPlayerTrackingData(player, receiverOp);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void sendPlayerTrackingData(ServerPlayer entityPlayerMP, boolean receiverOp) {
        List serverPlayers = entityPlayerMP.f_8924_.m_6846_().m_11314_();
        if (serverPlayers != null && serverPlayers.size() > 1) {
            GlobalProperties properties = PropertiesManager.getInstance().getGlobalProperties();
            for (ServerPlayer radarPlayer : serverPlayers) {
                boolean sameDimension = entityPlayerMP.f_19853_.m_46472_().equals((Object)radarPlayer.f_19853_.m_46472_());
                boolean sneaking = radarPlayer.m_6144_();
                boolean invisible = radarPlayer.m_20177_((Player)entityPlayerMP);
                boolean hideOp = properties.hideOps.get();
                boolean hideSpectators = properties.hideSpectators.get() != false && radarPlayer.m_5833_();
                boolean seeUnderground = this.seeUnderground(radarPlayer, receiverOp);
                boolean visible = sameDimension && (receiverOp && seeUnderground || !hideOp && !sneaking && !hideSpectators && !invisible && seeUnderground);
                visible = visible && this.isSelfHidden(radarPlayer, properties, receiverOp);
                UUID playerId = radarPlayer.m_20148_();
                if (entityPlayerMP.m_20148_().equals(playerId)) continue;
                Journeymap.getInstance().getDispatcher().sendPlayerLocationPacket(entityPlayerMP, radarPlayer, visible);
            }
        }
    }

    private boolean isSelfHidden(ServerPlayer radarPlayer, GlobalProperties properties, boolean receiverOp) {
        if (((ServerOption)properties.allowMultiplayerSettings.get()).hasOption(receiverOp) || ServerOption.OPS.equals(properties.allowMultiplayerSettings.get())) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(radarPlayer);
            boolean hiddenUnderground = player.isHiddenUnderground() && this.isUnderground(radarPlayer) && !Level.f_46429_.equals((Object)radarPlayer.f_19853_.m_46472_());
            return receiverOp || player.isVisible() && !hiddenUnderground;
        }
        return true;
    }

    private boolean seeUnderground(ServerPlayer player, boolean isOp) {
        ServerOption seeUnderground = (ServerOption)PropertiesManager.getInstance().getGlobalProperties().seeUndergroundPlayers.get();
        if (!Level.f_46429_.equals((Object)player.f_19853_.m_46472_()) && !ServerOption.ALL.equals(seeUnderground) && this.isUnderground(player)) {
            return seeUnderground.hasOption(isOp);
        }
        return true;
    }

    private boolean isUnderground(ServerPlayer player) {
        BlockPos headPos = new BlockPos(player.m_146892_());
        return !player.m_9236_().m_45527_(headPos);
    }
}

